/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.plugin.hive.HiveType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveColumnProjectionInfo {
    private final List<Integer> dereferenceIndices;
    private final List<String> dereferenceNames;
    private final HiveType hiveType;
    private final Type type;
    private final String partialName;

    @JsonCreator
    public HiveColumnProjectionInfo(@JsonProperty(value="dereferenceIndices") List<Integer> dereferenceIndices, @JsonProperty(value="dereferenceNames") List<String> dereferenceNames, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="type") Type type) {
        this.dereferenceIndices = Objects.requireNonNull(dereferenceIndices, "dereferenceIndices is null");
        this.dereferenceNames = Objects.requireNonNull(dereferenceNames, "dereferenceNames is null");
        Preconditions.checkArgument((dereferenceIndices.size() > 0 ? 1 : 0) != 0, (Object)"dereferenceIndices should not be empty");
        Preconditions.checkArgument((dereferenceIndices.size() == dereferenceNames.size() ? 1 : 0) != 0, (Object)"dereferenceIndices and dereferenceNames should have the same sizes");
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.partialName = HiveColumnProjectionInfo.generatePartialName(dereferenceNames);
    }

    public String getPartialName() {
        return this.partialName;
    }

    @JsonProperty
    public List<Integer> getDereferenceIndices() {
        return this.dereferenceIndices;
    }

    @JsonProperty
    public List<String> getDereferenceNames() {
        return this.dereferenceNames;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.dereferenceIndices, this.dereferenceNames, this.hiveType, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnProjectionInfo other = (HiveColumnProjectionInfo)obj;
        return Objects.equals(this.dereferenceIndices, other.dereferenceIndices) && Objects.equals(this.dereferenceNames, other.dereferenceNames) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals(this.type, other.type);
    }

    public static String generatePartialName(List<String> dereferenceNames) {
        return dereferenceNames.stream().map(name -> "#" + name).collect(Collectors.joining());
    }
}

