/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.PartitionOfflineException;
import io.trino.plugin.hive.TableOfflineException;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class MetastoreUtil {
    private static final String HIVE_PARTITION_VALUE_WILDCARD = "";

    private MetastoreUtil() {
    }

    public static Properties getHiveSchema(Table table) {
        return MetastoreUtil.getHiveSchema(table.getStorage(), table.getDataColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    public static Properties getHiveSchema(Partition partition, Table table) {
        return MetastoreUtil.getHiveSchema(partition.getStorage(), partition.getColumns(), table.getDataColumns(), table.getParameters(), table.getDatabaseName(), table.getTableName(), table.getPartitionColumns());
    }

    private static Properties getHiveSchema(Storage sd, List<Column> dataColumns, List<Column> tableDataColumns, Map<String, String> parameters, String databaseName, String tableName, List<Column> partitionKeys) {
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", sd.getStorageFormat().getInputFormat());
        schema.setProperty("file.outputformat", sd.getStorageFormat().getOutputFormat());
        schema.setProperty("name", databaseName + "." + tableName);
        schema.setProperty("location", sd.getLocation());
        if (sd.getBucketProperty().isPresent()) {
            schema.setProperty("bucket_field_name", Joiner.on((String)",").join(sd.getBucketProperty().get().getBucketedBy()));
            schema.setProperty("bucket_count", Integer.toString(sd.getBucketProperty().get().getBucketCount()));
        } else {
            schema.setProperty("bucket_count", "0");
        }
        for (Map.Entry<String, String> param : sd.getSerdeParameters().entrySet()) {
            schema.setProperty(param.getKey(), param.getValue() != null ? param.getValue() : HIVE_PARTITION_VALUE_WILDCARD);
        }
        schema.setProperty("serialization.lib", sd.getStorageFormat().getSerDe());
        StringBuilder columnNameBuilder = new StringBuilder();
        StringBuilder columnTypeBuilder = new StringBuilder();
        StringBuilder columnCommentBuilder = new StringBuilder();
        boolean first = true;
        for (Column column : tableDataColumns) {
            if (!first) {
                columnNameBuilder.append(",");
                columnTypeBuilder.append(":");
                columnCommentBuilder.append('\u0000');
            }
            columnNameBuilder.append(column.getName());
            columnTypeBuilder.append(column.getType());
            columnCommentBuilder.append(column.getComment().orElse(HIVE_PARTITION_VALUE_WILDCARD));
            first = false;
        }
        String columnNames = columnNameBuilder.toString();
        String columnTypes = columnTypeBuilder.toString();
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypes);
        schema.setProperty("columns.comments", columnCommentBuilder.toString());
        schema.setProperty("serialization.ddl", MetastoreUtil.toThriftDdl(tableName, dataColumns));
        StringBuilder partString = new StringBuilder();
        String partStringSep = HIVE_PARTITION_VALUE_WILDCARD;
        StringBuilder partTypesString = new StringBuilder();
        String partTypesStringSep = HIVE_PARTITION_VALUE_WILDCARD;
        for (Column column : partitionKeys) {
            partString.append(partStringSep);
            partString.append(column.getName());
            partTypesString.append(partTypesStringSep);
            partTypesString.append(column.getType().getHiveTypeName().toString());
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
            partTypesStringSep = ":";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString.toString());
            schema.setProperty("partition_columns.types", partTypesString.toString());
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static ProtectMode getProtectMode(Partition partition) {
        return MetastoreUtil.getProtectMode(partition.getParameters());
    }

    public static ProtectMode getProtectMode(Table table) {
        return MetastoreUtil.getProtectMode(table.getParameters());
    }

    public static boolean isAvroTableWithSchemaSet(Table table) {
        return HiveStorageFormat.AVRO.getSerDe().equals(table.getStorage().getStorageFormat().getSerDeNullable()) && (table.getParameters().get("avro.schema.url") != null || table.getStorage().getSerdeParameters().get("avro.schema.url") != null);
    }

    public static String makePartitionName(Table table, Partition partition) {
        return MetastoreUtil.makePartitionName(table.getPartitionColumns(), partition.getValues());
    }

    public static String makePartitionName(List<Column> partitionColumns, List<String> values) {
        return MetastoreUtil.toPartitionName(partitionColumns.stream().map(Column::getName).collect(Collectors.toList()), values);
    }

    public static String toPartitionName(List<String> names, List<String> values) {
        Preconditions.checkArgument((names.size() == values.size() ? 1 : 0) != 0, (Object)"partition value count must match partition column count");
        Preconditions.checkArgument((boolean)values.stream().allMatch(Objects::nonNull), (Object)"partition value must not be null");
        return FileUtils.makePartName(names, values);
    }

    public static String getPartitionLocation(Table table, Optional<Partition> partition) {
        if (partition.isEmpty()) {
            return table.getStorage().getLocation();
        }
        return partition.get().getStorage().getLocation();
    }

    private static String toThriftDdl(String structName, List<Column> columns) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (Column column : columns) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(ColumnType.typeToThriftType((String)column.getType().getHiveTypeName().toString()));
            ddl.append(' ');
            ddl.append(column.getName());
        }
        ddl.append("}");
        return ddl.toString();
    }

    private static ProtectMode getProtectMode(Map<String, String> parameters) {
        if (!parameters.containsKey(ProtectMode.PARAMETER_NAME)) {
            return new ProtectMode();
        }
        return ProtectMode.getProtectModeFromString((String)parameters.get(ProtectMode.PARAMETER_NAME));
    }

    public static void verifyOnline(SchemaTableName tableName, Optional<String> partitionName, ProtectMode protectMode, Map<String, String> parameters) {
        if (protectMode.offline) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), false, null);
            }
            throw new TableOfflineException(tableName, false, null);
        }
        String prestoOffline = parameters.get("presto_offline");
        if (!Strings.isNullOrEmpty((String)prestoOffline)) {
            if (partitionName.isPresent()) {
                throw new PartitionOfflineException(tableName, partitionName.get(), true, prestoOffline);
            }
            throw new TableOfflineException(tableName, true, prestoOffline);
        }
    }

    public static void verifyCanDropColumn(HiveMetastore metastore, HiveIdentity identity, String databaseName, String tableName, String columnName) {
        Table table = metastore.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        if (table.getPartitionColumns().stream().anyMatch(column -> column.getName().equals(columnName))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop partition columns");
        }
        if (table.getDataColumns().size() <= 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot drop the only non-partition column in a table");
        }
    }

    public static PrincipalPrivileges buildInitialPrivilegeSet(String tableOwner) {
        HivePrincipal owner = new HivePrincipal(PrincipalType.USER, tableOwner);
        return new PrincipalPrivileges((Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.builder().put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.INSERT, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.UPDATE, true, owner, owner)).put((Object)tableOwner, (Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.DELETE, true, owner, owner)).build(), (Multimap<String, HivePrivilegeInfo>)ImmutableMultimap.of());
    }

    public static Optional<List<String>> partitionKeyFilterToStringList(List<String> columnNames, TupleDomain<String> partitionKeysFilter, boolean assumeCanonicalPartitionKeys) {
        if (partitionKeysFilter.isNone()) {
            return Optional.empty();
        }
        Map domainMap = (Map)partitionKeysFilter.getDomains().orElseThrow(VerifyException::new);
        return Optional.of((List)columnNames.stream().map(cn -> MetastoreUtil.domainToString((Domain)domainMap.get(cn), assumeCanonicalPartitionKeys, HIVE_PARTITION_VALUE_WILDCARD)).collect(ImmutableList.toImmutableList()));
    }

    private static String domainToString(Domain domain, boolean assumeCanonicalPartitionKeys, String partitionWildcardString) {
        if (domain != null && domain.isNullableSingleValue()) {
            return MetastoreUtil.sqlScalarToStringForParts(domain.getType(), domain.getNullableSingleValue(), assumeCanonicalPartitionKeys, partitionWildcardString);
        }
        return partitionWildcardString;
    }

    public static boolean canConvertSqlTypeToStringForParts(Type type, boolean assumeCanonicalPartitionKeys) {
        return !(type instanceof TimestampType) && (type instanceof CharType || type instanceof VarcharType || assumeCanonicalPartitionKeys);
    }

    public static String sqlScalarToStringForParts(Type type, Object value, boolean assumeCanonicalPartitionKeys, String partitionWildcardString) {
        if (!MetastoreUtil.canConvertSqlTypeToStringForParts(type, assumeCanonicalPartitionKeys)) {
            return partitionWildcardString;
        }
        return MetastoreUtil.sqlScalarToString(type, value, HIVE_PARTITION_VALUE_WILDCARD);
    }

    public static String sqlScalarToString(Type type, Object value, String nullString) {
        if (value == null) {
            return nullString;
        }
        if (type instanceof CharType) {
            Slice slice = (Slice)value;
            return Chars.padSpaces((Slice)slice, (CharType)((CharType)type)).toStringUtf8();
        }
        if (type instanceof VarcharType) {
            Slice slice = (Slice)value;
            return slice.toStringUtf8();
        }
        if (type instanceof DecimalType && !((DecimalType)type).isShort()) {
            Slice slice = (Slice)value;
            return Decimals.toString((Slice)slice, (int)((DecimalType)type).getScale());
        }
        if (type instanceof DecimalType && ((DecimalType)type).isShort()) {
            return Decimals.toString((long)((Long)value), (int)((DecimalType)type).getScale());
        }
        if (type instanceof DateType) {
            DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.date().withZoneUTC();
            return dateTimeFormatter.print(TimeUnit.DAYS.toMillis((Long)value));
        }
        if (type instanceof TimestampType) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "TimestampType conversion to scalar expressions is not supported");
        }
        if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof DoubleType || type instanceof RealType || type instanceof BooleanType) {
            return value.toString();
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
    }

    public static TupleDomain<String> computePartitionKeyFilter(List<HiveColumnHandle> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate) {
        Preconditions.checkArgument((boolean)effectivePredicate.getDomains().isPresent());
        LinkedHashMap<String, Domain> domains = new LinkedHashMap<String, Domain>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            String name = partitionKey.getName();
            Domain domain = (Domain)((Map)effectivePredicate.getDomains().get()).get(partitionKey);
            if (domain == null) continue;
            domains.put(name, domain);
        }
        return TupleDomain.withColumnDomains(domains);
    }

    public static Map<String, String> adjustRowCount(Map<String, String> parameters, String description, long rowCountAdjustment) {
        String existingRowCount = parameters.get("numRows");
        if (existingRowCount == null) {
            return parameters;
        }
        Long count = Longs.tryParse((String)existingRowCount);
        Objects.requireNonNull(count, String.format("For %s, the existing row count (%s) is not a digit string", description, existingRowCount));
        long newRowCount = count + rowCountAdjustment;
        Preconditions.checkArgument((newRowCount >= 0L ? 1 : 0) != 0, (String)"For %s, the subtracted row count (%s) is less than zero, existing count %s, rows deleted %s", (Object)description, (Object)newRowCount, (Object)existingRowCount, (Object)rowCountAdjustment);
        HashMap<String, String> copiedParameters = new HashMap<String, String>(parameters);
        copiedParameters.put("numRows", String.valueOf(newRowCount));
        return ImmutableMap.copyOf(copiedParameters);
    }
}

