/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreDecorator;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.ReentrantBoundedExecutor;
import io.trino.spi.NodeManager;
import java.util.Optional;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CachingHiveMetastoreModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HiveMetastoreDecorator.class);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
    }

    @Provides
    @Singleton
    public HiveMetastore createCachingHiveMetastore(NodeManager nodeManager, @ForCachingHiveMetastore HiveMetastore delegate, CachingHiveMetastoreConfig config, CatalogName catalogName, Optional<HiveMetastoreDecorator> hiveMetastoreDecorator) {
        HiveMetastore decoratedDelegate = hiveMetastoreDecorator.map(decorator -> decorator.decorate(delegate)).orElse(delegate);
        if (!nodeManager.getCurrentNode().isCoordinator()) {
            return decoratedDelegate;
        }
        ReentrantBoundedExecutor executor = new ReentrantBoundedExecutor(Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metastore-" + catalogName + "-%s"))), config.getMaxMetastoreRefreshThreads());
        return CachingHiveMetastore.cachingHiveMetastore(decoratedDelegate, executor, config);
    }
}

