/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.amazonaws.services.glue.model.ColumnStatistics;
import com.amazonaws.services.glue.model.ColumnStatisticsData;
import com.amazonaws.services.glue.model.ColumnStatisticsType;
import com.amazonaws.services.glue.model.DateColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalColumnStatisticsData;
import com.amazonaws.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.DeleteColumnStatisticsForTableRequest;
import com.amazonaws.services.glue.model.DoubleColumnStatisticsData;
import com.amazonaws.services.glue.model.EntityNotFoundException;
import com.amazonaws.services.glue.model.GetColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.GetColumnStatisticsForPartitionResult;
import com.amazonaws.services.glue.model.GetColumnStatisticsForTableRequest;
import com.amazonaws.services.glue.model.GetColumnStatisticsForTableResult;
import com.amazonaws.services.glue.model.LongColumnStatisticsData;
import com.amazonaws.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import com.amazonaws.services.glue.model.UpdateColumnStatisticsForTableRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.converter.GlueStatConverter;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class DefaultGlueColumnStatisticsProvider
implements GlueColumnStatisticsProvider {
    private static final int GLUE_COLUMN_READ_STAT_PAGE_SIZE = 100;
    private static final int GLUE_COLUMN_WRITE_STAT_PAGE_SIZE = 25;
    private final AWSGlueAsync glueClient;
    private final String catalogId;
    private final Executor readExecutor;
    private final Executor writeExecutor;

    public DefaultGlueColumnStatisticsProvider(AWSGlueAsync glueClient, String catalogId, Executor readExecutor, Executor writeExecutor) {
        this.glueClient = glueClient;
        this.catalogId = catalogId;
        this.readExecutor = readExecutor;
        this.writeExecutor = writeExecutor;
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics(type);
    }

    @Override
    public Map<String, HiveColumnStatistics> getTableColumnStatistics(Table table) {
        try {
            List<String> columnNames = this.getAllColumns(table);
            List columnChunks = Lists.partition(columnNames, (int)100);
            List getStatsFutures = (List)columnChunks.stream().map(partialColumns -> CompletableFuture.supplyAsync(() -> {
                GetColumnStatisticsForTableRequest request = new GetColumnStatisticsForTableRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withColumnNames((Collection)partialColumns);
                return this.glueClient.getColumnStatisticsForTable(request);
            }, this.readExecutor)).collect(ImmutableList.toImmutableList());
            HiveBasicStatistics tableStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
            ImmutableMap.Builder columnStatsMapBuilder = ImmutableMap.builder();
            for (CompletableFuture future : getStatsFutures) {
                GetColumnStatisticsForTableResult tableColumnsStats = (GetColumnStatisticsForTableResult)MoreFutures.getFutureValue((Future)future, TrinoException.class);
                for (ColumnStatistics columnStatistics : tableColumnsStats.getColumnStatisticsList()) {
                    columnStatsMapBuilder.put((Object)columnStatistics.getColumnName(), (Object)GlueStatConverter.fromGlueColumnStatistics(columnStatistics.getStatisticsData(), tableStatistics.getRowCount()));
                }
            }
            return columnStatsMapBuilder.build();
        }
        catch (RuntimeException ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)ex);
        }
    }

    private Optional<Map<String, HiveColumnStatistics>> getPartitionColumnStatisticsIfPresent(Partition partition) {
        try {
            return Optional.of(this.getPartitionColumnStatistics(partition));
        }
        catch (TrinoException ex) {
            if (ex.getErrorCode() == HiveErrorCode.HIVE_PARTITION_NOT_FOUND.toErrorCode()) {
                return Optional.empty();
            }
            throw ex;
        }
    }

    @Override
    public Map<String, HiveColumnStatistics> getPartitionColumnStatistics(Partition partition) {
        try {
            List columnChunks = Lists.partition(partition.getColumns(), (int)100);
            List getStatsFutures = (List)columnChunks.stream().map(partialColumns -> CompletableFuture.supplyAsync(() -> {
                List columnsNames = (List)partialColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
                GetColumnStatisticsForPartitionRequest request = new GetColumnStatisticsForPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(partition.getDatabaseName()).withTableName(partition.getTableName()).withColumnNames((Collection)columnsNames).withPartitionValues(partition.getValues());
                return this.glueClient.getColumnStatisticsForPartition(request);
            }, this.readExecutor)).collect(ImmutableList.toImmutableList());
            HiveBasicStatistics tableStatistics = ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters());
            ImmutableMap.Builder columnStatsMapBuilder = ImmutableMap.builder();
            for (CompletableFuture future : getStatsFutures) {
                GetColumnStatisticsForPartitionResult partitionColumnStats = (GetColumnStatisticsForPartitionResult)MoreFutures.getFutureValue((Future)future, TrinoException.class);
                for (ColumnStatistics columnStatistics : partitionColumnStats.getColumnStatisticsList()) {
                    columnStatsMapBuilder.put((Object)columnStatistics.getColumnName(), (Object)GlueStatConverter.fromGlueColumnStatistics(columnStatistics.getStatisticsData(), tableStatistics.getRowCount()));
                }
            }
            return columnStatsMapBuilder.build();
        }
        catch (EntityNotFoundException ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_NOT_FOUND, (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)ex);
        }
    }

    private boolean isGlueWritable(ColumnStatistics stats) {
        ColumnStatisticsData statisticsData = stats.getStatisticsData();
        String columnType = stats.getStatisticsData().getType();
        if (columnType.equals(ColumnStatisticsType.DATE.toString())) {
            DateColumnStatisticsData data = statisticsData.getDateColumnStatisticsData();
            return data.getMaximumValue() != null && data.getMinimumValue() != null;
        }
        if (columnType.equals(ColumnStatisticsType.DECIMAL.toString())) {
            DecimalColumnStatisticsData data = statisticsData.getDecimalColumnStatisticsData();
            return data.getMaximumValue() != null && data.getMinimumValue() != null;
        }
        if (columnType.equals(ColumnStatisticsType.DOUBLE.toString())) {
            DoubleColumnStatisticsData data = statisticsData.getDoubleColumnStatisticsData();
            return data.getMaximumValue() != null && data.getMinimumValue() != null;
        }
        if (columnType.equals(ColumnStatisticsType.LONG.toString())) {
            LongColumnStatisticsData data = statisticsData.getLongColumnStatisticsData();
            return data.getMaximumValue() != null && data.getMinimumValue() != null;
        }
        return true;
    }

    @Override
    public void updateTableColumnStatistics(Table table, Map<String, HiveColumnStatistics> updatedTableColumnStatistics) {
        try {
            HiveBasicStatistics tableStats = ThriftMetastoreUtil.getHiveBasicStatistics(table.getParameters());
            List columnStats = GlueStatConverter.toGlueColumnStatistics(table, updatedTableColumnStatistics, tableStats.getRowCount()).stream().filter(this::isGlueWritable).collect(Collectors.toUnmodifiableList());
            List columnChunks = Lists.partition(columnStats, (int)25);
            List updateFutures = columnChunks.stream().map(columnChunk -> CompletableFuture.runAsync(() -> this.glueClient.updateColumnStatisticsForTable(new UpdateColumnStatisticsForTableRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withColumnStatisticsList((Collection)columnChunk)), this.writeExecutor)).collect(Collectors.toUnmodifiableList());
            Map<String, HiveColumnStatistics> currentTableColumnStatistics = this.getTableColumnStatistics(table);
            Sets.SetView removedStatistics = Sets.difference(currentTableColumnStatistics.keySet(), updatedTableColumnStatistics.keySet());
            List deleteFutures = removedStatistics.stream().map(column -> CompletableFuture.runAsync(() -> this.glueClient.deleteColumnStatisticsForTable(new DeleteColumnStatisticsForTableRequest().withCatalogId(this.catalogId).withDatabaseName(table.getDatabaseName()).withTableName(table.getTableName()).withColumnName(column)), this.writeExecutor)).collect(Collectors.toUnmodifiableList());
            ImmutableList updateOperationsFutures = ImmutableList.builder().addAll(updateFutures).addAll(deleteFutures).build();
            MoreFutures.getFutureValue(CompletableFuture.allOf((CompletableFuture[])updateOperationsFutures.toArray(CompletableFuture[]::new)));
        }
        catch (RuntimeException ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)ex);
        }
    }

    @Override
    public void updatePartitionStatistics(Partition partition, Map<String, HiveColumnStatistics> updatedColumnStatistics) {
        try {
            HiveBasicStatistics partitionStats = ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters());
            List columnStats = GlueStatConverter.toGlueColumnStatistics(partition, updatedColumnStatistics, partitionStats.getRowCount()).stream().filter(this::isGlueWritable).collect(Collectors.toUnmodifiableList());
            List columnChunks = Lists.partition(columnStats, (int)25);
            List writePartitionStatsFutures = columnChunks.stream().map(columnChunk -> CompletableFuture.runAsync(() -> this.glueClient.updateColumnStatisticsForPartition(new UpdateColumnStatisticsForPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(partition.getDatabaseName()).withTableName(partition.getTableName()).withPartitionValues(partition.getValues()).withColumnStatisticsList((Collection)columnChunk)), this.writeExecutor)).collect(Collectors.toUnmodifiableList());
            Map<String, HiveColumnStatistics> currentColumnStatistics = this.getPartitionColumnStatisticsIfPresent(partition).orElse((Map<String, HiveColumnStatistics>)ImmutableMap.of());
            Sets.SetView removedStatistics = Sets.difference(currentColumnStatistics.keySet(), updatedColumnStatistics.keySet());
            List deleteStatsFutures = removedStatistics.stream().map(column -> CompletableFuture.runAsync(() -> this.glueClient.deleteColumnStatisticsForPartition(new DeleteColumnStatisticsForPartitionRequest().withCatalogId(this.catalogId).withDatabaseName(partition.getDatabaseName()).withTableName(partition.getTableName()).withPartitionValues(partition.getValues()).withColumnName(column)), this.writeExecutor)).collect(Collectors.toUnmodifiableList());
            ImmutableList updateOperationsFutures = ImmutableList.builder().addAll(writePartitionStatsFutures).addAll(deleteStatsFutures).build();
            MoreFutures.getFutureValue(CompletableFuture.allOf((CompletableFuture[])updateOperationsFutures.toArray(CompletableFuture[]::new)));
        }
        catch (RuntimeException ex) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)ex);
        }
    }

    private List<String> getAllColumns(Table table) {
        ImmutableList.Builder allColumns = ImmutableList.builderWithExpectedSize((int)(table.getDataColumns().size() + table.getPartitionColumns().size()));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)allColumns).add(arg_0));
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)allColumns).add(arg_0));
        return allColumns.build();
    }
}

