/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.amazonaws.services.glue.AWSGlueAsync;
import io.trino.plugin.hive.metastore.glue.DefaultGlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.ForGlueColumnStatisticsRead;
import io.trino.plugin.hive.metastore.glue.ForGlueColumnStatisticsWrite;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.GlueColumnStatisticsProviderFactory;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class DefaultGlueColumnStatisticsProviderFactory
implements GlueColumnStatisticsProviderFactory {
    @Nullable
    private final String catalogId;
    private final Executor statisticsReadExecutor;
    private final Executor statisticsWriteExecutor;

    @Inject
    public DefaultGlueColumnStatisticsProviderFactory(GlueHiveMetastoreConfig glueConfig, @ForGlueColumnStatisticsRead Executor statisticsReadExecutor, @ForGlueColumnStatisticsWrite Executor statisticsWriteExecutor) {
        this.catalogId = Objects.requireNonNull(glueConfig, "glueConfig is null").getCatalogId().orElse(null);
        this.statisticsReadExecutor = Objects.requireNonNull(statisticsReadExecutor, "statisticsReadExecutor is null");
        this.statisticsWriteExecutor = Objects.requireNonNull(statisticsWriteExecutor, "statisticsWriteExecutor is null");
    }

    @Override
    public GlueColumnStatisticsProvider createGlueColumnStatisticsProvider(AWSGlueAsync glueClient) {
        return new DefaultGlueColumnStatisticsProvider(glueClient, this.catalogId, this.statisticsReadExecutor, this.statisticsWriteExecutor);
    }
}

