/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.Field;
import io.trino.parquet.GroupField;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOUtil;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.Type;

public final class ParquetColumnIOConverter {
    private ParquetColumnIOConverter() {
    }

    public static Optional<Field> constructField(Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = ColumnIOUtil.columnRepetitionLevel((ColumnIO)columnIO);
        int definitionLevel = ColumnIOUtil.columnDefinitionLevel((ColumnIO)columnIO);
        if (type instanceof RowType) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List parameters = type.getTypeParameters();
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = type.getTypeSignature().getParameters();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                NamedTypeSignature namedTypeSignature = ((TypeSignatureParameter)fields.get(i)).getNamedTypeSignature();
                String name = ((String)namedTypeSignature.getName().get()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = ParquetColumnIOConverter.constructField((Type)parameters.get(i), ParquetTypeUtils.lookupColumnByName((GroupColumnIO)groupColumnIO, (String)name));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if (type instanceof MapType) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            MapType mapType = (MapType)type;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn((GroupColumnIO)groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = ParquetColumnIOConverter.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = ParquetColumnIOConverter.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)ImmutableList.of(keyField, valueField)));
        }
        if (type instanceof ArrayType) {
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            List types = type.getTypeParameters();
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = ParquetColumnIOConverter.constructField((Type)types.get(0), ParquetTypeUtils.getArrayElementColumn((ColumnIO)groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, (List)ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        RichColumnDescriptor column = new RichColumnDescriptor(primitiveColumnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
        return Optional.of(new PrimitiveField(type, repetitionLevel, definitionLevel, required, column, primitiveColumnIO.getId()));
    }
}

