/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.trino.parquet.ParquetReaderOptions;
import javax.validation.constraints.NotNull;

public class ParquetReaderConfig {
    private ParquetReaderOptions options = new ParquetReaderOptions();

    @Deprecated
    public boolean isIgnoreStatistics() {
        return this.options.isIgnoreStatistics();
    }

    @Deprecated
    @Config(value="parquet.ignore-statistics")
    @ConfigDescription(value="Ignore statistics from Parquet to allow querying files with corrupted or incorrect statistics")
    public ParquetReaderConfig setIgnoreStatistics(boolean ignoreStatistics) {
        this.options = this.options.withIgnoreStatistics(ignoreStatistics);
        return this;
    }

    @Deprecated
    @LegacyConfig(value={"hive.parquet.fail-on-corrupted-statistics", "parquet.fail-on-corrupted-statistics"}, replacedBy="parquet.ignore-statistics")
    public ParquetReaderConfig setFailOnCorruptedStatistics(boolean failOnCorruptedStatistics) {
        return this.setIgnoreStatistics(!failOnCorruptedStatistics);
    }

    @NotNull
    public DataSize getMaxReadBlockSize() {
        return this.options.getMaxReadBlockSize();
    }

    @Config(value="parquet.max-read-block-size")
    @LegacyConfig(value={"hive.parquet.max-read-block-size"})
    public ParquetReaderConfig setMaxReadBlockSize(DataSize maxReadBlockSize) {
        this.options = this.options.withMaxReadBlockSize(maxReadBlockSize);
        return this;
    }

    @NotNull
    public DataSize getMaxMergeDistance() {
        return this.options.getMaxMergeDistance();
    }

    @Config(value="parquet.max-merge-distance")
    public ParquetReaderConfig setMaxMergeDistance(DataSize distance) {
        this.options = this.options.withMaxMergeDistance(distance);
        return this;
    }

    @NotNull
    public DataSize getMaxBufferSize() {
        return this.options.getMaxBufferSize();
    }

    @Config(value="parquet.max-buffer-size")
    public ParquetReaderConfig setMaxBufferSize(DataSize size) {
        this.options = this.options.withMaxBufferSize(size);
        return this;
    }

    public ParquetReaderOptions toParquetReaderOptions() {
        return this.options;
    }
}

