/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveInsertTableHandle;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.hive.common.FileUtils;

public class CreateEmptyPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle CREATE_EMPTY_PARTITION = MethodHandleUtil.methodHandle(CreateEmptyPartitionProcedure.class, (String)"createEmptyPartition", (Class[])new Class[]{ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, List.class, List.class});
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final HiveMetastoreClosure metastore;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateJsonCodec;

    @Inject
    public CreateEmptyPartitionProcedure(TransactionalMetadataFactory hiveMetadataFactory, HiveMetastore metastore, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.metastore = new HiveMetastoreClosure(Objects.requireNonNull(metastore, "metastore is null"));
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateJsonCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
    }

    public Procedure get() {
        return new Procedure("system", "create_empty_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("table_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("partition_columns", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("partition_values", (Type)new ArrayType((Type)VarcharType.VARCHAR))), CREATE_EMPTY_PARTITION.bindTo(this));
    }

    public void createEmptyPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table, List<String> partitionColumnNames, List<String> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doCreateEmptyPartition(session, accessControl, schema, table, partitionColumnNames, partitionValues);
        }
    }

    private void doCreateEmptyPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumnNames, List<String> partitionValues) {
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.create();
        HiveTableHandle tableHandle = (HiveTableHandle)hiveMetadata.getTableHandle(session, new SchemaTableName(schemaName, tableName));
        if (tableHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("Table '%s' does not exist", new SchemaTableName(schemaName, tableName)));
        }
        accessControl.checkCanInsertIntoTable(null, new SchemaTableName(schemaName, tableName));
        List actualPartitionColumnNames = (List)tableHandle.getPartitionColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!Objects.equals(partitionColumnNames, actualPartitionColumnNames)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Provided partition column names do not match actual partition column names: " + actualPartitionColumnNames);
        }
        if (this.metastore.getPartition(new HiveIdentity(session), schemaName, tableName, partitionValues).isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Partition already exists");
        }
        HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)hiveMetadata.beginInsert(session, tableHandle);
        String partitionName = FileUtils.makePartName((List)actualPartitionColumnNames, partitionValues);
        LocationService.WriteInfo writeInfo = this.locationService.getPartitionWriteInfo(hiveInsertTableHandle.getLocationHandle(), Optional.empty(), partitionName);
        Slice serializedPartitionUpdate = Slices.wrappedBuffer((byte[])this.partitionUpdateJsonCodec.toJsonBytes((Object)new PartitionUpdate(partitionName, PartitionUpdate.UpdateMode.NEW, writeInfo.getWritePath(), writeInfo.getTargetPath(), (List<String>)ImmutableList.of(), 0L, 0L, 0L)));
        hiveMetadata.finishInsert(session, hiveInsertTableHandle, (Collection)ImmutableList.of((Object)serializedPartitionUpdate), (Collection)ImmutableList.of());
        hiveMetadata.commit();
    }
}

