/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.security.LegacyAccessControlMetastore;
import io.trino.spi.connector.ConnectorSecurityContext;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;

public class SemiTransactionalLegacyAccessControlMetastore
implements LegacyAccessControlMetastore {
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;

    @Inject
    public SemiTransactionalLegacyAccessControlMetastore(Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider) {
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
    }

    @Override
    public Optional<Table> getTable(ConnectorSecurityContext context, HiveIdentity identity, String databaseName, String tableName) {
        return this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle()).getTable(new HiveIdentity(context.getIdentity()), databaseName, tableName);
    }
}

