/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetastore;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.security.RoleGrant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

public class SemiTransactionalSqlStandardAccessControlMetastore
implements SqlStandardAccessControlMetastore {
    private final Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider;

    @Inject
    public SemiTransactionalSqlStandardAccessControlMetastore(Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> metastoreProvider) {
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
    }

    @Override
    public Set<RoleGrant> listRoleGrants(ConnectorSecurityContext context, HivePrincipal principal) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        return metastore.listRoleGrants(principal);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(ConnectorSecurityContext context, HiveIdentity identity, String databaseName, String tableName, Optional<HivePrincipal> principal) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        return metastore.listTablePrivileges(identity, databaseName, tableName, principal);
    }

    @Override
    public Optional<Database> getDatabase(ConnectorSecurityContext context, String databaseName) {
        SemiTransactionalHiveMetastore metastore = this.metastoreProvider.apply((HiveTransactionHandle)context.getTransactionHandle());
        return metastore.getDatabase(databaseName);
    }
}

