/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"dfs.domain-socket-path", "hive.file-system-cache-ttl", "hive.max-global-split-iterator-threads", "hive.max-sort-files-per-bucket", "hive.bucket-writing", "hive.optimized-reader.enabled", "hive.rcfile-optimized-writer.enabled", "hive.time-zone", "hive.assume-canonical-partition-keys", "hive.partition-use-column-names", "hive.allow-corrupt-writes-for-testing"})
public class HiveConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private DataSize maxSplitSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int maxPartitionsPerScan = 100000;
    private int maxOutstandingSplits = 1000;
    private DataSize maxOutstandingSplitsSize = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int maxSplitIteratorThreads = 1000;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private int maxInitialSplits = 200;
    private int splitLoaderConcurrency = 64;
    private Integer maxSplitsPerSecond;
    private DataSize maxInitialSplitSize;
    private int domainCompactionThreshold = 100;
    private DataSize writerSortBufferSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean forceLocalScheduling;
    private boolean recursiveDirWalkerEnabled;
    private boolean ignoreAbsentPartitions;
    private int maxConcurrentFileRenames = 20;
    private int maxConcurrentMetastoreDrops = 20;
    private int maxConcurrentMetastoreUpdates = 20;
    private long perTransactionMetastoreCacheMaximumSize = 1000L;
    private HiveStorageFormat hiveStorageFormat = HiveStorageFormat.ORC;
    private HiveCompressionCodec hiveCompressionCodec = HiveCompressionCodec.GZIP;
    private boolean respectTableFormat = true;
    private boolean immutablePartitions;
    private Optional<HiveSessionProperties.InsertExistingPartitionsBehavior> insertExistingPartitionsBehavior = Optional.empty();
    private boolean createEmptyBucketFiles;
    private boolean deleteSchemaLocationsFallback;
    private int maxPartitionsPerWriter = 100;
    private int maxOpenSortFiles = 50;
    private int writeValidationThreads = 16;
    private boolean validateBucketing = true;
    private boolean parallelPartitionedBucketedWrites = true;
    private DataSize textMaxLineLength = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private String orcLegacyTimeZone = TimeZone.getDefault().getID();
    private String parquetTimeZone = TimeZone.getDefault().getID();
    private boolean useParquetColumnNames = true;
    private String rcfileTimeZone = TimeZone.getDefault().getID();
    private boolean rcfileWriterValidate;
    private boolean skipDeletionForAlter;
    private boolean skipTargetCleanupOnRollback;
    private boolean bucketExecutionEnabled = true;
    private boolean sortedWritingEnabled = true;
    private boolean propagateTableScanSortingProperties;
    private boolean optimizeMismatchedBucketCount;
    private boolean writesToNonManagedTablesEnabled;
    private boolean createsOfNonManagedTablesEnabled = true;
    private boolean tableStatisticsEnabled = true;
    private int partitionStatisticsSampleSize = 100;
    private boolean ignoreCorruptedStatistics;
    private boolean collectColumnStatisticsOnWrite = true;
    private boolean s3SelectPushdownEnabled;
    private int s3SelectPushdownMaxConnections = 500;
    private boolean isTemporaryStagingDirectoryEnabled = true;
    private String temporaryStagingDirectoryPath = "/tmp/presto-${USER}";
    private boolean delegateTransactionalManagedTableLocationToMetastore;
    private Duration fileStatusCacheExpireAfterWrite = new Duration(1.0, TimeUnit.MINUTES);
    private long fileStatusCacheMaxSize = 1000000L;
    private List<String> fileStatusCacheTables = ImmutableList.of();
    private boolean translateHiveViews;
    private Optional<Duration> hiveTransactionHeartbeatInterval = Optional.empty();
    private int hiveTransactionHeartbeatThreads = 5;
    private boolean allowRegisterPartition;
    private boolean queryPartitionFilterRequired;
    private Set<String> queryPartitionFilterRequiredSchemas = ImmutableSet.of();
    private boolean projectionPushdownEnabled = true;
    private Duration dynamicFilteringWaitTimeout = new Duration(0.0, TimeUnit.MINUTES);
    private HiveTimestampPrecision timestampPrecision = HiveTimestampPrecision.DEFAULT_PRECISION;
    private boolean optimizeSymlinkListing = true;
    private boolean legacyHiveViewTranslation;
    private Optional<String> icebergCatalogName = Optional.empty();
    private DataSize targetMaxFileSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private boolean sizeBasedSplitWeightsEnabled = true;
    private double minimumAssignedSplitWeight = 0.05;

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="hive.max-initial-splits")
    public HiveConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return DataSize.ofBytes((long)(this.maxSplitSize.toBytes() / 2L)).to(this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="hive.max-initial-split-size")
    public HiveConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitLoaderConcurrency() {
        return this.splitLoaderConcurrency;
    }

    @Config(value="hive.split-loader-concurrency")
    public HiveConfig setSplitLoaderConcurrency(int splitLoaderConcurrency) {
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        return this;
    }

    @Min(value=1L)
    @Nullable
    public @Min(value=1L) Integer getMaxSplitsPerSecond() {
        return this.maxSplitsPerSecond;
    }

    @Config(value="hive.max-splits-per-second")
    @ConfigDescription(value="Throttles the maximum number of splits that can be assigned to tasks per second")
    public HiveConfig setMaxSplitsPerSecond(Integer maxSplitsPerSecond) {
        this.maxSplitsPerSecond = maxSplitsPerSecond;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="hive.domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public HiveConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    public DataSize getTargetMaxFileSize() {
        return this.targetMaxFileSize;
    }

    @Config(value="hive.target-max-file-size")
    @ConfigDescription(value="Target maximum size of written files; the actual size may be larger")
    public HiveConfig setTargetMaxFileSize(DataSize targetMaxFileSize) {
        this.targetMaxFileSize = targetMaxFileSize;
        return this;
    }

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public @MinDataSize(value="1MB") @MaxDataSize(value="1GB") DataSize getWriterSortBufferSize() {
        return this.writerSortBufferSize;
    }

    @Config(value="hive.writer-sort-buffer-size")
    public HiveConfig setWriterSortBufferSize(DataSize writerSortBufferSize) {
        this.writerSortBufferSize = writerSortBufferSize;
        return this;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @Config(value="hive.force-local-scheduling")
    public HiveConfig setForceLocalScheduling(boolean forceLocalScheduling) {
        this.forceLocalScheduling = forceLocalScheduling;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentFileRenames() {
        return this.maxConcurrentFileRenames;
    }

    @Config(value="hive.max-concurrent-file-renames")
    public HiveConfig setMaxConcurrentFileRenames(int maxConcurrentFileRenames) {
        this.maxConcurrentFileRenames = maxConcurrentFileRenames;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentMetastoreDrops() {
        return this.maxConcurrentMetastoreDrops;
    }

    @Config(value="hive.max-concurrent-metastore-drops")
    public HiveConfig setMaxConcurrentMetastoreDrops(int maxConcurrentMetastoreDeletes) {
        this.maxConcurrentMetastoreDrops = maxConcurrentMetastoreDeletes;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentMetastoreUpdates() {
        return this.maxConcurrentMetastoreUpdates;
    }

    @Config(value="hive.max-concurrent-metastore-updates")
    public HiveConfig setMaxConcurrentMetastoreUpdates(int maxConcurrentMetastoreUpdates) {
        this.maxConcurrentMetastoreUpdates = maxConcurrentMetastoreUpdates;
        return this;
    }

    @Config(value="hive.recursive-directories")
    public HiveConfig setRecursiveDirWalkerEnabled(boolean recursiveDirWalkerEnabled) {
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        return this;
    }

    public boolean getRecursiveDirWalkerEnabled() {
        return this.recursiveDirWalkerEnabled;
    }

    public boolean isIgnoreAbsentPartitions() {
        return this.ignoreAbsentPartitions;
    }

    @Config(value="hive.ignore-absent-partitions")
    public HiveConfig setIgnoreAbsentPartitions(boolean ignoreAbsentPartitions) {
        this.ignoreAbsentPartitions = ignoreAbsentPartitions;
        return this;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerScan() {
        return this.maxPartitionsPerScan;
    }

    @Config(value="hive.max-partitions-per-scan")
    @ConfigDescription(value="Maximum allowed partitions for a single table scan")
    public HiveConfig setMaxPartitionsPerScan(int maxPartitionsPerScan) {
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    @ConfigDescription(value="Target number of buffered splits for each table scan in a query, before the scheduler tries to pause itself")
    public HiveConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @MinDataSize(value="1MB")
    public @MinDataSize(value="1MB") DataSize getMaxOutstandingSplitsSize() {
        return this.maxOutstandingSplitsSize;
    }

    @Config(value="hive.max-outstanding-splits-size")
    @ConfigDescription(value="Maximum amount of memory allowed for split buffering for each table scan in a query, before the query is failed")
    public HiveConfig setMaxOutstandingSplitsSize(DataSize maxOutstandingSplits) {
        this.maxOutstandingSplitsSize = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getPerTransactionMetastoreCacheMaximumSize() {
        return this.perTransactionMetastoreCacheMaximumSize;
    }

    @Config(value="hive.per-transaction-metastore-cache-maximum-size")
    public HiveConfig setPerTransactionMetastoreCacheMaximumSize(long perTransactionMetastoreCacheMaximumSize) {
        this.perTransactionMetastoreCacheMaximumSize = perTransactionMetastoreCacheMaximumSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    @Config(value="hive.storage-format")
    public HiveConfig setHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        this.hiveStorageFormat = hiveStorageFormat;
        return this;
    }

    public HiveCompressionCodec getHiveCompressionCodec() {
        return this.hiveCompressionCodec;
    }

    @Config(value="hive.compression-codec")
    public HiveConfig setHiveCompressionCodec(HiveCompressionCodec hiveCompressionCodec) {
        this.hiveCompressionCodec = hiveCompressionCodec;
        return this;
    }

    public boolean isRespectTableFormat() {
        return this.respectTableFormat;
    }

    @Config(value="hive.respect-table-format")
    @ConfigDescription(value="Should new partitions be written using the existing table format or the default Trino format")
    public HiveConfig setRespectTableFormat(boolean respectTableFormat) {
        this.respectTableFormat = respectTableFormat;
        return this;
    }

    public boolean isImmutablePartitions() {
        return this.immutablePartitions;
    }

    @Config(value="hive.immutable-partitions")
    @ConfigDescription(value="Can new data be inserted into existing partitions or existing unpartitioned tables")
    public HiveConfig setImmutablePartitions(boolean immutablePartitions) {
        this.immutablePartitions = immutablePartitions;
        return this;
    }

    public HiveSessionProperties.InsertExistingPartitionsBehavior getInsertExistingPartitionsBehavior() {
        return this.insertExistingPartitionsBehavior.orElse(this.immutablePartitions ? HiveSessionProperties.InsertExistingPartitionsBehavior.ERROR : HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND);
    }

    @Config(value="hive.insert-existing-partitions-behavior")
    @ConfigDescription(value="Default value for insert existing partitions behavior")
    public HiveConfig setInsertExistingPartitionsBehavior(HiveSessionProperties.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior) {
        this.insertExistingPartitionsBehavior = Optional.ofNullable(insertExistingPartitionsBehavior);
        return this;
    }

    @AssertTrue(message="insert-existing-partitions-behavior cannot be APPEND when immutable-partitions is true")
    public @AssertTrue(message="insert-existing-partitions-behavior cannot be APPEND when immutable-partitions is true") boolean isInsertExistingPartitionsBehaviorValid() {
        return this.insertExistingPartitionsBehavior.map(v -> HiveSessionProperties.InsertExistingPartitionsBehavior.isValid(v, this.immutablePartitions)).orElse(true);
    }

    public boolean isCreateEmptyBucketFiles() {
        return this.createEmptyBucketFiles;
    }

    @Config(value="hive.create-empty-bucket-files")
    @ConfigDescription(value="Create empty files for buckets that have no data")
    public HiveConfig setCreateEmptyBucketFiles(boolean createEmptyBucketFiles) {
        this.createEmptyBucketFiles = createEmptyBucketFiles;
        return this;
    }

    public boolean isDeleteSchemaLocationsFallback() {
        return this.deleteSchemaLocationsFallback;
    }

    @Config(value="hive.delete-schema-locations-fallback")
    @ConfigDescription(value="Whether schema locations should be deleted when Trino can't determine whether they contain external files.")
    public HiveConfig setDeleteSchemaLocationsFallback(boolean deleteSchemaLocationsFallback) {
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="hive.max-partitions-per-writers")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public HiveConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    @Min(value=2L)
    @Max(value=1000L)
    public @Min(value=2L) @Max(value=1000L) int getMaxOpenSortFiles() {
        return this.maxOpenSortFiles;
    }

    @Config(value="hive.max-open-sort-files")
    @ConfigDescription(value="Maximum number of writer temporary files to read in one pass")
    public HiveConfig setMaxOpenSortFiles(int maxOpenSortFiles) {
        this.maxOpenSortFiles = maxOpenSortFiles;
        return this;
    }

    public int getWriteValidationThreads() {
        return this.writeValidationThreads;
    }

    @Config(value="hive.write-validation-threads")
    @ConfigDescription(value="Number of threads used for verifying data after a write")
    public HiveConfig setWriteValidationThreads(int writeValidationThreads) {
        this.writeValidationThreads = writeValidationThreads;
        return this;
    }

    public boolean isValidateBucketing() {
        return this.validateBucketing;
    }

    @Config(value="hive.validate-bucketing")
    @ConfigDescription(value="Verify that data is bucketed correctly when reading")
    public HiveConfig setValidateBucketing(boolean validateBucketing) {
        this.validateBucketing = validateBucketing;
        return this;
    }

    public boolean isParallelPartitionedBucketedWrites() {
        return this.parallelPartitionedBucketedWrites;
    }

    @Config(value="hive.parallel-partitioned-bucketed-writes")
    @LegacyConfig(value={"hive.parallel-partitioned-bucketed-inserts"})
    @ConfigDescription(value="Improve parallelism of partitioned and bucketed table writes")
    public HiveConfig setParallelPartitionedBucketedWrites(boolean parallelPartitionedBucketedWrites) {
        this.parallelPartitionedBucketedWrites = parallelPartitionedBucketedWrites;
        return this;
    }

    public DateTimeZone getRcfileDateTimeZone() {
        return DateTimeZone.forID((String)this.rcfileTimeZone);
    }

    @NotNull
    public String getRcfileTimeZone() {
        return this.rcfileTimeZone;
    }

    @Config(value="hive.rcfile.time-zone")
    @ConfigDescription(value="Time zone for RCFile binary read and write")
    public HiveConfig setRcfileTimeZone(String rcfileTimeZone) {
        this.rcfileTimeZone = rcfileTimeZone;
        return this;
    }

    public boolean isRcfileWriterValidate() {
        return this.rcfileWriterValidate;
    }

    @Config(value="hive.rcfile.writer.validate")
    @ConfigDescription(value="Validate RCFile after write by re-reading the whole file")
    public HiveConfig setRcfileWriterValidate(boolean rcfileWriterValidate) {
        this.rcfileWriterValidate = rcfileWriterValidate;
        return this;
    }

    @MinDataSize(value="1B")
    @MaxDataSize(value="1GB")
    @NotNull
    public @MinDataSize(value="1B") @MaxDataSize(value="1GB") @NotNull DataSize getTextMaxLineLength() {
        return this.textMaxLineLength;
    }

    @Config(value="hive.text.max-line-length")
    @ConfigDescription(value="Maximum line length for text files")
    public HiveConfig setTextMaxLineLength(DataSize textMaxLineLength) {
        this.textMaxLineLength = textMaxLineLength;
        return this;
    }

    public DateTimeZone getOrcLegacyDateTimeZone() {
        return DateTimeZone.forID((String)this.orcLegacyTimeZone);
    }

    @NotNull
    public String getOrcLegacyTimeZone() {
        return this.orcLegacyTimeZone;
    }

    @Config(value="hive.orc.time-zone")
    @ConfigDescription(value="Time zone for legacy ORC files that do not contain a time zone")
    public HiveConfig setOrcLegacyTimeZone(String orcLegacyTimeZone) {
        this.orcLegacyTimeZone = orcLegacyTimeZone;
        return this;
    }

    public DateTimeZone getParquetDateTimeZone() {
        return DateTimeZone.forID((String)this.parquetTimeZone);
    }

    @NotNull
    public String getParquetTimeZone() {
        return this.parquetTimeZone;
    }

    @Config(value="hive.parquet.time-zone")
    @ConfigDescription(value="Time zone for Parquet read and write")
    public HiveConfig setParquetTimeZone(String parquetTimeZone) {
        this.parquetTimeZone = parquetTimeZone;
        return this;
    }

    public boolean isUseParquetColumnNames() {
        return this.useParquetColumnNames;
    }

    @Config(value="hive.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file")
    public HiveConfig setUseParquetColumnNames(boolean useParquetColumnNames) {
        this.useParquetColumnNames = useParquetColumnNames;
        return this;
    }

    public boolean isOptimizeMismatchedBucketCount() {
        return this.optimizeMismatchedBucketCount;
    }

    @Config(value="hive.optimize-mismatched-bucket-count")
    public HiveConfig setOptimizeMismatchedBucketCount(boolean optimizeMismatchedBucketCount) {
        this.optimizeMismatchedBucketCount = optimizeMismatchedBucketCount;
        return this;
    }

    public List<String> getFileStatusCacheTables() {
        return this.fileStatusCacheTables;
    }

    @Config(value="hive.file-status-cache-tables")
    public HiveConfig setFileStatusCacheTables(String fileStatusCacheTables) {
        this.fileStatusCacheTables = SPLITTER.splitToList((CharSequence)fileStatusCacheTables);
        return this;
    }

    public boolean isTranslateHiveViews() {
        return this.translateHiveViews;
    }

    @LegacyConfig(value={"hive.views-execution.enabled"})
    @Config(value="hive.translate-hive-views")
    @ConfigDescription(value="Experimental: Allow translation of Hive views into Trino views")
    public HiveConfig setTranslateHiveViews(boolean translateHiveViews) {
        this.translateHiveViews = translateHiveViews;
        return this;
    }

    public long getFileStatusCacheMaxSize() {
        return this.fileStatusCacheMaxSize;
    }

    @Config(value="hive.file-status-cache-size")
    public HiveConfig setFileStatusCacheMaxSize(long fileStatusCacheMaxSize) {
        this.fileStatusCacheMaxSize = fileStatusCacheMaxSize;
        return this;
    }

    public Duration getFileStatusCacheExpireAfterWrite() {
        return this.fileStatusCacheExpireAfterWrite;
    }

    @Config(value="hive.file-status-cache-expire-time")
    public HiveConfig setFileStatusCacheExpireAfterWrite(Duration fileStatusCacheExpireAfterWrite) {
        this.fileStatusCacheExpireAfterWrite = fileStatusCacheExpireAfterWrite;
        return this;
    }

    public boolean isSkipDeletionForAlter() {
        return this.skipDeletionForAlter;
    }

    @Config(value="hive.skip-deletion-for-alter")
    @ConfigDescription(value="Skip deletion of old partition data when a partition is deleted and then inserted in the same transaction")
    public HiveConfig setSkipDeletionForAlter(boolean skipDeletionForAlter) {
        this.skipDeletionForAlter = skipDeletionForAlter;
        return this;
    }

    public boolean isSkipTargetCleanupOnRollback() {
        return this.skipTargetCleanupOnRollback;
    }

    @Config(value="hive.skip-target-cleanup-on-rollback")
    @ConfigDescription(value="Skip deletion of target directories when a metastore operation fails")
    public HiveConfig setSkipTargetCleanupOnRollback(boolean skipTargetCleanupOnRollback) {
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        return this;
    }

    public boolean isBucketExecutionEnabled() {
        return this.bucketExecutionEnabled;
    }

    @Config(value="hive.bucket-execution")
    @ConfigDescription(value="Enable bucket-aware execution: only use a single worker per bucket")
    public HiveConfig setBucketExecutionEnabled(boolean bucketExecutionEnabled) {
        this.bucketExecutionEnabled = bucketExecutionEnabled;
        return this;
    }

    public boolean isSortedWritingEnabled() {
        return this.sortedWritingEnabled;
    }

    @Config(value="hive.sorted-writing")
    @ConfigDescription(value="Enable writing to bucketed sorted tables")
    public HiveConfig setSortedWritingEnabled(boolean sortedWritingEnabled) {
        this.sortedWritingEnabled = sortedWritingEnabled;
        return this;
    }

    public boolean isPropagateTableScanSortingProperties() {
        return this.propagateTableScanSortingProperties;
    }

    @Config(value="hive.propagate-table-scan-sorting-properties")
    @ConfigDescription(value="Use sorted table layout to generate more efficient execution plans. May lead to incorrect results if files are not sorted as per table definition.")
    public HiveConfig setPropagateTableScanSortingProperties(boolean propagateTableScanSortingProperties) {
        this.propagateTableScanSortingProperties = propagateTableScanSortingProperties;
        return this;
    }

    @Config(value="hive.non-managed-table-writes-enabled")
    @ConfigDescription(value="Enable writes to non-managed (external) tables")
    public HiveConfig setWritesToNonManagedTablesEnabled(boolean writesToNonManagedTablesEnabled) {
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        return this;
    }

    public boolean getWritesToNonManagedTablesEnabled() {
        return this.writesToNonManagedTablesEnabled;
    }

    @Config(value="hive.non-managed-table-creates-enabled")
    @ConfigDescription(value="Enable non-managed (external) table creates")
    public HiveConfig setCreatesOfNonManagedTablesEnabled(boolean createsOfNonManagedTablesEnabled) {
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        return this;
    }

    public boolean getCreatesOfNonManagedTablesEnabled() {
        return this.createsOfNonManagedTablesEnabled;
    }

    @Config(value="hive.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public HiveConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPartitionStatisticsSampleSize() {
        return this.partitionStatisticsSampleSize;
    }

    @Config(value="hive.partition-statistics-sample-size")
    @ConfigDescription(value="Maximum sample size of the partitions column statistics")
    public HiveConfig setPartitionStatisticsSampleSize(int partitionStatisticsSampleSize) {
        this.partitionStatisticsSampleSize = partitionStatisticsSampleSize;
        return this;
    }

    public boolean isIgnoreCorruptedStatistics() {
        return this.ignoreCorruptedStatistics;
    }

    @Config(value="hive.ignore-corrupted-statistics")
    @ConfigDescription(value="Ignore corrupted statistics rather than failing")
    public HiveConfig setIgnoreCorruptedStatistics(boolean ignoreCorruptedStatistics) {
        this.ignoreCorruptedStatistics = ignoreCorruptedStatistics;
        return this;
    }

    public boolean isCollectColumnStatisticsOnWrite() {
        return this.collectColumnStatisticsOnWrite;
    }

    @Config(value="hive.collect-column-statistics-on-write")
    @ConfigDescription(value="Enables automatic column level statistics collection on write")
    public HiveConfig setCollectColumnStatisticsOnWrite(boolean collectColumnStatisticsOnWrite) {
        this.collectColumnStatisticsOnWrite = collectColumnStatisticsOnWrite;
        return this;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @Config(value="hive.s3select-pushdown.enabled")
    @ConfigDescription(value="Enable query pushdown to AWS S3 Select service")
    public HiveConfig setS3SelectPushdownEnabled(boolean s3SelectPushdownEnabled) {
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getS3SelectPushdownMaxConnections() {
        return this.s3SelectPushdownMaxConnections;
    }

    @Config(value="hive.s3select-pushdown.max-connections")
    public HiveConfig setS3SelectPushdownMaxConnections(int s3SelectPushdownMaxConnections) {
        this.s3SelectPushdownMaxConnections = s3SelectPushdownMaxConnections;
        return this;
    }

    @Config(value="hive.temporary-staging-directory-enabled")
    @ConfigDescription(value="Should use (if possible) temporary staging directory for write operations")
    public HiveConfig setTemporaryStagingDirectoryEnabled(boolean temporaryStagingDirectoryEnabled) {
        this.isTemporaryStagingDirectoryEnabled = temporaryStagingDirectoryEnabled;
        return this;
    }

    public boolean isTemporaryStagingDirectoryEnabled() {
        return this.isTemporaryStagingDirectoryEnabled;
    }

    @Config(value="hive.temporary-staging-directory-path")
    @ConfigDescription(value="Location of temporary staging directory for write operations. Use ${USER} placeholder to use different location for each user.")
    public HiveConfig setTemporaryStagingDirectoryPath(String temporaryStagingDirectoryPath) {
        this.temporaryStagingDirectoryPath = temporaryStagingDirectoryPath;
        return this;
    }

    @NotNull
    public String getTemporaryStagingDirectoryPath() {
        return this.temporaryStagingDirectoryPath;
    }

    @Config(value="hive.delegate-transactional-managed-table-location-to-metastore")
    @ConfigDescription(value="When transactional, managed table is created via Trino the location will not be set in request sent to HMS and location will be determined by metastore; if this value is set to true, CREATE TABLE AS queries are not supported.")
    public HiveConfig setDelegateTransactionalManagedTableLocationToMetastore(boolean delegateTransactionalManagedTableLocationToMetastore) {
        this.delegateTransactionalManagedTableLocationToMetastore = delegateTransactionalManagedTableLocationToMetastore;
        return this;
    }

    public boolean isDelegateTransactionalManagedTableLocationToMetastore() {
        return this.delegateTransactionalManagedTableLocationToMetastore;
    }

    @Config(value="hive.transaction-heartbeat-interval")
    @ConfigDescription(value="Interval after which heartbeat is sent for open Hive transaction")
    public HiveConfig setHiveTransactionHeartbeatInterval(Duration interval) {
        this.hiveTransactionHeartbeatInterval = Optional.ofNullable(interval);
        return this;
    }

    @NotNull
    public Optional<Duration> getHiveTransactionHeartbeatInterval() {
        return this.hiveTransactionHeartbeatInterval;
    }

    public int getHiveTransactionHeartbeatThreads() {
        return this.hiveTransactionHeartbeatThreads;
    }

    @Config(value="hive.transaction-heartbeat-threads")
    @ConfigDescription(value="Number of threads to run in the Hive transaction heartbeat service")
    public HiveConfig setHiveTransactionHeartbeatThreads(int hiveTransactionHeartbeatThreads) {
        this.hiveTransactionHeartbeatThreads = hiveTransactionHeartbeatThreads;
        return this;
    }

    public boolean isAllowRegisterPartition() {
        return this.allowRegisterPartition;
    }

    @Config(value="hive.allow-register-partition-procedure")
    public HiveConfig setAllowRegisterPartition(boolean allowRegisterPartition) {
        this.allowRegisterPartition = allowRegisterPartition;
        return this;
    }

    public boolean isQueryPartitionFilterRequired() {
        return this.queryPartitionFilterRequired;
    }

    @Config(value="hive.query-partition-filter-required")
    @ConfigDescription(value="Require filter on at least one partition column")
    public HiveConfig setQueryPartitionFilterRequired(boolean queryPartitionFilterRequired) {
        this.queryPartitionFilterRequired = queryPartitionFilterRequired;
        return this;
    }

    public Set<String> getQueryPartitionFilterRequiredSchemas() {
        return this.queryPartitionFilterRequiredSchemas;
    }

    @Config(value="hive.query-partition-filter-required-schemas")
    @ConfigDescription(value="List of schemas for which filter on partition column is enforced")
    public HiveConfig setQueryPartitionFilterRequiredSchemas(String queryPartitionFilterRequiredSchemas) {
        this.queryPartitionFilterRequiredSchemas = ImmutableSet.copyOf((Collection)SPLITTER.splitToList((CharSequence)queryPartitionFilterRequiredSchemas.toLowerCase(Locale.ENGLISH)));
        return this;
    }

    public boolean isProjectionPushdownEnabled() {
        return this.projectionPushdownEnabled;
    }

    @Config(value="hive.projection-pushdown-enabled")
    @ConfigDescription(value="Projection pushdown into hive is enabled through applyProjection")
    public HiveConfig setProjectionPushdownEnabled(boolean projectionPushdownEnabled) {
        this.projectionPushdownEnabled = projectionPushdownEnabled;
        return this;
    }

    @NotNull
    public Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="hive.dynamic-filtering.wait-timeout")
    @LegacyConfig(value={"hive.dynamic-filtering-probe-blocking-timeout"})
    @ConfigDescription(value="Duration to wait for completion of dynamic filters during split generation")
    public HiveConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }

    public HiveTimestampPrecision getTimestampPrecision() {
        return this.timestampPrecision;
    }

    @Config(value="hive.timestamp-precision")
    @ConfigDescription(value="Precision used to represent timestamps")
    public HiveConfig setTimestampPrecision(HiveTimestampPrecision timestampPrecision) {
        this.timestampPrecision = timestampPrecision;
        return this;
    }

    public boolean isOptimizeSymlinkListing() {
        return this.optimizeSymlinkListing;
    }

    @Config(value="hive.optimize-symlink-listing")
    @ConfigDescription(value="Optimize listing for SymlinkTextFormat tables with files in a single directory")
    public HiveConfig setOptimizeSymlinkListing(boolean optimizeSymlinkListing) {
        this.optimizeSymlinkListing = optimizeSymlinkListing;
        return this;
    }

    @Config(value="hive.legacy-hive-view-translation")
    @ConfigDescription(value="Use legacy Hive view translation mechanism")
    public HiveConfig setLegacyHiveViewTranslation(boolean legacyHiveViewTranslation) {
        this.legacyHiveViewTranslation = legacyHiveViewTranslation;
        return this;
    }

    public boolean isLegacyHiveViewTranslation() {
        return this.legacyHiveViewTranslation;
    }

    public Optional<String> getIcebergCatalogName() {
        return this.icebergCatalogName;
    }

    @Config(value="hive.iceberg-catalog-name")
    @ConfigDescription(value="The catalog to redirect iceberg tables to")
    public HiveConfig setIcebergCatalogName(String icebergCatalogName) {
        this.icebergCatalogName = Optional.ofNullable(icebergCatalogName);
        return this;
    }

    @Config(value="hive.size-based-split-weights-enabled")
    public HiveConfig setSizeBasedSplitWeightsEnabled(boolean sizeBasedSplitWeightsEnabled) {
        this.sizeBasedSplitWeightsEnabled = sizeBasedSplitWeightsEnabled;
        return this;
    }

    public boolean isSizeBasedSplitWeightsEnabled() {
        return this.sizeBasedSplitWeightsEnabled;
    }

    @Config(value="hive.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned when size based split weights are enabled")
    public HiveConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }
}

