/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.DataOperationType;

public class HiveMetastoreClosure {
    private final HiveMetastore delegate;

    public HiveMetastoreClosure(HiveMetastore delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    private Table getExistingTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    public Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTable(identity, databaseName, tableName);
    }

    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    public PartitionStatistics getTableStatistics(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTableStatistics(identity, this.getExistingTable(identity, databaseName, tableName));
    }

    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        List<Partition> partitions = this.getExistingPartitionsByNames(identity, table, (List<String>)ImmutableList.copyOf(partitionNames));
        return this.delegate.getPartitionStatistics(identity, table, partitions);
    }

    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updateTableStatistics(identity, databaseName, tableName, transaction, update);
    }

    public void updatePartitionStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        this.delegate.updatePartitionStatistics(identity, table, partitionName, update);
    }

    public void updatePartitionStatistics(HiveIdentity identity, String databaseName, String tableName, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        this.delegate.updatePartitionStatistics(identity, table, updates);
    }

    public List<String> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        return this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue);
    }

    public List<String> getAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    public void createDatabase(HiveIdentity identity, Database database) {
        this.delegate.createDatabase(identity, database);
    }

    public void dropDatabase(HiveIdentity identity, String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(identity, databaseName, deleteData);
    }

    public void renameDatabase(HiveIdentity identity, String databaseName, String newDatabaseName) {
        this.delegate.renameDatabase(identity, databaseName, newDatabaseName);
    }

    public void setDatabaseOwner(HiveIdentity identity, String databaseName, HivePrincipal principal) {
        this.delegate.setDatabaseOwner(identity, databaseName, principal);
    }

    public void setTableOwner(HiveIdentity identity, String databaseName, String tableName, HivePrincipal principal) {
        this.delegate.setTableOwner(identity, databaseName, tableName, principal);
    }

    public void createTable(HiveIdentity identity, Table table, PrincipalPrivileges principalPrivileges) {
        this.delegate.createTable(identity, table, principalPrivileges);
    }

    public void dropTable(HiveIdentity identity, String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(identity, databaseName, tableName, deleteData);
    }

    public void replaceTable(HiveIdentity identity, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.delegate.replaceTable(identity, databaseName, tableName, newTable, principalPrivileges);
    }

    public void renameTable(HiveIdentity identity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        this.delegate.renameTable(identity, databaseName, tableName, newDatabaseName, newTableName);
    }

    public void commentTable(HiveIdentity identity, String databaseName, String tableName, Optional<String> comment) {
        this.delegate.commentTable(identity, databaseName, tableName, comment);
    }

    public void commentColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, Optional<String> comment) {
        this.delegate.commentColumn(identity, databaseName, tableName, columnName, comment);
    }

    public void addColumn(HiveIdentity identity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.delegate.addColumn(identity, databaseName, tableName, columnName, columnType, columnComment);
    }

    public void renameColumn(HiveIdentity identity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.delegate.renameColumn(identity, databaseName, tableName, oldColumnName, newColumnName);
    }

    public void dropColumn(HiveIdentity identity, String databaseName, String tableName, String columnName) {
        this.delegate.dropColumn(identity, databaseName, tableName, columnName);
    }

    public Optional<Partition> getPartition(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        return this.delegate.getTable(identity, databaseName, tableName).flatMap(table -> this.delegate.getPartition(identity, (Table)table, partitionValues));
    }

    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity identity, String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.delegate.getPartitionNamesByFilter(identity, databaseName, tableName, columnNames, partitionKeysFilter);
    }

    private List<Partition> getExistingPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        Map partitions = (Map)this.delegate.getPartitionsByNames(identity, table, partitionNames).entrySet().stream().map(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), (Object)((Partition)((Optional)entry.getValue()).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), HivePartitionManager.extractPartitionValues((String)entry.getKey())))))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return (List)partitionNames.stream().map(partitions::get).collect(ImmutableList.toImmutableList());
    }

    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, String databaseName, String tableName, List<String> partitionNames) {
        return this.delegate.getTable(identity, databaseName, tableName).map(table -> this.delegate.getPartitionsByNames(identity, (Table)table, partitionNames)).orElseGet(() -> (Map)partitionNames.stream().collect(ImmutableMap.toImmutableMap(name -> name, name -> Optional.empty())));
    }

    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(identity, databaseName, tableName, partitions);
    }

    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(identity, databaseName, tableName, parts, deleteData);
    }

    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(identity, databaseName, tableName, partition);
    }

    public void createRole(String role, String grantor) {
        this.delegate.createRole(role, grantor);
    }

    public void dropRole(String role) {
        this.delegate.dropRole(role);
    }

    public Set<String> listRoles() {
        return this.delegate.listRoles();
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    public Set<RoleGrant> listGrantedPrincipals(String role) {
        return this.delegate.listGrantedPrincipals(role);
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    public boolean isImpersonationEnabled() {
        return this.delegate.isImpersonationEnabled();
    }

    public long openTransaction(HiveIdentity identity) {
        return this.delegate.openTransaction(identity);
    }

    public void commitTransaction(HiveIdentity identity, long transactionId) {
        this.delegate.commitTransaction(identity, transactionId);
    }

    public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        this.delegate.sendTransactionHeartbeat(identity, transactionId);
    }

    public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(identity, queryId, transactionId, fullTables, partitions);
    }

    public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(identity, tables, currentTransactionId);
    }

    public Optional<String> getConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    public long allocateWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(identity, dbName, tableName, transactionId);
    }

    public void acquireTableWriteLock(HiveIdentity identity, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isPartitioned) {
        this.delegate.acquireTableWriteLock(identity, queryId, transactionId, dbName, tableName, operation, isPartitioned);
    }

    public void updateTableWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(identity, dbName, tableName, transactionId, writeId, rowCountChange);
    }

    public void alterPartitions(HiveIdentity identity, String dbName, String tableName, List<Partition> partitions, long writeId) {
        this.delegate.alterPartitions(identity, dbName, tableName, partitions, writeId);
    }

    public void addDynamicPartitions(HiveIdentity identity, String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(identity, dbName, tableName, partitionNames, transactionId, writeId, operation);
    }

    public void alterTransactionalTable(HiveIdentity identity, Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        this.delegate.alterTransactionalTable(identity, table, transactionId, writeId, principalPrivileges);
    }
}

