/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveBucketFunction;
import io.trino.plugin.hive.HivePartitionHandle;
import io.trino.plugin.hive.HivePartitionedBucketFunction;
import io.trino.plugin.hive.HivePartitioningHandle;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveType;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorBucketNodeMap;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private static final int PARTITIONED_BUCKETS_PER_NODE = 32;
    private final NodeManager nodeManager;
    private final TypeOperators typeOperators;

    @Inject
    public HiveNodePartitioningProvider(NodeManager nodeManager, TypeManager typeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.typeOperators = Objects.requireNonNull(typeManager, "typeManager is null").getTypeOperators();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveBucketTypes = handle.getHiveTypes();
        if (!handle.isUsePartitionedBucketing()) {
            return new HiveBucketFunction(handle.getBucketingVersion(), bucketCount, hiveBucketTypes);
        }
        return new HivePartitionedBucketFunction(handle.getBucketingVersion(), handle.getBucketCount(), hiveBucketTypes, partitionChannelTypes.subList(hiveBucketTypes.size(), partitionChannelTypes.size()), this.typeOperators, bucketCount);
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        if (!handle.isUsePartitionedBucketing()) {
            return ConnectorBucketNodeMap.createBucketNodeMap((int)handle.getBucketCount());
        }
        return ConnectorBucketNodeMap.createBucketNodeMap(HiveNodePartitioningProvider.createArbitraryBucketToNode((List<Node>)ImmutableList.copyOf((Collection)this.nodeManager.getRequiredWorkerNodes()), this.nodeManager.getRequiredWorkerNodes().size() * 32));
    }

    private static List<Node> createArbitraryBucketToNode(List<Node> nodes, int bucketCount) {
        return (List)HiveNodePartitioningProvider.cyclingShuffledStream(nodes).limit(bucketCount).collect(ImmutableList.toImmutableList());
    }

    private static <T> Stream<T> cyclingShuffledStream(Collection<T> collection) {
        ArrayList list = new ArrayList(collection);
        Collections.shuffle(list);
        return Stream.generate(() -> list).flatMap(Collection::stream);
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((HiveSplit)value).getBucketNumber().orElseThrow(() -> new IllegalArgumentException("Bucket number not set in split"));
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        int bucketCount = handle.getBucketCount();
        return (List)IntStream.range(0, bucketCount).mapToObj(HivePartitionHandle::new).collect(ImmutableList.toImmutableList());
    }
}

