/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveBucketFunction;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWriter;
import io.trino.plugin.hive.HiveWriterFactory;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.IntegerType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class HivePageSink
implements ConnectorPageSink {
    private static final Logger log = Logger.get(HivePageSink.class);
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final HiveWriterFactory writerFactory;
    private final int[] dataColumnInputIndex;
    private final int[] partitionColumnsInputIndex;
    private final int[] bucketColumns;
    private final HiveBucketFunction bucketFunction;
    private final HiveWriterPagePartitioner pagePartitioner;
    private final HdfsEnvironment hdfsEnvironment;
    private final int maxOpenWriters;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final List<HiveWriter> writers = new ArrayList<HiveWriter>();
    private final ConnectorSession session;
    private final OptionalLong targetMaxFileSize;
    private final List<HiveWriter> closedWriters = new ArrayList<HiveWriter>();
    private final List<Slice> partitionUpdates = new ArrayList<Slice>();
    private final List<Callable<Object>> verificationTasks = new ArrayList<Callable<Object>>();
    private long writtenBytes;
    private long systemMemoryUsage;
    private long validationCpuNanos;

    public HivePageSink(HiveWriterFactory writerFactory, List<HiveColumnHandle> inputColumns, Optional<HiveBucketProperty> bucketProperty, PageIndexerFactory pageIndexerFactory, HdfsEnvironment hdfsEnvironment, int maxOpenWriters, ListeningExecutorService writeVerificationExecutor, JsonCodec<PartitionUpdate> partitionUpdateCodec, ConnectorSession session) {
        this.writerFactory = Objects.requireNonNull(writerFactory, "writerFactory is null");
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.maxOpenWriters = maxOpenWriters;
        this.writeVerificationExecutor = Objects.requireNonNull(writeVerificationExecutor, "writeVerificationExecutor is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.pagePartitioner = new HiveWriterPagePartitioner(inputColumns, bucketProperty.isPresent(), pageIndexerFactory);
        ImmutableList.Builder partitionColumns = ImmutableList.builder();
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        Object2IntOpenHashMap dataColumnNameToIdMap = new Object2IntOpenHashMap();
        HashMap<String, HiveType> dataColumnNameToTypeMap = new HashMap<String, HiveType>();
        for (int inputIndex = 0; inputIndex < inputColumns.size(); ++inputIndex) {
            HiveColumnHandle column = inputColumns.get(inputIndex);
            if (column.isPartitionKey()) {
                partitionColumns.add((Object)inputIndex);
                continue;
            }
            dataColumnsInputIndex.add((Object)inputIndex);
            dataColumnNameToIdMap.put((Object)column.getName(), inputIndex);
            dataColumnNameToTypeMap.put(column.getName(), column.getHiveType());
        }
        this.partitionColumnsInputIndex = Ints.toArray((Collection)partitionColumns.build());
        this.dataColumnInputIndex = Ints.toArray((Collection)dataColumnsInputIndex.build());
        if (bucketProperty.isPresent()) {
            HiveBucketing.BucketingVersion bucketingVersion = bucketProperty.get().getBucketingVersion();
            int bucketCount = bucketProperty.get().getBucketCount();
            this.bucketColumns = bucketProperty.get().getBucketedBy().stream().mapToInt(arg_0 -> ((Object2IntMap)dataColumnNameToIdMap).get(arg_0)).toArray();
            List<HiveType> bucketColumnTypes = bucketProperty.get().getBucketedBy().stream().map(dataColumnNameToTypeMap::get).collect(Collectors.toList());
            this.bucketFunction = new HiveBucketFunction(bucketingVersion, bucketCount, bucketColumnTypes);
        } else {
            this.bucketColumns = null;
            this.bucketFunction = null;
        }
        this.session = Objects.requireNonNull(session, "session is null");
        this.targetMaxFileSize = Optional.ofNullable(HiveSessionProperties.getTargetMaxFileSize(session)).stream().mapToLong(DataSize::toBytes).findAny();
    }

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryUsage;
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ListenableFuture result = this.hdfsEnvironment.doAs(this.session.getIdentity(), this::doFinish);
        return MoreFutures.toCompletableFuture((ListenableFuture)result);
    }

    private ListenableFuture<Collection<Slice>> doFinish() {
        for (HiveWriter writer : this.writers) {
            this.closeWriter(writer);
        }
        ImmutableList result = ImmutableList.copyOf(this.partitionUpdates);
        this.writtenBytes = this.closedWriters.stream().mapToLong(HiveWriter::getWrittenBytes).sum();
        this.validationCpuNanos = this.closedWriters.stream().mapToLong(HiveWriter::getValidationCpuNanos).sum();
        if (this.verificationTasks.isEmpty()) {
            return Futures.immediateFuture((Object)result);
        }
        try {
            List futures = this.writeVerificationExecutor.invokeAll(this.verificationTasks).stream().map(future -> (ListenableFuture)future).collect(Collectors.toList());
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), arg_0 -> HivePageSink.lambda$doFinish$1((List)result, arg_0), (Executor)MoreExecutors.directExecutor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void abort() {
        this.hdfsEnvironment.doAs(this.session.getIdentity(), this::doAbort);
    }

    private void doAbort() {
        Optional<Object> rollbackException = Optional.empty();
        for (HiveWriter writer : Iterables.concat(this.writers, this.closedWriters)) {
            if (writer == null) continue;
            try {
                writer.rollback();
            }
            catch (Exception e) {
                log.warn("exception '%s' while rollback on %s", new Object[]{e, writer});
                rollbackException = Optional.of(e);
            }
        }
        if (rollbackException.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)rollbackException.get());
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        if (page.getPositionCount() > 0) {
            this.hdfsEnvironment.doAs(this.session.getIdentity(), () -> this.doAppend(page));
        }
        return NOT_BLOCKED;
    }

    private void doAppend(Page page) {
        while (page.getPositionCount() > 4096) {
            Page chunk = page.getRegion(0, 4096);
            page = page.getRegion(4096, page.getPositionCount() - 4096);
            this.writePage(chunk);
        }
        this.writePage(page);
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            counts[index] = count + 1;
        }
        Page dataPage = this.getDataPage(page);
        for (index = 0; index < writerPositions.length; ++index) {
            int[] positions = writerPositions[index];
            if (positions == null) continue;
            Page pageForWriter = dataPage;
            if (positions.length != dataPage.getPositionCount()) {
                Verify.verify((positions.length == counts[index] ? 1 : 0) != 0);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            HiveWriter writer = this.writers.get(index);
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getSystemMemoryUsage();
            writer.append(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.systemMemoryUsage += writer.getSystemMemoryUsage() - currentMemory;
        }
    }

    private void closeWriter(HiveWriter writer) {
        long currentWritten = writer.getWrittenBytes();
        long currentMemory = writer.getSystemMemoryUsage();
        writer.commit();
        this.writtenBytes += writer.getWrittenBytes() - currentWritten;
        this.systemMemoryUsage += writer.getSystemMemoryUsage() - currentMemory;
        this.closedWriters.add(writer);
        PartitionUpdate partitionUpdate = writer.getPartitionUpdate();
        this.partitionUpdates.add(Slices.wrappedBuffer((byte[])this.partitionUpdateCodec.toJsonBytes((Object)partitionUpdate)));
        writer.getVerificationTask().map(Executors::callable).ifPresent(this.verificationTasks::add);
    }

    private int[] getWriterIndexes(Page page) {
        Page partitionColumns = HivePageSink.extractColumns(page, this.partitionColumnsInputIndex);
        Block bucketBlock = this.buildBucketBlock(page);
        int[] writerIndexes = this.pagePartitioner.partitionPage(partitionColumns, bucketBlock);
        if (this.pagePartitioner.getMaxIndex() >= this.maxOpenWriters) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, String.format("Exceeded limit of %s open writers for partitions/buckets", this.maxOpenWriters));
        }
        while (this.writers.size() <= this.pagePartitioner.getMaxIndex()) {
            this.writers.add(null);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            HiveWriter writer = this.writers.get(writerIndex);
            if (writer != null) {
                if (this.bucketFunction != null || writer.getWrittenBytes() <= this.targetMaxFileSize.orElse(Long.MAX_VALUE)) continue;
                this.closeWriter(writer);
            }
            OptionalInt bucketNumber = OptionalInt.empty();
            if (bucketBlock != null) {
                bucketNumber = OptionalInt.of(bucketBlock.getInt(position, 0));
            }
            writer = this.writerFactory.createWriter(partitionColumns, position, bucketNumber);
            this.writers.set(writerIndex, writer);
        }
        Verify.verify((this.writers.size() == this.pagePartitioner.getMaxIndex() + 1 ? 1 : 0) != 0);
        Verify.verify((!this.writers.contains(null) ? 1 : 0) != 0);
        return writerIndexes;
    }

    private Page getDataPage(Page page) {
        Block[] blocks = new Block[this.dataColumnInputIndex.length];
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private Block buildBucketBlock(Page page) {
        if (this.bucketFunction == null) {
            return null;
        }
        IntArrayBlockBuilder bucketColumnBuilder = new IntArrayBlockBuilder(null, page.getPositionCount());
        Page bucketColumnsPage = HivePageSink.extractColumns(page, this.bucketColumns);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int bucket = this.bucketFunction.getBucket(bucketColumnsPage, position);
            bucketColumnBuilder.writeInt(bucket);
        }
        return bucketColumnBuilder.build();
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private static /* synthetic */ Collection lambda$doFinish$1(List result, List input) {
        return result;
    }

    private static class HiveWriterPagePartitioner {
        private final PageIndexer pageIndexer;

        public HiveWriterPagePartitioner(List<HiveColumnHandle> inputColumns, boolean bucketed, PageIndexerFactory pageIndexerFactory) {
            Objects.requireNonNull(inputColumns, "inputColumns is null");
            Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
            List partitionColumnTypes = inputColumns.stream().filter(HiveColumnHandle::isPartitionKey).map(HiveColumnHandle::getType).collect(Collectors.toList());
            if (bucketed) {
                partitionColumnTypes.add(IntegerType.INTEGER);
            }
            this.pageIndexer = pageIndexerFactory.createPageIndexer(partitionColumnTypes);
        }

        public int[] partitionPage(Page partitionColumns, Block bucketBlock) {
            if (bucketBlock != null) {
                Block[] blocks = new Block[partitionColumns.getChannelCount() + 1];
                for (int i = 0; i < partitionColumns.getChannelCount(); ++i) {
                    blocks[i] = partitionColumns.getBlock(i);
                }
                blocks[blocks.length - 1] = bucketBlock;
                partitionColumns = new Page(partitionColumns.getPositionCount(), blocks);
            }
            return this.pageIndexer.indexPage(partitionColumns);
        }

        public int getMaxIndex() {
            return this.pageIndexer.getMaxIndex();
        }
    }
}

