/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionResult;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;

public class HivePartitionManager {
    private final int maxPartitions;
    private final int domainCompactionThreshold;

    @Inject
    public HivePartitionManager(HiveConfig hiveConfig) {
        this(hiveConfig.getMaxPartitionsPerScan(), hiveConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(int maxPartitions, int domainCompactionThreshold) {
        Preconditions.checkArgument((maxPartitions >= 1 ? 1 : 0) != 0, (Object)"maxPartitions must be at least 1");
        this.maxPartitions = maxPartitions;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, HiveIdentity identity, ConnectorTableHandle tableHandle, Constraint constraint) {
        Iterable<HivePartition> partitionsIterable;
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary().intersect(hiveTableHandle.getEnforcedConstraint());
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Optional<HiveBucketHandle> hiveBucketHandle = hiveTableHandle.getBucketHandle();
        List<HiveColumnHandle> partitionColumns = hiveTableHandle.getPartitionColumns();
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, (Iterable<HivePartition>)ImmutableList.of(), (TupleDomain<HiveColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = HiveBucketing.getHiveBucketFilter(hiveTableHandle, (TupleDomain<ColumnHandle>)effectivePredicate);
        TupleDomain compactEffectivePredicate = effectivePredicate.transformKeys(HiveColumnHandle.class::cast).simplify(this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, (Iterable<HivePartition>)ImmutableList.of((Object)new HivePartition(tableName)), (TupleDomain<HiveColumnHandle>)compactEffectivePredicate, (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<ColumnHandle>)TupleDomain.all(), hiveBucketHandle, bucketFilter);
        }
        List partitionTypes = partitionColumns.stream().map(HiveColumnHandle::getType).collect(Collectors.toList());
        Predicate<Map> predicate = constraint.predicate().orElse(value -> true);
        if (hiveTableHandle.getPartitions().isPresent()) {
            partitionsIterable = (Iterable<HivePartition>)hiveTableHandle.getPartitions().get().stream().filter(partition -> this.partitionMatches(partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate, (Predicate<Map<ColumnHandle, NullableValue>>)predicate, (HivePartition)partition)).collect(ImmutableList.toImmutableList());
        } else {
            List<String> partitionNames = this.getFilteredPartitionNames(metastore, identity, tableName, partitionColumns, (TupleDomain<HiveColumnHandle>)compactEffectivePredicate);
            partitionsIterable = () -> partitionNames.stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionTypes, (TupleDomain<ColumnHandle>)effectivePredicate, predicate)).filter(Optional::isPresent).map(Optional::get).iterator();
        }
        TupleDomain remainingTupleDomain = effectivePredicate.filter((column, domain) -> !partitionColumns.contains(column));
        TupleDomain enforcedTupleDomain = effectivePredicate.filter((column, domain) -> partitionColumns.contains(column));
        return new HivePartitionResult(partitionColumns, partitionsIterable, (TupleDomain<HiveColumnHandle>)compactEffectivePredicate, (TupleDomain<ColumnHandle>)remainingTupleDomain, (TupleDomain<ColumnHandle>)enforcedTupleDomain, hiveBucketHandle, bucketFilter);
    }

    public HivePartitionResult getPartitions(ConnectorTableHandle tableHandle, List<List<String>> partitionValuesList) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        List<HiveColumnHandle> partitionColumns = hiveTableHandle.getPartitionColumns();
        Optional<HiveBucketHandle> bucketHandle = hiveTableHandle.getBucketHandle();
        List partitionColumnNames = (List)partitionColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        List partitionColumnTypes = (List)partitionColumns.stream().map(HiveColumnHandle::getType).collect(ImmutableList.toImmutableList());
        List partitionList = (List)partitionValuesList.stream().map(partitionValues -> MetastoreUtil.toPartitionName(partitionColumnNames, partitionValues)).map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionColumnTypes, (TupleDomain<ColumnHandle>)TupleDomain.all(), value -> true)).map(partition -> (HivePartition)partition.orElseThrow(() -> new VerifyException("partition must exist"))).collect(ImmutableList.toImmutableList());
        return new HivePartitionResult(partitionColumns, partitionList, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty());
    }

    public List<HivePartition> getPartitionsAsList(HivePartitionResult partitionResult) {
        ImmutableList.Builder partitionList = ImmutableList.builder();
        int count = 0;
        Iterator<HivePartition> iterator = partitionResult.getPartitions();
        while (iterator.hasNext()) {
            HivePartition partition = iterator.next();
            if (count == this.maxPartitions) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getTableName(), this.maxPartitions));
            }
            partitionList.add((Object)partition);
            ++count;
        }
        return partitionList.build();
    }

    public HiveTableHandle applyPartitionResult(HiveTableHandle handle, HivePartitionResult partitions, Optional<Set<ColumnHandle>> columns) {
        return new HiveTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getTableParameters(), (List<HiveColumnHandle>)ImmutableList.copyOf(partitions.getPartitionColumns()), handle.getDataColumns(), Optional.of(this.getPartitionsAsList(partitions)), partitions.getCompactEffectivePredicate(), partitions.getEnforcedConstraint(), partitions.getBucketHandle(), partitions.getBucketFilter(), handle.getAnalyzePartitionValues(), handle.getAnalyzeColumnNames(), (Set<ColumnHandle>)Sets.union(handle.getConstraintColumns(), (Set)columns.orElseGet(ImmutableSet::of)), handle.getProjectedColumns(), handle.getTransaction(), handle.isRecordScannedFiles(), handle.getMaxScannedFileSize());
    }

    public List<HivePartition> getOrLoadPartitions(SemiTransactionalHiveMetastore metastore, HiveIdentity identity, HiveTableHandle table) {
        return table.getPartitions().orElseGet(() -> this.getPartitionsAsList(this.getPartitions(metastore, identity, table, new Constraint(table.getEnforcedConstraint()))));
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, TupleDomain<ColumnHandle> constraintSummary, Predicate<Map<ColumnHandle, NullableValue>> constraint) {
        HivePartition partition = HivePartitionManager.parsePartition(tableName, partitionId, partitionColumns, partitionColumnTypes);
        if (this.partitionMatches(partitionColumns, constraintSummary, constraint, partition)) {
            return Optional.of(partition);
        }
        return Optional.empty();
    }

    private boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> constraintSummary, Predicate<Map<ColumnHandle, NullableValue>> constraint, HivePartition partition) {
        return HivePartitionManager.partitionMatches(partitionColumns, constraintSummary, partition) && constraint.test(partition.getKeys());
    }

    public static boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> constraintSummary, HivePartition partition) {
        if (constraintSummary.isNone()) {
            return false;
        }
        Map domains = (Map)constraintSummary.getDomains().get();
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return false;
        }
        return true;
    }

    private List<String> getFilteredPartitionNames(SemiTransactionalHiveMetastore metastore, HiveIdentity identity, SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate) {
        List columnNames = (List)partitionKeys.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        TupleDomain<String> partitionKeysFilter = MetastoreUtil.computePartitionKeyFilter(partitionKeys, effectivePredicate);
        return metastore.getPartitionNamesByFilter(identity, tableName.getSchemaName(), tableName.getTableName(), columnNames, partitionKeysFilter).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes) {
        List<String> partitionValues = HivePartitionManager.extractPartitionValues(partitionName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), partitionColumnTypes.get(i));
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.build();
        return new HivePartition(tableName, partitionName, (Map<ColumnHandle, NullableValue>)values);
    }

    public static List<String> extractPartitionValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart)));
        return values.build();
    }
}

