/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HiveUpdateProcessor;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class HiveTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<Map<String, String>> tableParameters;
    private final List<HiveColumnHandle> partitionColumns;
    private final List<HiveColumnHandle> dataColumns;
    private final Optional<List<HivePartition>> partitions;
    private final TupleDomain<HiveColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final Optional<List<List<String>>> analyzePartitionValues;
    private final Optional<Set<String>> analyzeColumnNames;
    private final Set<ColumnHandle> constraintColumns;
    private final Set<ColumnHandle> projectedColumns;
    private final AcidTransaction transaction;
    private final boolean recordScannedFiles;
    private final Optional<Long> maxScannedFileSize;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="dataColumns") List<HiveColumnHandle> dataColumns, @JsonProperty(value="compactEffectivePredicate") TupleDomain<HiveColumnHandle> compactEffectivePredicate, @JsonProperty(value="enforcedConstraint") TupleDomain<ColumnHandle> enforcedConstraint, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter, @JsonProperty(value="analyzePartitionValues") Optional<List<List<String>>> analyzePartitionValues, @JsonProperty(value="analyzeColumnNames") Optional<Set<String>> analyzeColumnNames, @JsonProperty(value="transaction") AcidTransaction transaction) {
        this(schemaName, tableName, Optional.empty(), partitionColumns, dataColumns, Optional.empty(), compactEffectivePredicate, enforcedConstraint, bucketHandle, bucketFilter, analyzePartitionValues, analyzeColumnNames, (Set<ColumnHandle>)ImmutableSet.of(), (Set<ColumnHandle>)ImmutableSet.of(), transaction, false, Optional.empty());
    }

    public HiveTableHandle(String schemaName, String tableName, Map<String, String> tableParameters, List<HiveColumnHandle> partitionColumns, List<HiveColumnHandle> dataColumns, Optional<HiveBucketHandle> bucketHandle) {
        this(schemaName, tableName, Optional.of(tableParameters), partitionColumns, dataColumns, Optional.empty(), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty(), Optional.empty(), Optional.empty(), (Set<ColumnHandle>)ImmutableSet.of(), (Set<ColumnHandle>)ImmutableSet.of(), AcidTransaction.NO_ACID_TRANSACTION, false, Optional.empty());
    }

    public HiveTableHandle(String schemaName, String tableName, Optional<Map<String, String>> tableParameters, List<HiveColumnHandle> partitionColumns, List<HiveColumnHandle> dataColumns, Optional<List<HivePartition>> partitions, TupleDomain<HiveColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> enforcedConstraint, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, Optional<List<List<String>>> analyzePartitionValues, Optional<Set<String>> analyzeColumnNames, Set<ColumnHandle> constraintColumns, Set<ColumnHandle> projectedColumns, AcidTransaction transaction, boolean recordScannedFiles, Optional<Long> maxSplitFileSize) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableParameters = Objects.requireNonNull(tableParameters, "tableParameters is null").map(ImmutableMap::copyOf);
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.dataColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(dataColumns, "dataColumns is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null").map(ImmutableList::copyOf);
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.analyzePartitionValues = Objects.requireNonNull(analyzePartitionValues, "analyzePartitionValues is null").map(ImmutableList::copyOf);
        this.analyzeColumnNames = Objects.requireNonNull(analyzeColumnNames, "analyzeColumnNames is null").map(ImmutableSet::copyOf);
        this.constraintColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(constraintColumns, "constraintColumns is null"));
        this.projectedColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(projectedColumns, "projectedColumns is null"));
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.recordScannedFiles = recordScannedFiles;
        this.maxScannedFileSize = Objects.requireNonNull(maxSplitFileSize, "maxSplitFileSize is null");
    }

    public HiveTableHandle withAnalyzePartitionValues(List<List<String>> analyzePartitionValues) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, Optional.of(analyzePartitionValues), this.analyzeColumnNames, this.constraintColumns, this.projectedColumns, this.transaction, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public HiveTableHandle withAnalyzeColumnNames(Set<String> analyzeColumnNames) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, Optional.of(analyzeColumnNames), this.constraintColumns, this.projectedColumns, this.transaction, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public HiveTableHandle withTransaction(AcidTransaction transaction) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.analyzeColumnNames, this.constraintColumns, this.projectedColumns, transaction, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public HiveTableHandle withUpdateProcessor(AcidTransaction transaction, HiveUpdateProcessor updateProcessor) {
        Objects.requireNonNull(updateProcessor, "updateProcessor is null");
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.analyzeColumnNames, this.constraintColumns, this.projectedColumns, transaction, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public HiveTableHandle withProjectedColumns(Set<ColumnHandle> projectedColumns) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.analyzeColumnNames, this.constraintColumns, projectedColumns, this.transaction, this.recordScannedFiles, this.maxScannedFileSize);
    }

    public HiveTableHandle withRecordScannedFiles(boolean recordScannedFiles) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.analyzeColumnNames, this.constraintColumns, this.projectedColumns, this.transaction, recordScannedFiles, this.maxScannedFileSize);
    }

    public HiveTableHandle withMaxScannedFileSize(Optional<Long> maxScannedFileSize) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.dataColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.analyzeColumnNames, this.constraintColumns, this.projectedColumns, this.transaction, this.recordScannedFiles, maxScannedFileSize);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public Optional<Map<String, String>> getTableParameters() {
        return this.tableParameters;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonProperty
    public List<HiveColumnHandle> getDataColumns() {
        return this.dataColumns;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        return this.enforcedConstraint;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    @JsonProperty
    public Optional<List<List<String>>> getAnalyzePartitionValues() {
        return this.analyzePartitionValues;
    }

    @JsonProperty
    public Optional<Set<String>> getAnalyzeColumnNames() {
        return this.analyzeColumnNames;
    }

    @JsonProperty
    public AcidTransaction getTransaction() {
        return this.transaction;
    }

    @JsonIgnore
    public Set<ColumnHandle> getConstraintColumns() {
        return this.constraintColumns;
    }

    @JsonIgnore
    public Set<ColumnHandle> getProjectedColumns() {
        return this.projectedColumns;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonIgnore
    public boolean isAcidDelete() {
        return this.transaction.isDelete();
    }

    @JsonIgnore
    public boolean isAcidUpdate() {
        return this.transaction.isUpdate();
    }

    @JsonIgnore
    public Optional<HiveUpdateProcessor> getUpdateProcessor() {
        return this.transaction.getUpdateProcessor();
    }

    @JsonIgnore
    public boolean isInAcidTransaction() {
        return this.transaction.isAcidTransactionRunning();
    }

    @JsonIgnore
    public long getAcidTransactionId() {
        Preconditions.checkState((boolean)this.transaction.isAcidTransactionRunning(), (Object)"The AcidTransaction is not running");
        return this.transaction.getAcidTransactionId();
    }

    @JsonIgnore
    public long getWriteId() {
        Preconditions.checkState((boolean)this.transaction.isAcidTransactionRunning(), (Object)"The AcidTransaction is not running");
        return this.transaction.getWriteId();
    }

    @JsonIgnore
    public boolean isRecordScannedFiles() {
        return this.recordScannedFiles;
    }

    @JsonIgnore
    public Optional<Long> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tableParameters, that.tableParameters) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.compactEffectivePredicate, that.compactEffectivePredicate) && Objects.equals(this.enforcedConstraint, that.enforcedConstraint) && Objects.equals(this.bucketHandle, that.bucketHandle) && Objects.equals(this.bucketFilter, that.bucketFilter) && Objects.equals(this.analyzePartitionValues, that.analyzePartitionValues) && Objects.equals(this.transaction, that.transaction) && Objects.equals(this.projectedColumns, that.projectedColumns);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, this.analyzePartitionValues, this.transaction, this.projectedColumns);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.schemaName).append(":").append(this.tableName);
        this.bucketHandle.ifPresent(bucket -> {
            builder.append(" buckets=").append(bucket.getReadBucketCount());
            if (!bucket.getSortedBy().isEmpty()) {
                builder.append(" sorted_by=").append(bucket.getSortedBy().stream().map(HiveUtil::sortingColumnToString).collect(Collectors.joining(", ", "[", "]")));
            }
        });
        return builder.toString();
    }
}

