/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.hive.AbstractHiveAcidWriters;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveUpdateProcessor;
import io.trino.plugin.hive.PartitionAndStatementId;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.UpdatablePageSource;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class HiveUpdatablePageSource
extends AbstractHiveAcidWriters
implements UpdatablePageSource {
    public static final int ORIGINAL_TRANSACTION_CHANNEL = 0;
    public static final int BUCKET_CHANNEL = 1;
    public static final int ROW_ID_CHANNEL = 2;
    public static final int ROW_CHANNEL = 3;
    public static final int ACID_ROW_STRUCT_COLUMN_ID = 6;
    private final String partitionName;
    private final ConnectorPageSource hivePageSource;
    private final AcidOperation updateKind;
    private final Block hiveRowTypeNullsBlock;
    private final long writeId;
    private final Optional<List<Integer>> dependencyChannels;
    private long maxWriteId;
    private long rowCount;
    private long insertRowCounter;
    private long initialRowId;
    private long maxNumberOfRowsPerSplit;
    private boolean closed;

    public HiveUpdatablePageSource(HiveTableHandle hiveTableHandle, String partitionName, int statementId, ConnectorPageSource hivePageSource, TypeManager typeManager, OptionalInt bucketNumber, Path bucketPath, boolean originalFile, OrcFileWriterFactory orcFileWriterFactory, Configuration configuration, ConnectorSession session, HiveType hiveRowType, List<HiveColumnHandle> dependencyColumns, AcidOperation updateKind, long initialRowId, long maxNumberOfRowsPerSplit) {
        super(hiveTableHandle.getTransaction(), statementId, bucketNumber, bucketPath, originalFile, orcFileWriterFactory, configuration, session, hiveRowType, updateKind);
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.hivePageSource = Objects.requireNonNull(hivePageSource, "hivePageSource is null");
        this.updateKind = Objects.requireNonNull(updateKind, "updateKind is null");
        this.hiveRowTypeNullsBlock = Utils.nativeValueToBlock((Type)hiveRowType.getType(typeManager), null);
        Preconditions.checkArgument((boolean)hiveTableHandle.isInAcidTransaction(), (String)"Not in a transaction; hiveTableHandle: %s", (Object)hiveTableHandle);
        this.writeId = hiveTableHandle.getWriteId();
        this.initialRowId = initialRowId;
        this.maxNumberOfRowsPerSplit = maxNumberOfRowsPerSplit;
        this.dependencyChannels = updateKind == AcidOperation.UPDATE ? Optional.of(hiveTableHandle.getUpdateProcessor().orElseThrow(() -> new IllegalArgumentException("updateProcessor not present")).makeDependencyChannelNumbers(dependencyColumns)) : Optional.empty();
    }

    public void deleteRows(Block rowIds) {
        ColumnarRow acidBlock = ColumnarRow.toColumnarRow((Block)rowIds);
        int fieldCount = acidBlock.getFieldCount();
        Preconditions.checkArgument((fieldCount == 3 ? 1 : 0) != 0, (String)"The rowId block for DELETE should have 3 children, but has %s", (int)fieldCount);
        this.deleteRowsInternal(acidBlock);
    }

    private void deleteRowsInternal(ColumnarRow columnarRow) {
        int positionCount = columnarRow.getPositionCount();
        if (columnarRow.mayHaveNull()) {
            for (int position = 0; position < positionCount; ++position) {
                Preconditions.checkArgument((!columnarRow.isNull(position) ? 1 : 0) != 0, (String)"In the delete rowIds, found null row at position %s", (int)position);
            }
        }
        Block originalTransactionChannel = columnarRow.getField(0);
        Block[] blockArray = new Block[]{new RunLengthEncodedBlock(DELETE_OPERATION_BLOCK, positionCount), originalTransactionChannel, columnarRow.getField(1), columnarRow.getField(2), RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)this.writeId, (int)positionCount), new RunLengthEncodedBlock(this.hiveRowTypeNullsBlock, positionCount)};
        Page deletePage = new Page(blockArray);
        for (int index = 0; index < positionCount; ++index) {
            this.maxWriteId = Math.max(this.maxWriteId, originalTransactionChannel.getLong(index, 0));
        }
        this.lazyInitializeDeleteFileWriter();
        ((FileWriter)this.deleteFileWriter.orElseThrow(() -> new IllegalArgumentException("deleteFileWriter not present"))).appendRows(deletePage);
        this.rowCount += (long)positionCount;
    }

    public void updateRows(Page page, List<Integer> columnValueAndRowIdChannels) {
        int positionCount = page.getPositionCount();
        Verify.verify((positionCount > 0 ? 1 : 0) != 0, (String)"Unexpected empty page", (Object[])new Object[0]);
        HiveUpdateProcessor updateProcessor = this.transaction.getUpdateProcessor().orElseThrow(() -> new IllegalArgumentException("updateProcessor not present"));
        ColumnarRow acidBlock = updateProcessor.getAcidBlock(page, columnValueAndRowIdChannels);
        int fieldCount = acidBlock.getFieldCount();
        Preconditions.checkArgument((fieldCount == 3 || fieldCount == 4 ? 1 : 0) != 0, (String)"The rowId block for UPDATE should have 3 or 4 children, but has %s", (int)fieldCount);
        this.deleteRowsInternal(acidBlock);
        Block mergedColumnsBlock = updateProcessor.createMergedColumnsBlock(page, columnValueAndRowIdChannels);
        Block currentTransactionBlock = RunLengthEncodedBlock.create((Type)BigintType.BIGINT, (Object)this.writeId, (int)positionCount);
        Block[] blockArray = new Block[]{new RunLengthEncodedBlock(INSERT_OPERATION_BLOCK, positionCount), currentTransactionBlock, acidBlock.getField(1), this.createRowIdBlock(positionCount), currentTransactionBlock, mergedColumnsBlock};
        Page insertPage = new Page(blockArray);
        this.lazyInitializeInsertFileWriter();
        ((FileWriter)this.insertFileWriter.orElseThrow(() -> new IllegalArgumentException("insertFileWriter not present"))).appendRows(insertPage);
    }

    Block createRowIdBlock(int positionCount) {
        long[] rowIds = new long[positionCount];
        for (int index = 0; index < positionCount; ++index) {
            rowIds[index] = this.initialRowId + this.insertRowCounter++;
        }
        if (this.insertRowCounter >= this.maxNumberOfRowsPerSplit) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, String.format("Trying to insert too many rows in a single split, max allowed is %d per split", this.maxNumberOfRowsPerSplit));
        }
        return new LongArrayBlock(positionCount, Optional.empty(), rowIds);
    }

    public CompletableFuture<Collection<Slice>> finish() {
        Optional<String> deltaDirectoryString;
        if (this.deleteFileWriter.isEmpty()) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        OrcFileWriter deleteWriter = (OrcFileWriter)this.deleteFileWriter.get();
        deleteWriter.setMaxWriteId(this.maxWriteId);
        deleteWriter.commit();
        switch (this.updateKind) {
            case DELETE: {
                deltaDirectoryString = Optional.empty();
                break;
            }
            case UPDATE: {
                OrcFileWriter insertWriter = (OrcFileWriter)this.insertFileWriter.get();
                insertWriter.setMaxWriteId(this.maxWriteId);
                insertWriter.commit();
                Preconditions.checkArgument((boolean)this.deltaDirectory.isPresent(), (Object)"deltaDirectory not present");
                deltaDirectoryString = Optional.of(((Path)this.deltaDirectory.get()).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown UpdateKind " + this.updateKind);
            }
        }
        Slice fragment = Slices.wrappedBuffer((byte[])PartitionAndStatementId.CODEC.toJsonBytes((Object)new PartitionAndStatementId(this.partitionName, this.statementId, this.rowCount, this.deleteDeltaDirectory.toString(), deltaDirectoryString)));
        return CompletableFuture.completedFuture(ImmutableList.of((Object)fragment));
    }

    public long getCompletedBytes() {
        return this.hivePageSource.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.hivePageSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        Page page = this.hivePageSource.getNextPage();
        if (page == null) {
            this.close();
            return null;
        }
        if (this.transaction.isUpdate()) {
            HiveUpdateProcessor updateProcessor = this.transaction.getUpdateProcessor().orElseThrow(() -> new IllegalArgumentException("updateProcessor not present"));
            List<Integer> channels = this.dependencyChannels.orElseThrow(() -> new IllegalArgumentException("dependencyChannels not present"));
            return updateProcessor.removeNonDependencyColumns(page, channels);
        }
        return page;
    }

    public long getSystemMemoryUsage() {
        return this.hivePageSource.getSystemMemoryUsage();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.hivePageSource.close();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, (Throwable)e);
        }
    }
}

