/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveToTrinoTranslator;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.type.TypeId;
import java.util.List;
import java.util.Optional;

public class LegacyHiveViewReader
implements ViewReaderUtil.ViewReader {
    @Override
    public ConnectorViewDefinition decodeViewData(String viewData, Table table, CatalogName catalogName) {
        String viewText = table.getViewExpandedText().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view expanded text: " + table.getSchemaTableName()));
        return new ConnectorViewDefinition(HiveToTrinoTranslator.translateHiveViewToTrino(viewText), Optional.of(catalogName.toString()), Optional.ofNullable(table.getDatabaseName()), (List)table.getDataColumns().stream().map(column -> new ConnectorViewDefinition.ViewColumn(column.getName(), TypeId.of((String)column.getType().getTypeSignature().toString()))).collect(ImmutableList.toImmutableList()), Optional.ofNullable(table.getParameters().get("comment")), table.getOwner(), false);
    }
}

