/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.authentication;

import io.trino.hadoop.HadoopNative;
import io.trino.plugin.base.authentication.KerberosAuthentication;
import io.trino.plugin.hive.HdfsConfigurationInitializer;
import io.trino.plugin.hive.authentication.HadoopAuthentication;
import io.trino.plugin.hive.util.ConfigurationUtils;
import java.util.Objects;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.UserGroupInformationShim;

public class KerberosHadoopAuthentication
implements HadoopAuthentication {
    private final KerberosAuthentication kerberosAuthentication;

    public static KerberosHadoopAuthentication createKerberosHadoopAuthentication(KerberosAuthentication kerberosAuthentication, HdfsConfigurationInitializer initializer) {
        HadoopNative.requireHadoopNative();
        Configuration configuration = ConfigurationUtils.getInitialConfiguration();
        initializer.initializeConfiguration(configuration);
        configuration.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)configuration);
        return new KerberosHadoopAuthentication(kerberosAuthentication);
    }

    private KerberosHadoopAuthentication(KerberosAuthentication kerberosAuthentication) {
        this.kerberosAuthentication = Objects.requireNonNull(kerberosAuthentication, "kerberosAuthentication is null");
    }

    @Override
    public UserGroupInformation getUserGroupInformation() {
        Subject subject = this.kerberosAuthentication.getSubject();
        return UserGroupInformationShim.createUserGroupInformationForSubject((Subject)subject);
    }
}

