/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.linkedin.coral.hive.hive2rel.HiveMetastoreClient;
import io.trino.plugin.hive.CoralTableRedirectionResolver;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;

public class CoralSemiTransactionalHiveMSCAdapter
implements HiveMetastoreClient {
    private final SemiTransactionalHiveMetastore delegate;
    private final HiveIdentity identity;
    private final CoralTableRedirectionResolver tableRedirection;

    public CoralSemiTransactionalHiveMSCAdapter(SemiTransactionalHiveMetastore coralHiveMetastoreClient, HiveIdentity identity, CoralTableRedirectionResolver tableRedirection) {
        this.delegate = Objects.requireNonNull(coralHiveMetastoreClient, "coralHiveMetastoreClient is null");
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.tableRedirection = Objects.requireNonNull(tableRedirection, "tableRedirection is null");
    }

    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    public Database getDatabase(String dbName) {
        return this.delegate.getDatabase(dbName).map(ThriftMetastoreUtil::toMetastoreApiDatabase).orElse(null);
    }

    public List<String> getAllTables(String dbName) {
        return this.delegate.getAllTables(dbName);
    }

    public Table getTable(String dbName, String tableName) {
        Optional<Table> redirected;
        if (!dbName.isEmpty() && !tableName.isEmpty() && (redirected = this.tableRedirection.redirect(new SchemaTableName(dbName, tableName))).isPresent()) {
            return redirected.get();
        }
        return this.delegate.getTable(this.identity, dbName, tableName).map(value -> ThriftMetastoreUtil.toMetastoreApiTable(value, PrincipalPrivileges.NO_PRIVILEGES)).orElse(null);
    }
}

