/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreDecorator;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.cache.ForCachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.ReentrantBoundedExecutor;
import io.trino.plugin.hive.metastore.procedure.FlushHiveMetastoreCacheProcedure;
import io.trino.spi.NodeManager;
import io.trino.spi.procedure.Procedure;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.concurrent.Executors;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CachingHiveMetastoreModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CachingHiveMetastoreConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HiveMetastoreDecorator.class);
        ExportBinder.newExporter((Binder)binder).export(HiveMetastore.class).as(generator -> generator.generatedNameOf(CachingHiveMetastore.class));
        Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(FlushHiveMetastoreCacheProcedure.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @DecoratedForCachingHiveMetastore
    public HiveMetastore createDecoratedHiveMetastore(@ForCachingHiveMetastore HiveMetastore delegate, Optional<HiveMetastoreDecorator> hiveMetastoreDecorator) {
        return hiveMetastoreDecorator.map(decorator -> decorator.decorate(delegate)).orElse(delegate);
    }

    @Provides
    @Singleton
    public Optional<CachingHiveMetastore> createCachingHiveMetastore(NodeManager nodeManager, @DecoratedForCachingHiveMetastore HiveMetastore delegate, CachingHiveMetastoreConfig config, CatalogName catalogName) {
        if (!nodeManager.getCurrentNode().isCoordinator() || !config.isCacheEnabled()) {
            return Optional.empty();
        }
        return Optional.of(CachingHiveMetastore.cachingHiveMetastore(delegate, new ReentrantBoundedExecutor(Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metastore-" + catalogName + "-%s"))), config.getMaxMetastoreRefreshThreads()), config));
    }

    @Provides
    @Singleton
    public HiveMetastore createHiveMetastore(@DecoratedForCachingHiveMetastore HiveMetastore delegate, Optional<CachingHiveMetastore> cachingMetastore) {
        return cachingMetastore.map(metastore -> metastore).orElse(delegate);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface DecoratedForCachingHiveMetastore {
    }
}

