/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import io.trino.plugin.hive.aws.AbstractSdkMetricsCollector;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreApiStats;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class GlueMetastoreStats {
    private final GlueMetastoreApiStats getAllDatabases = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getDatabase = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getAllTables = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getAllViews = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats createDatabase = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats dropDatabase = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats renameDatabase = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats createTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats dropTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats replaceTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getPartitionNames = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getPartitions = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getPartition = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getPartitionByName = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats addPartitions = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats dropPartition = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats alterPartition = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getColumnStatisticsForTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats getColumnStatisticsForPartition = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats updateColumnStatisticsForTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats deleteColumnStatisticsForTable = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats updateColumnStatisticsForPartition = new GlueMetastoreApiStats();
    private final GlueMetastoreApiStats deleteColumnStatisticsForPartition = new GlueMetastoreApiStats();
    private final CounterStat awsRequestCount = new CounterStat();
    private final CounterStat awsRetryCount = new CounterStat();
    private final CounterStat awsThrottleExceptions = new CounterStat();
    private final TimeStat awsRequestTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat awsClientExecuteTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final TimeStat awsClientRetryPauseTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final AtomicLong awsHttpClientPoolAvailableCount = new AtomicLong();
    private final AtomicLong awsHttpClientPoolLeasedCount = new AtomicLong();
    private final AtomicLong awsHttpClientPoolPendingCount = new AtomicLong();

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetAllDatabases() {
        return this.getAllDatabases;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetDatabase() {
        return this.getDatabase;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetAllTables() {
        return this.getAllTables;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetTable() {
        return this.getTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetAllViews() {
        return this.getAllViews;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getCreateDatabase() {
        return this.createDatabase;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getDropDatabase() {
        return this.dropDatabase;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getRenameDatabase() {
        return this.renameDatabase;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getCreateTable() {
        return this.createTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getDropTable() {
        return this.dropTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getReplaceTable() {
        return this.replaceTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetPartitionNames() {
        return this.getPartitionNames;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetPartitions() {
        return this.getPartitions;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetPartition() {
        return this.getPartition;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetPartitionByName() {
        return this.getPartitionByName;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getAddPartitions() {
        return this.addPartitions;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getDropPartition() {
        return this.dropPartition;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getAlterPartition() {
        return this.alterPartition;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetColumnStatisticsForTable() {
        return this.getColumnStatisticsForTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getGetColumnStatisticsForPartition() {
        return this.getColumnStatisticsForPartition;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getUpdateColumnStatisticsForTable() {
        return this.updateColumnStatisticsForTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getDeleteColumnStatisticsForTable() {
        return this.deleteColumnStatisticsForTable;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getUpdateColumnStatisticsForPartition() {
        return this.updateColumnStatisticsForPartition;
    }

    @Managed
    @Nested
    public GlueMetastoreApiStats getDeleteColumnStatisticsForPartition() {
        return this.deleteColumnStatisticsForPartition;
    }

    @Managed
    @Nested
    public CounterStat getAwsRequestCount() {
        return this.awsRequestCount;
    }

    @Managed
    @Nested
    public CounterStat getAwsRetryCount() {
        return this.awsRetryCount;
    }

    @Managed
    @Nested
    public CounterStat getAwsThrottleExceptions() {
        return this.awsThrottleExceptions;
    }

    @Managed
    @Nested
    public TimeStat getAwsRequestTime() {
        return this.awsRequestTime;
    }

    @Managed
    @Nested
    public TimeStat getAwsClientExecuteTime() {
        return this.awsClientExecuteTime;
    }

    @Managed
    @Nested
    public TimeStat getAwsClientRetryPauseTime() {
        return this.awsClientRetryPauseTime;
    }

    @Managed
    public long getAwsHttpClientPoolAvailableCount() {
        return this.awsHttpClientPoolAvailableCount.get();
    }

    @Managed
    public long getAwsHttpClientPoolLeasedCount() {
        return this.awsHttpClientPoolLeasedCount.get();
    }

    @Managed
    public long getAwsHttpClientPoolPendingCount() {
        return this.awsHttpClientPoolPendingCount.get();
    }

    public GlueSdkClientMetricsCollector newRequestMetricsCollector() {
        return new GlueSdkClientMetricsCollector(this);
    }

    public static class GlueSdkClientMetricsCollector
    extends AbstractSdkMetricsCollector {
        private final GlueMetastoreStats stats;

        public GlueSdkClientMetricsCollector(GlueMetastoreStats stats) {
            this.stats = Objects.requireNonNull(stats, "stats is null");
        }

        @Override
        protected void recordRequestCount(long count) {
            this.stats.awsRequestCount.update(count);
        }

        @Override
        protected void recordRetryCount(long count) {
            this.stats.awsRetryCount.update(count);
        }

        @Override
        protected void recordThrottleExceptionCount(long count) {
            this.stats.awsThrottleExceptions.update(count);
        }

        @Override
        protected void recordHttpRequestTime(Duration duration) {
            this.stats.awsRequestTime.add(duration);
        }

        @Override
        protected void recordClientExecutionTime(Duration duration) {
            this.stats.awsClientExecuteTime.add(duration);
        }

        @Override
        protected void recordRetryPauseTime(Duration duration) {
            this.stats.awsClientRetryPauseTime.add(duration);
        }

        @Override
        protected void recordHttpClientPoolAvailableCount(long count) {
            this.stats.awsHttpClientPoolAvailableCount.set(count);
        }

        @Override
        protected void recordHttpClientPoolLeasedCount(long count) {
            this.stats.awsHttpClientPoolLeasedCount.set(count);
        }

        @Override
        protected void recordHttpClientPoolPendingCount(long count) {
            this.stats.awsHttpClientPoolPendingCount.set(count);
        }
    }
}

