/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;

public interface ThriftMetastore {
    public void createDatabase(HiveIdentity var1, Database var2);

    public void dropDatabase(HiveIdentity var1, String var2, boolean var3);

    public void alterDatabase(HiveIdentity var1, String var2, Database var3);

    public void createTable(HiveIdentity var1, Table var2);

    public void dropTable(HiveIdentity var1, String var2, String var3, boolean var4);

    public void alterTable(HiveIdentity var1, String var2, String var3, Table var4);

    public void alterTransactionalTable(HiveIdentity var1, Table var2, long var3, long var5);

    public List<String> getAllDatabases();

    public List<String> getAllTables(String var1);

    public List<String> getTablesWithParameter(String var1, String var2, String var3);

    public List<String> getAllViews(String var1);

    public Optional<Database> getDatabase(String var1);

    public void addPartitions(HiveIdentity var1, String var2, String var3, List<PartitionWithStatistics> var4);

    public void dropPartition(HiveIdentity var1, String var2, String var3, List<String> var4, boolean var5);

    public void alterPartition(HiveIdentity var1, String var2, String var3, PartitionWithStatistics var4);

    public Optional<List<String>> getPartitionNamesByFilter(HiveIdentity var1, String var2, String var3, List<String> var4, TupleDomain<String> var5);

    public Optional<Partition> getPartition(HiveIdentity var1, String var2, String var3, List<String> var4);

    public List<Partition> getPartitionsByNames(HiveIdentity var1, String var2, String var3, List<String> var4);

    public Optional<Table> getTable(HiveIdentity var1, String var2, String var3);

    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type var1);

    public PartitionStatistics getTableStatistics(HiveIdentity var1, Table var2);

    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity var1, Table var2, List<Partition> var3);

    public void updateTableStatistics(HiveIdentity var1, String var2, String var3, AcidTransaction var4, Function<PartitionStatistics, PartitionStatistics> var5);

    public void updatePartitionStatistics(HiveIdentity var1, Table var2, String var3, Function<PartitionStatistics, PartitionStatistics> var4);

    public void createRole(String var1, String var2);

    public void dropRole(String var1);

    public Set<String> listRoles();

    public void grantRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public void revokeRoles(Set<String> var1, Set<HivePrincipal> var2, boolean var3, HivePrincipal var4);

    public Set<RoleGrant> listGrantedPrincipals(String var1);

    public Set<RoleGrant> listRoleGrants(HivePrincipal var1);

    public void grantTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, HivePrincipal var5, Set<HivePrivilegeInfo.HivePrivilege> var6, boolean var7);

    public void revokeTablePrivileges(String var1, String var2, String var3, HivePrincipal var4, HivePrincipal var5, Set<HivePrivilegeInfo.HivePrivilege> var6, boolean var7);

    public Set<HivePrivilegeInfo> listTablePrivileges(String var1, String var2, Optional<String> var3, Optional<HivePrincipal> var4);

    public boolean isImpersonationEnabled();

    default public Optional<List<FieldSchema>> getFields(HiveIdentity identity, String databaseName, String tableName) {
        Optional<Table> table = this.getTable(identity, databaseName, tableName);
        if (table.isEmpty()) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        if (table.get().getSd() == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table is missing storage descriptor");
        }
        return Optional.of(table.get().getSd().getCols());
    }

    default public long openTransaction(HiveIdentity identity) {
        throw new UnsupportedOperationException();
    }

    default public void commitTransaction(HiveIdentity identity, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        throw new UnsupportedOperationException();
    }

    default public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId) {
        throw new UnsupportedOperationException();
    }

    default public Optional<String> getConfigValue(String name) {
        return Optional.empty();
    }

    default public long allocateWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId) {
        throw new UnsupportedOperationException();
    }

    default public void acquireTableWriteLock(HiveIdentity identity, String queryId, long transactionId, String dbName, String tableName, DataOperationType operation, boolean isDynamicPartitionWrite) {
        throw new UnsupportedOperationException();
    }

    default public long acquireTableExclusiveLock(HiveIdentity identity, String queryId, String dbName, String tableName) {
        throw new UnsupportedOperationException();
    }

    default public void releaseTableLock(HiveIdentity identity, long lockId) {
        throw new UnsupportedOperationException();
    }

    default public void updateTableWriteId(HiveIdentity identity, String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        throw new UnsupportedOperationException();
    }

    default public void alterPartitions(HiveIdentity identity, String dbName, String tableName, List<Partition> partitions, long writeId) {
        throw new UnsupportedOperationException();
    }

    default public void addDynamicPartitions(HiveIdentity identity, String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        throw new UnsupportedOperationException();
    }
}

