/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.hive.metastore.utils.FileUtils;

public class DropStatsProcedure
implements Provider<Procedure> {
    private static final MethodHandle DROP_STATS = MethodHandleUtil.methodHandle(DropStatsProcedure.class, (String)"dropStats", (Class[])new Class[]{ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, List.class});
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final HiveMetastoreClosure metastore;

    @Inject
    public DropStatsProcedure(TransactionalMetadataFactory hiveMetadataFactory, HiveMetastore metastore) {
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.metastore = new HiveMetastoreClosure(Objects.requireNonNull(metastore, "metastore is null"));
    }

    public Procedure get() {
        return new Procedure("system", "drop_stats", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("table_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("partition_values", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)), false, null)), DROP_STATS.bindTo(this));
    }

    public void dropStats(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table, List<?> partitionValues) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doDropStats(session, accessControl, schema, table, partitionValues);
        }
    }

    private void doDropStats(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table, List<?> partitionValues) {
        TransactionalMetadata hiveMetadata = this.hiveMetadataFactory.create(true);
        HiveTableHandle handle = (HiveTableHandle)hiveMetadata.getTableHandle(session, new SchemaTableName(schema, table));
        if (handle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("Table '%s' does not exist", new SchemaTableName(schema, table)));
        }
        accessControl.checkCanInsertIntoTable(null, new SchemaTableName(schema, table));
        Map columns = hiveMetadata.getColumnHandles(session, handle);
        List partitionColumns = (List)columns.values().stream().map(HiveColumnHandle.class::cast).filter(HiveColumnHandle::isPartitionKey).map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (partitionValues != null) {
            List partitionStringValues = (List)partitionValues.stream().map(DropStatsProcedure::validateParameterType).collect(ImmutableList.toImmutableList());
            DropStatsProcedure.validatePartitions(partitionStringValues, partitionColumns);
            partitionStringValues.forEach(values -> this.metastore.updatePartitionStatistics(new HiveIdentity(session.getIdentity()), schema, table, FileUtils.makePartName((List)partitionColumns, (List)values), stats -> PartitionStatistics.empty()));
        } else if (partitionColumns.isEmpty()) {
            this.metastore.updateTableStatistics(new HiveIdentity(session.getIdentity()), schema, table, AcidTransaction.NO_ACID_TRANSACTION, stats -> PartitionStatistics.empty());
        } else {
            this.metastore.getPartitionNamesByFilter(new HiveIdentity(session.getIdentity()), handle.getSchemaName(), handle.getTableName(), partitionColumns, (TupleDomain<String>)TupleDomain.all()).ifPresent(partitions -> partitions.forEach(partitionName -> this.metastore.updatePartitionStatistics(new HiveIdentity(session.getIdentity()), schema, table, (String)partitionName, stats -> PartitionStatistics.empty())));
        }
        hiveMetadata.commit();
    }

    private static List<String> validateParameterType(Object param) {
        if (param == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Null partition value");
        }
        if (param instanceof List) {
            return (List)((List)param).stream().map(String.class::cast).collect(ImmutableList.toImmutableList());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Partition value must be an array");
    }

    private static void validatePartitions(List<List<String>> partitionValues, List<String> partitionColumns) {
        if (partitionValues.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "No partitions provided");
        }
        if (partitionColumns.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Cannot specify partition values for an unpartitioned table");
        }
        partitionValues.forEach(value -> {
            if (value.size() != partitionColumns.size()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("Partition values %s don't match the number of partition columns (%s)", value, partitionColumns.size()));
            }
        });
    }
}

