/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.procedure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.authentication.HiveIdentity;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.procedure.Procedures;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;

public class RegisterPartitionProcedure
implements Provider<Procedure> {
    private static final MethodHandle REGISTER_PARTITION = MethodHandleUtil.methodHandle(RegisterPartitionProcedure.class, (String)"registerPartition", (Class[])new Class[]{ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, List.class, List.class, String.class});
    private final boolean allowRegisterPartition;
    private final TransactionalMetadataFactory hiveMetadataFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final HiveMetastoreClosure metastore;

    @Inject
    public RegisterPartitionProcedure(HiveConfig hiveConfig, TransactionalMetadataFactory hiveMetadataFactory, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment) {
        this.allowRegisterPartition = Objects.requireNonNull(hiveConfig, "hiveConfig is null").isAllowRegisterPartition();
        this.hiveMetadataFactory = Objects.requireNonNull(hiveMetadataFactory, "hiveMetadataFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.metastore = new HiveMetastoreClosure(Objects.requireNonNull(metastore, "metastore is null"));
    }

    public Procedure get() {
        return new Procedure("system", "register_partition", (List)ImmutableList.of((Object)new Procedure.Argument("schema_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("table_name", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("partition_columns", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("partition_values", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new Procedure.Argument("location", (Type)VarcharType.VARCHAR, false, null)), REGISTER_PARTITION.bindTo(this));
    }

    public void registerPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValues, String location) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doRegisterPartition(session, accessControl, schemaName, tableName, partitionColumn, partitionValues, location);
        }
    }

    private void doRegisterPartition(ConnectorSession session, ConnectorAccessControl accessControl, String schemaName, String tableName, List<String> partitionColumn, List<String> partitionValues, String location) {
        if (!this.allowRegisterPartition) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "register_partition procedure is disabled");
        }
        HiveIdentity identity = new HiveIdentity(session);
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        SchemaTableName schemaTableName = new SchemaTableName(schemaName, tableName);
        Table table = this.metastore.getTable(identity, schemaName, tableName).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        accessControl.checkCanInsertIntoTable(null, schemaTableName);
        Procedures.checkIsPartitionedTable(table);
        Procedures.checkPartitionColumns(table, partitionColumn);
        Optional<Partition> partition = this.metastore.getPartition(new HiveIdentity(session), schemaName, tableName, partitionValues);
        if (partition.isPresent()) {
            String partitionName = FileUtils.makePartName(partitionColumn, partitionValues);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Partition [%s] is already registered with location %s", partitionName, partition.get().getStorage().getLocation()));
        }
        Path partitionLocation = location == null ? new Path(table.getStorage().getLocation(), FileUtils.makePartName(partitionColumn, partitionValues)) : new Path(location);
        if (!HiveWriteUtils.pathExists(hdfsContext, this.hdfsEnvironment, partitionLocation)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Partition location does not exist: " + partitionLocation);
        }
        SemiTransactionalHiveMetastore metastore = this.hiveMetadataFactory.create(true).getMetastore();
        metastore.addPartition(session, table.getDatabaseName(), table.getTableName(), RegisterPartitionProcedure.buildPartitionObject(session, table, partitionValues, partitionLocation), partitionLocation, Optional.empty(), PartitionStatistics.empty(), false);
        metastore.commit();
    }

    private static Partition buildPartitionObject(ConnectorSession session, Table table, List<String> partitionValues, Path location) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(partitionValues).setParameters((Map<String, String>)ImmutableMap.of((Object)"presto_query_id", (Object)session.getQueryId())).withStorage(storage -> storage.setStorageFormat(table.getStorage().getStorageFormat()).setLocation(location.toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }
}

