/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rcfile;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.rcfile.RcFileCorruptionException;
import io.trino.rcfile.RcFileReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class RcFilePageSource
implements ConnectorPageSource {
    private static final long GUESSED_MEMORY_USAGE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private static final int NULL_ENTRY_SIZE = 0;
    private final RcFileReader rcFileReader;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int pageId;
    private boolean closed;

    public RcFilePageSource(RcFileReader rcFileReader, List<HiveColumnHandle> columns) {
        Objects.requireNonNull(rcFileReader, "rcFileReader is null");
        Objects.requireNonNull(columns, "columns is null");
        this.rcFileReader = rcFileReader;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        ImmutableList.Builder hiveTypesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            namesBuilder.add((Object)column.getName());
            typesBuilder.add((Object)column.getType());
            hiveTypesBuilder.add((Object)column.getHiveType());
            this.hiveColumnIndexes[columnIndex] = column.getBaseHiveColumnIndex();
            if (this.hiveColumnIndexes[columnIndex] < rcFileReader.getColumnCount()) continue;
            BlockBuilder blockBuilder = column.getType().createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getCompletedBytes() {
        return this.rcFileReader.getBytesRead();
    }

    public long getReadTimeNanos() {
        return this.rcFileReader.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.pageId;
            int currentPageSize = this.rcFileReader.advance();
            if (currentPageSize < 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? new RunLengthEncodedBlock(this.constantBlocks[fieldId], currentPageSize) : this.createBlock(currentPageSize, fieldId);
            }
            return new Page(currentPageSize, blocks);
        }
        catch (TrinoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RcFileCorruptionException e) {
            this.closeWithSuppression(e);
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", this.rcFileReader.getId()), (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", this.rcFileReader.getId()), (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rcFileReader.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getSystemMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (Exception e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private Block createBlock(int currentPageSize, int fieldId) {
        int hiveColumnIndex = this.hiveColumnIndexes[fieldId];
        return new LazyBlock(currentPageSize, (LazyBlockLoader)new RcFileBlockLoader(hiveColumnIndex));
    }

    private final class RcFileBlockLoader
    implements LazyBlockLoader {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        public RcFileBlockLoader(int columnIndex) {
            this.expectedBatchId = RcFilePageSource.this.pageId;
            this.columnIndex = columnIndex;
        }

        public final Block load() {
            Block block;
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((RcFilePageSource.this.pageId == this.expectedBatchId ? 1 : 0) != 0);
            try {
                block = RcFilePageSource.this.rcFileReader.readBlock(this.columnIndex);
            }
            catch (RcFileCorruptionException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", RcFilePageSource.this.rcFileReader.getId()), (Throwable)e);
            }
            catch (IOException | RuntimeException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", RcFilePageSource.this.rcFileReader.getId()), (Throwable)e);
            }
            this.loaded = true;
            return block;
        }
    }
}

