/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rcfile;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.rcfile.HdfsRcFileDataSource;
import io.trino.plugin.hive.rcfile.RcFilePageSource;
import io.trino.plugin.hive.util.FSDataInputStreamTail;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.rcfile.AircompressorCodecFactory;
import io.trino.rcfile.HadoopCodecFactory;
import io.trino.rcfile.MemoryRcFileDataSource;
import io.trino.rcfile.RcFileCodecFactory;
import io.trino.rcfile.RcFileCorruptionException;
import io.trino.rcfile.RcFileDataSource;
import io.trino.rcfile.RcFileDataSourceId;
import io.trino.rcfile.RcFileEncoding;
import io.trino.rcfile.RcFileReader;
import io.trino.rcfile.binary.BinaryRcFileEncoding;
import io.trino.rcfile.text.TextRcFileEncoding;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.joda.time.DateTimeZone;

public class RcFilePageSourceFactory
implements HivePageSourceFactory {
    private static final int TEXT_LEGACY_NESTING_LEVELS = 8;
    private static final int TEXT_EXTENDED_NESTING_LEVELS = 29;
    private static final DataSize BUFFER_SIZE = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final DateTimeZone timeZone;

    @Inject
    public RcFilePageSourceFactory(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, HiveConfig hiveConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.timeZone = Objects.requireNonNull(hiveConfig, "hiveConfig is null").getRcfileDateTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ReaderPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long estimatedFileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        Object dataSource;
        Optional<ReaderColumns> readerProjections;
        List projectedReaderColumns;
        BinaryRcFileEncoding rcFileEncoding;
        block21: {
            String deserializerClassName = HiveUtil.getDeserializerClassName(schema);
            if (deserializerClassName.equals(LazyBinaryColumnarSerDe.class.getName())) {
                rcFileEncoding = new BinaryRcFileEncoding(this.timeZone);
            } else if (deserializerClassName.equals(ColumnarSerDe.class.getName())) {
                rcFileEncoding = RcFilePageSourceFactory.createTextVectorEncoding(schema);
            } else {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
            projectedReaderColumns = columns;
            readerProjections = HivePageSourceProvider.projectBaseColumns(columns);
            if (readerProjections.isPresent()) {
                projectedReaderColumns = (List)readerProjections.get().get().stream().map(HiveColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            }
            try {
                FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getIdentity(), path, configuration);
                FSDataInputStream inputStream = this.hdfsEnvironment.doAs(session.getIdentity(), () -> fileSystem.open(path));
                if (estimatedFileSize < BUFFER_SIZE.toBytes()) {
                    try {
                        FSDataInputStreamTail fileTail = FSDataInputStreamTail.readTail(path.toString(), estimatedFileSize, inputStream, Math.toIntExact(BUFFER_SIZE.toBytes()));
                        dataSource = new MemoryRcFileDataSource(new RcFileDataSourceId(path.toString()), fileTail.getTailSlice());
                        break block21;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                long fileSize = this.hdfsEnvironment.doAs(session.getIdentity(), () -> fileSystem.getFileStatus(path).getLen());
                dataSource = new HdfsRcFileDataSource(path.toString(), inputStream, fileSize, this.stats);
            }
            catch (Exception e) {
                if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
                }
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, RcFilePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
            }
        }
        length = Math.min(dataSource.getSize() - start, length);
        if (length <= 0L) {
            return Optional.of(ReaderPageSource.noProjectionAdaptation((ConnectorPageSource)new EmptyPageSource()));
        }
        try {
            ImmutableMap.Builder readColumns = ImmutableMap.builder();
            HiveTimestampPrecision timestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
            for (HiveColumnHandle column : projectedReaderColumns) {
                readColumns.put((Object)column.getBaseHiveColumnIndex(), (Object)column.getHiveType().getType(this.typeManager, timestampPrecision));
            }
            RcFileReader rcFileReader = new RcFileReader((RcFileDataSource)dataSource, (RcFileEncoding)rcFileEncoding, (Map)readColumns.build(), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(configuration.getClassLoader())), start, length, BUFFER_SIZE);
            RcFilePageSource pageSource = new RcFilePageSource(rcFileReader, projectedReaderColumns);
            return Optional.of(new ReaderPageSource(pageSource, readerProjections));
        }
        catch (Throwable e) {
            try {
                dataSource.close();
            }
            catch (IOException timestampPrecision) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)e;
            }
            String message = RcFilePageSourceFactory.splitError(e, path, start, length);
            if (e instanceof RcFileCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, message, e);
            }
            if (e instanceof BlockMissingException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    public static TextRcFileEncoding createTextVectorEncoding(Properties schema) {
        int nestingLevels = !"true".equalsIgnoreCase(schema.getProperty("hive.serialization.extend.nesting.levels")) ? 8 : 29;
        byte[] separators = Arrays.copyOf(TextRcFileEncoding.DEFAULT_SEPARATORS, nestingLevels);
        separators[0] = LazyUtils.getByte((String)schema.getProperty("field.delim", schema.getProperty("serialization.format")), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[0]);
        separators[1] = LazyUtils.getByte((String)schema.getProperty("collection.delim", schema.getProperty("colelction.delim")), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[1]);
        separators[2] = LazyUtils.getByte((String)schema.getProperty("mapkey.delim"), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[2]);
        String nullSequenceString = schema.getProperty("serialization.null.format");
        Slice nullSequence = nullSequenceString == null ? TextRcFileEncoding.DEFAULT_NULL_SEQUENCE : Slices.utf8Slice((String)nullSequenceString);
        String lastColumnTakesRestString = schema.getProperty("serialization.last.column.takes.rest");
        boolean lastColumnTakesRest = "true".equalsIgnoreCase(lastColumnTakesRestString);
        String escapeProperty = schema.getProperty("escape.delim");
        Byte escapeByte = null;
        if (escapeProperty != null) {
            escapeByte = LazyUtils.getByte((String)escapeProperty, (byte)92);
        }
        return new TextRcFileEncoding(nullSequence, separators, escapeByte, lastColumnTakesRest);
    }
}

