/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;

public final class HiveCoercionPolicy {
    private final TypeManager typeManager;

    private HiveCoercionPolicy(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public static boolean canCoerce(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        return new HiveCoercionPolicy(typeManager).canCoerce(fromHiveType, toHiveType);
    }

    private boolean canCoerce(HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = this.typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = this.typeManager.getType(toHiveType.getTypeSignature());
        if (fromType instanceof VarcharType) {
            return toType instanceof VarcharType || toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (toType instanceof VarcharType) {
            return fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE)) {
            return toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT)) {
            return toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_INT)) {
            return toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT)) {
            return toHiveType.equals(HiveType.HIVE_DOUBLE) || toType instanceof DecimalType;
        }
        if (fromHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return toHiveType.equals(HiveType.HIVE_FLOAT) || toType instanceof DecimalType;
        }
        if (fromType instanceof DecimalType) {
            return toType instanceof DecimalType || toHiveType.equals(HiveType.HIVE_FLOAT) || toHiveType.equals(HiveType.HIVE_DOUBLE);
        }
        return this.canCoerceForList(fromHiveType, toHiveType) || this.canCoerceForMap(fromHiveType, toHiveType) || this.canCoerceForStruct(fromHiveType, toHiveType);
    }

    private boolean canCoerceForMap(HiveType fromHiveType, HiveType toHiveType) {
        if (fromHiveType.getCategory() != ObjectInspector.Category.MAP || toHiveType.getCategory() != ObjectInspector.Category.MAP) {
            return false;
        }
        HiveType fromKeyType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType fromValueType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        HiveType toKeyType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
        HiveType toValueType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
        return !(!fromKeyType.equals(toKeyType) && !this.canCoerce(fromKeyType, toKeyType) || !fromValueType.equals(toValueType) && !this.canCoerce(fromValueType, toValueType));
    }

    private boolean canCoerceForList(HiveType fromHiveType, HiveType toHiveType) {
        HiveType toElementType;
        if (fromHiveType.getCategory() != ObjectInspector.Category.LIST || toHiveType.getCategory() != ObjectInspector.Category.LIST) {
            return false;
        }
        HiveType fromElementType = HiveType.valueOf(((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
        return fromElementType.equals(toElementType = HiveType.valueOf(((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName())) || this.canCoerce(fromElementType, toElementType);
    }

    private boolean canCoerceForStruct(HiveType fromHiveType, HiveType toHiveType) {
        if (fromHiveType.getCategory() != ObjectInspector.Category.STRUCT || toHiveType.getCategory() != ObjectInspector.Category.STRUCT) {
            return false;
        }
        ArrayList fromFieldNames = ((StructTypeInfo)fromHiveType.getTypeInfo()).getAllStructFieldNames();
        ArrayList toFieldNames = ((StructTypeInfo)toHiveType.getTypeInfo()).getAllStructFieldNames();
        List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
        List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
        for (int i = 0; i < Math.min(fromFieldTypes.size(), toFieldTypes.size()); ++i) {
            if (!((String)fromFieldNames.get(i)).equals(toFieldNames.get(i))) {
                return false;
            }
            if (fromFieldTypes.get(i).equals(toFieldTypes.get(i)) || this.canCoerce(fromFieldTypes.get(i), toFieldTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

