/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.Path;

final class DirectoryListingCacheKey {
    private final Path path;
    private final int hashCode;
    private final boolean recursiveFilesOnly;

    public DirectoryListingCacheKey(Path path, boolean recursiveFilesOnly) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.recursiveFilesOnly = recursiveFilesOnly;
        this.hashCode = Objects.hash(path, recursiveFilesOnly);
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isRecursiveFilesOnly() {
        return this.recursiveFilesOnly;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DirectoryListingCacheKey other = (DirectoryListingCacheKey)o;
        return this.recursiveFilesOnly == other.recursiveFilesOnly && this.hashCode == other.hashCode && this.path.equals((Object)other.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("isRecursiveFilesOnly", this.recursiveFilesOnly).toString();
    }

    public static List<DirectoryListingCacheKey> allKeysWithPath(Path path) {
        return ImmutableList.of((Object)new DirectoryListingCacheKey(path, true), (Object)new DirectoryListingCacheKey(path, false));
    }
}

