/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.stats.TimeStat;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.NamenodeStats;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class HiveFileIterator
extends AbstractIterator<LocatedFileStatus> {
    private final String pathPrefix;
    private final Table table;
    private final FileSystem fileSystem;
    private final DirectoryLister directoryLister;
    private final NamenodeStats namenodeStats;
    private final NestedDirectoryPolicy nestedDirectoryPolicy;
    private final boolean ignoreAbsentPartitions;
    private final Iterator<LocatedFileStatus> remoteIterator;

    public HiveFileIterator(Table table, Path path, FileSystem fileSystem, DirectoryLister directoryLister, NamenodeStats namenodeStats, NestedDirectoryPolicy nestedDirectoryPolicy, boolean ignoreAbsentPartitions) {
        this.pathPrefix = Objects.requireNonNull(path, "path is null").toUri().getPath();
        this.table = Objects.requireNonNull(table, "table is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.nestedDirectoryPolicy = Objects.requireNonNull(nestedDirectoryPolicy, "nestedDirectoryPolicy is null");
        this.ignoreAbsentPartitions = ignoreAbsentPartitions;
        this.remoteIterator = this.getLocatedFileStatusRemoteIterator(path);
    }

    protected LocatedFileStatus computeNext() {
        block4: while (this.remoteIterator.hasNext()) {
            LocatedFileStatus status = this.getLocatedFileStatus(this.remoteIterator);
            if (this.nestedDirectoryPolicy != NestedDirectoryPolicy.RECURSE ? HiveFileIterator.isHiddenFileOrDirectory(status.getPath()) : HiveFileIterator.isHiddenOrWithinHiddenParentDirectory(status.getPath(), this.pathPrefix)) continue;
            if (status.isDirectory()) {
                switch (this.nestedDirectoryPolicy) {
                    case IGNORED: {
                        continue block4;
                    }
                    case RECURSE: 
                    case FAIL: {
                        throw new NestedDirectoryNotAllowedException(status.getPath());
                    }
                }
            }
            return status;
        }
        return (LocatedFileStatus)this.endOfData();
    }

    private Iterator<LocatedFileStatus> getLocatedFileStatusRemoteIterator(Path path) {
        FileStatusIterator fileStatusIterator;
        block12: {
            TimeStat.BlockTimer ignored = this.namenodeStats.getListLocatedStatus().time();
            try {
                fileStatusIterator = new FileStatusIterator(this.table, path, this.fileSystem, this.directoryLister, this.namenodeStats, this.nestedDirectoryPolicy == NestedDirectoryPolicy.RECURSE);
                if (ignored == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TrinoException e) {
                    if (this.ignoreAbsentPartitions) {
                        try {
                            if (!this.fileSystem.exists(path)) {
                                return Collections.emptyIterator();
                            }
                        }
                        catch (Exception ee) {
                            TrinoException trinoException = new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to check if path exists: " + path, (Throwable)ee);
                            trinoException.addSuppressed((Throwable)e);
                            throw trinoException;
                        }
                    }
                    throw e;
                }
            }
            ignored.close();
        }
        return fileStatusIterator;
    }

    private LocatedFileStatus getLocatedFileStatus(Iterator<LocatedFileStatus> iterator) {
        try (TimeStat.BlockTimer ignored = this.namenodeStats.getRemoteIteratorNext().time();){
            LocatedFileStatus locatedFileStatus = iterator.next();
            return locatedFileStatus;
        }
    }

    @VisibleForTesting
    static boolean isHiddenFileOrDirectory(Path path) {
        String pathString = path.toUri().getPath();
        int lastSeparator = pathString.lastIndexOf(47);
        return HiveFileIterator.containsHiddenPathPartAfterIndex(pathString, lastSeparator + 1);
    }

    @VisibleForTesting
    static boolean isHiddenOrWithinHiddenParentDirectory(Path path, String prefix) {
        String pathString = path.toUri().getPath();
        Preconditions.checkArgument((boolean)pathString.startsWith(prefix), (String)"path %s does not start with prefix %s", (Object)pathString, (Object)prefix);
        return HiveFileIterator.containsHiddenPathPartAfterIndex(pathString, prefix.length() + 1);
    }

    @VisibleForTesting
    static boolean containsHiddenPathPartAfterIndex(String pathString, int startFromIndex) {
        while (startFromIndex < pathString.length()) {
            char firstNameChar = pathString.charAt(startFromIndex);
            if (firstNameChar == '.' || firstNameChar == '_') {
                return true;
            }
            int nextSeparator = pathString.indexOf(47, startFromIndex);
            if (nextSeparator < 0) break;
            startFromIndex = nextSeparator + 1;
        }
        return false;
    }

    public static class NestedDirectoryNotAllowedException
    extends RuntimeException {
        private final Path nestedDirectoryPath;

        public NestedDirectoryNotAllowedException(Path nestedDirectoryPath) {
            super("Nested sub-directories are not allowed: " + nestedDirectoryPath);
            this.nestedDirectoryPath = Objects.requireNonNull(nestedDirectoryPath, "nestedDirectoryPath is null");
        }

        public Path getNestedDirectoryPath() {
            return this.nestedDirectoryPath;
        }
    }

    private static class FileStatusIterator
    implements Iterator<LocatedFileStatus> {
        private final Path path;
        private final NamenodeStats namenodeStats;
        private final RemoteIterator<LocatedFileStatus> fileStatusIterator;

        private FileStatusIterator(Table table, Path path, FileSystem fileSystem, DirectoryLister directoryLister, NamenodeStats namenodeStats, boolean recursive) {
            this.path = path;
            this.namenodeStats = namenodeStats;
            try {
                this.fileStatusIterator = recursive ? directoryLister.listFilesRecursively(fileSystem, table, path) : directoryLister.list(fileSystem, table, path);
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.fileStatusIterator.hasNext();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        @Override
        public LocatedFileStatus next() {
            try {
                return (LocatedFileStatus)this.fileStatusIterator.next();
            }
            catch (IOException e) {
                throw this.processException(e);
            }
        }

        private TrinoException processException(IOException exception) {
            this.namenodeStats.getRemoteIteratorNext().recordException(exception);
            if (exception instanceof FileNotFoundException) {
                return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, "Partition location does not exist: " + this.path);
            }
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to list directory: " + this.path, (Throwable)exception);
        }
    }

    public static enum NestedDirectoryPolicy {
        IGNORED,
        RECURSE,
        FAIL;

    }
}

