/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.airlift.stats.CounterStat;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TrinoFileSystemCacheStats {
    private final CounterStat getCalls = new CounterStat();
    private final CounterStat getUniqueCalls = new CounterStat();
    private final CounterStat getCallsFailed = new CounterStat();
    private final CounterStat removeCalls = new CounterStat();
    private final LongSupplier cacheSize;

    TrinoFileSystemCacheStats(LongSupplier cacheSize) {
        this.cacheSize = Objects.requireNonNull(cacheSize, "cacheSize is null");
    }

    @Managed
    public long getCacheSize() {
        return this.cacheSize.getAsLong();
    }

    @Managed
    @Nested
    public CounterStat getGetCalls() {
        return this.getCalls;
    }

    @Managed
    @Nested
    public CounterStat getGetCallsFailed() {
        return this.getCallsFailed;
    }

    @Managed
    @Nested
    public CounterStat getGetUniqueCalls() {
        return this.getUniqueCalls;
    }

    @Managed
    @Nested
    public CounterStat getRemoveCalls() {
        return this.removeCalls;
    }

    public void newGetCall() {
        this.getCalls.update(1L);
    }

    public void newGetUniqueCall() {
        this.getUniqueCalls.update(1L);
    }

    public void newGetCallFailed() {
        this.getCallsFailed.update(1L);
    }

    public void newRemoveCall() {
        this.removeCalls.update(1L);
    }
}

