/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.alluxio;

import alluxio.ClientContext;
import alluxio.client.table.RetryHandlingTableMasterClient;
import alluxio.client.table.TableMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.master.MasterClientContext;
import alluxio.util.ConfigurationUtils;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.alluxio.AlluxioHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.alluxio.AlluxioHiveMetastoreFactory;

public class AlluxioMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(AlluxioHiveMetastoreConfig.class);
        binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).to(AlluxioHiveMetastoreFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    public TableMasterClient provideCatalogMasterClient(AlluxioHiveMetastoreConfig config) {
        return AlluxioMetastoreModule.createCatalogMasterClient(config);
    }

    public static TableMasterClient createCatalogMasterClient(AlluxioHiveMetastoreConfig config) {
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        String addr = config.getMasterAddress();
        String[] parts = addr.split(":", 2);
        conf.set(PropertyKey.MASTER_HOSTNAME, (Object)parts[0]);
        if (parts.length > 1) {
            conf.set(PropertyKey.MASTER_RPC_PORT, (Object)parts[1]);
        }
        MasterClientContext context = MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)conf)).build();
        return new RetryHandlingTableMasterClient(context);
    }
}

