/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class GlueExpressionUtil {
    static final String NULL_STRING = "__HIVE_DEFAULT_PARTITION__";
    static final int GLUE_EXPRESSION_CHAR_LIMIT = 2048;
    private static final Set<String> QUOTED_TYPES = ImmutableSet.of((Object)"string", (Object)"char", (Object)"varchar", (Object)"date", (Object)"timestamp", (Object)"binary", (Object[])new String[]{"varbinary"});
    private static final String CONJUNCT_SEPARATOR = " AND ";
    private static final Joiner CONJUNCT_JOINER = Joiner.on((String)" AND ");
    private static final String DISJUNCT_SEPARATOR = " OR ";
    private static final Joiner DISJUNCT_JOINER = Joiner.on((String)" OR ");
    private static final Set<String> JSQL_PARSER_RESERVED_KEYWORDS = ImmutableSet.of((Object)"AS", (Object)"BY", (Object)"DO", (Object)"IS", (Object)"IN", (Object)"OR", (Object[])new String[]{"ON", "ALL", "AND", "ANY", "KEY", "NOT", "SET", "ASC", "TOP", "END", "DESC", "INTO", "NULL", "LIKE", "DROP", "JOIN", "LEFT", "FROM", "OPEN", "CASE", "WHEN", "THEN", "ELSE", "SOME", "FULL", "WITH", "TABLE", "WHERE", "USING", "UNION", "GROUP", "BEGIN", "INDEX", "INNER", "LIMIT", "OUTER", "ORDER", "RIGHT", "DELETE", "CREATE", "SELECT", "OFFSET", "EXISTS", "HAVING", "INSERT", "UPDATE", "VALUES", "ESCAPE", "PRIMARY", "NATURAL", "REPLACE", "BETWEEN", "TRUNCATE", "DISTINCT", "INTERSECT"});

    private GlueExpressionUtil() {
    }

    private static boolean isQuotedType(Type type) {
        return QUOTED_TYPES.contains(type.getTypeSignature().getBase());
    }

    private static String valueToString(Type type, Object value) {
        String s = MetastoreUtil.sqlScalarToString(type, value, NULL_STRING);
        return GlueExpressionUtil.isQuotedType(type) ? "'" + s + "'" : s;
    }

    private static boolean canConvertSqlTypeToStringForGlue(Type type, boolean assumeCanonicalPartitionKeys) {
        return !(type instanceof TimestampType) && !(type instanceof DateType) && (type instanceof CharType || type instanceof VarcharType || assumeCanonicalPartitionKeys);
    }

    public static String buildGlueExpression(List<String> columnNames, TupleDomain<String> partitionKeysFilter, boolean assumeCanonicalPartitionKeys) {
        return GlueExpressionUtil.buildGlueExpression(columnNames, partitionKeysFilter, assumeCanonicalPartitionKeys, 2048);
    }

    public static String buildGlueExpression(List<String> columnNames, TupleDomain<String> partitionKeysFilter, boolean assumeCanonicalPartitionKeys, int expressionLengthLimit) {
        Preconditions.checkState((!partitionKeysFilter.isNone() ? 1 : 0) != 0);
        if (partitionKeysFilter.isAll()) {
            return "";
        }
        ArrayList<String> perColumnExpressions = new ArrayList<String>();
        int expressionLength = 0;
        Map domains = (Map)partitionKeysFilter.getDomains().get();
        for (String columnName : columnNames) {
            Optional<String> columnExpression;
            Domain domain;
            if (JSQL_PARSER_RESERVED_KEYWORDS.contains(columnName.toUpperCase(Locale.ENGLISH)) || (domain = (Domain)domains.get(columnName)) == null || !(columnExpression = GlueExpressionUtil.buildGlueExpressionForSingleDomain(columnName, domain, assumeCanonicalPartitionKeys)).isPresent()) continue;
            int newExpressionLength = expressionLength;
            if (expressionLength > 0) {
                newExpressionLength += CONJUNCT_SEPARATOR.length();
            }
            if ((newExpressionLength += columnExpression.get().length()) > expressionLengthLimit) continue;
            perColumnExpressions.add(columnExpression.get());
            expressionLength = newExpressionLength;
        }
        return Joiner.on((String)CONJUNCT_SEPARATOR).join(perColumnExpressions);
    }

    @VisibleForTesting
    static Optional<String> buildGlueExpressionForSingleDomain(String columnName, Domain domain, boolean assumeCanonicalPartitionKeys) {
        ValueSet valueSet = domain.getValues();
        if (domain.isAll() || !GlueExpressionUtil.canConvertSqlTypeToStringForGlue(domain.getType(), assumeCanonicalPartitionKeys)) {
            return Optional.empty();
        }
        if (domain.getValues().isAll()) {
            return Optional.of(String.format("(%s <> '%s')", columnName, NULL_STRING));
        }
        if (domain.getValues().isNone()) {
            return Optional.of(String.format("(%s = '%s')", columnName, NULL_STRING));
        }
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        ArrayList<String> singleValues = new ArrayList<String>();
        for (Range range : valueSet.getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(GlueExpressionUtil.valueToString(range.getType(), range.getSingleValue()));
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                rangeConjuncts.add(String.format("%s %s %s", columnName, range.isLowInclusive() ? ">=" : ">", GlueExpressionUtil.valueToString(range.getType(), range.getLowBoundedValue())));
            }
            if (!range.isHighUnbounded()) {
                rangeConjuncts.add(String.format("%s %s %s", columnName, range.isHighInclusive() ? "<=" : "<", GlueExpressionUtil.valueToString(range.getType(), range.getHighBoundedValue())));
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + CONJUNCT_JOINER.join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            String equalsTest = String.format("(%s = %s)", columnName, Iterables.getOnlyElement(singleValues));
            disjuncts.add(equalsTest);
        } else if (singleValues.size() > 1) {
            String values = Joiner.on((String)", ").join(singleValues);
            String inClause = String.format("(%s in (%s))", columnName, values);
            disjuncts.add(inClause);
        }
        return Optional.of("(" + DISJUNCT_JOINER.join(disjuncts) + ")");
    }
}

