/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.converter;

import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.TableInput;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class GlueInputConverter {
    private GlueInputConverter() {
    }

    public static DatabaseInput convertDatabase(Database database) {
        DatabaseInput input = new DatabaseInput();
        input.setName(database.getDatabaseName());
        input.setParameters(database.getParameters());
        database.getComment().ifPresent(arg_0 -> ((DatabaseInput)input).setDescription(arg_0));
        database.getLocation().ifPresent(arg_0 -> ((DatabaseInput)input).setLocationUri(arg_0));
        return input;
    }

    public static TableInput convertTable(Table table) {
        TableInput input = new TableInput();
        input.setName(table.getTableName());
        input.setOwner((String)table.getOwner().orElse(null));
        input.setTableType(table.getTableType());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(table.getStorage(), table.getDataColumns()));
        input.setPartitionKeys((Collection)table.getPartitionColumns().stream().map(GlueInputConverter::convertColumn).collect(ImmutableList.toImmutableList()));
        input.setParameters(table.getParameters());
        table.getViewOriginalText().ifPresent(arg_0 -> ((TableInput)input).setViewOriginalText(arg_0));
        table.getViewExpandedText().ifPresent(arg_0 -> ((TableInput)input).setViewExpandedText(arg_0));
        return input;
    }

    public static PartitionInput convertPartition(PartitionWithStatistics partitionWithStatistics) {
        PartitionInput input = GlueInputConverter.convertPartition(partitionWithStatistics.getPartition());
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        input.setParameters(ThriftMetastoreUtil.updateStatisticsParameters(input.getParameters(), statistics.getBasicStatistics()));
        return input;
    }

    public static PartitionInput convertPartition(Partition partition) {
        PartitionInput input = new PartitionInput();
        input.setValues(partition.getValues());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(partition.getStorage(), partition.getColumns()));
        input.setParameters(partition.getParameters());
        return input;
    }

    private static StorageDescriptor convertStorage(Storage storage, List<Column> columns) {
        if (storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = new SerDeInfo().withSerializationLibrary(storage.getStorageFormat().getSerDeNullable()).withParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(storage.getLocation());
        sd.setColumns((Collection)columns.stream().map(GlueInputConverter::convertColumn).collect(ImmutableList.toImmutableList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setParameters((Map)ImmutableMap.of());
        Optional<HiveBucketProperty> bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumberOfBuckets(Integer.valueOf(bucketProperty.get().getBucketCount()));
            sd.setBucketColumns(bucketProperty.get().getBucketedBy());
            if (!bucketProperty.get().getSortedBy().isEmpty()) {
                sd.setSortColumns((Collection)bucketProperty.get().getSortedBy().stream().map(column -> new Order().withColumn(column.getColumnName()).withSortOrder(Integer.valueOf(column.getOrder().getHiveOrder()))).collect(ImmutableList.toImmutableList()));
            }
        }
        return sd;
    }

    private static com.amazonaws.services.glue.model.Column convertColumn(Column prestoColumn) {
        return new com.amazonaws.services.glue.model.Column().withName(prestoColumn.getName()).withType(prestoColumn.getType().toString()).withComment((String)prestoColumn.getComment().orElse(null));
    }
}

