/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.json.JsonCodec;
import io.airlift.stats.CounterStat;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.FileSystemUtils;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.hive.AbstractTestHive;
import io.trino.plugin.hive.DefaultHiveMaterializedViewMetadataFactory;
import io.trino.plugin.hive.GenericHiveRecordCursorProvider;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveEventClient;
import io.trino.plugin.hive.HiveFileSystemTestUtils;
import io.trino.plugin.hive.HiveLocationService;
import io.trino.plugin.hive.HiveMaterializedViewMetadataFactory;
import io.trino.plugin.hive.HiveMetadataFactory;
import io.trino.plugin.hive.HiveOutputTableHandle;
import io.trino.plugin.hive.HivePageSinkProvider;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HiveRedirectionsProvider;
import io.trino.plugin.hive.HiveSplitManager;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.LocationService;
import io.trino.plugin.hive.NamenodeStats;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.NoneHiveRedirectionsProvider;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.plugin.hive.PartitionsSystemTableProvider;
import io.trino.plugin.hive.PropertiesSystemTableProvider;
import io.trino.plugin.hive.SortingFileWriterConfig;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.TransactionalMetadataFactory;
import io.trino.plugin.hive.aws.athena.PartitionProjectionService;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.FileSystemDirectoryLister;
import io.trino.plugin.hive.fs.HiveFileIterator;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.ForwardingHiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.security.SqlStandardAccessControlMetadata;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.TestingNodeManager;
import io.trino.testing.TestingPageSinkId;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.AzureBlobFileSystem;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestHiveFileSystem {
    protected static final HdfsContext TESTING_CONTEXT = new HdfsContext(ConnectorIdentity.ofUser((String)"test"));
    protected String database;
    protected SchemaTableName table;
    protected SchemaTableName tableWithHeader;
    protected SchemaTableName tableWithHeaderAndFooter;
    protected SchemaTableName temporaryCreateTable;
    protected HdfsEnvironment hdfsEnvironment;
    protected LocationService locationService;
    protected TestingHiveMetastore metastoreClient;
    protected HiveMetadataFactory metadataFactory;
    protected HiveTransactionManager transactionManager;
    protected ConnectorSplitManager splitManager;
    protected ConnectorPageSinkProvider pageSinkProvider;
    protected ConnectorPageSourceProvider pageSourceProvider;
    private ExecutorService executor;
    private HiveConfig config;
    private ScheduledExecutorService heartbeatService;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-%s"));
        this.heartbeatService = Executors.newScheduledThreadPool(1);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        if (this.heartbeatService != null) {
            this.heartbeatService.shutdownNow();
            this.heartbeatService = null;
        }
    }

    protected abstract Path getBasePath();

    protected void onSetupComplete() {
    }

    protected void setup(String host, int port, String databaseName, boolean s3SelectPushdownEnabled, HdfsConfiguration hdfsConfiguration) {
        this.database = databaseName;
        this.table = new SchemaTableName(this.database, "trino_test_external_fs");
        this.tableWithHeader = new SchemaTableName(this.database, "trino_test_external_fs_with_header");
        this.tableWithHeaderAndFooter = new SchemaTableName(this.database, "trino_test_external_fs_with_header_and_footer");
        String random = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        this.temporaryCreateTable = new SchemaTableName(this.database, "tmp_trino_test_create_" + random);
        this.config = new HiveConfig().setS3SelectPushdownEnabled(s3SelectPushdownEnabled);
        HivePartitionManager hivePartitionManager = new HivePartitionManager(this.config);
        this.hdfsEnvironment = new HdfsEnvironment(hdfsConfiguration, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
        this.metastoreClient = new TestingHiveMetastore((HiveMetastore)new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(HostAndPort.fromParts((String)host, (int)port)).hiveConfig(this.config).hdfsEnvironment(this.hdfsEnvironment).build()), this.getBasePath(), this.hdfsEnvironment);
        this.locationService = new HiveLocationService(this.hdfsEnvironment);
        JsonCodec partitionUpdateCodec = JsonCodec.jsonCodec(PartitionUpdate.class);
        this.metadataFactory = new HiveMetadataFactory(new CatalogName("hive"), this.config, new HiveMetastoreConfig(), HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastoreClient), (TrinoFileSystemFactory)new HdfsFileSystemFactory(this.hdfsEnvironment), this.hdfsEnvironment, hivePartitionManager, (ExecutorService)MoreExecutors.newDirectExecutorService(), this.heartbeatService, InternalTypeManager.TESTING_TYPE_MANAGER, MetadataProvider.NOOP_METADATA_PROVIDER, this.locationService, partitionUpdateCodec, new NodeVersion("test_version"), (HiveRedirectionsProvider)new NoneHiveRedirectionsProvider(), (Set)ImmutableSet.of((Object)new PartitionsSystemTableProvider(hivePartitionManager, InternalTypeManager.TESTING_TYPE_MANAGER), (Object)new PropertiesSystemTableProvider()), (HiveMaterializedViewMetadataFactory)new DefaultHiveMaterializedViewMetadataFactory(), SqlStandardAccessControlMetadata::new, (DirectoryLister)new FileSystemDirectoryLister(), new PartitionProjectionService(this.config, (Map)ImmutableMap.of(), (TypeManager)new TestingTypeManager()), true);
        this.transactionManager = new HiveTransactionManager((TransactionalMetadataFactory)this.metadataFactory);
        this.splitManager = new HiveSplitManager(this.transactionManager, hivePartitionManager, (TrinoFileSystemFactory)new HdfsFileSystemFactory(this.hdfsEnvironment), new NamenodeStats(), this.hdfsEnvironment, (Executor)new BoundedExecutor((Executor)this.executor, this.config.getMaxSplitIteratorThreads()), new CounterStat(), this.config.getMaxOutstandingSplits(), this.config.getMaxOutstandingSplitsSize(), this.config.getMinPartitionBatchSize(), this.config.getMaxPartitionBatchSize(), this.config.getMaxInitialSplits(), this.config.getSplitLoaderConcurrency(), this.config.getMaxSplitsPerSecond(), this.config.getRecursiveDirWalkerEnabled(), InternalTypeManager.TESTING_TYPE_MANAGER, this.config.getMaxPartitionsPerScan());
        TypeOperators typeOperators = new TypeOperators();
        BlockTypeOperators blockTypeOperators = new BlockTypeOperators(typeOperators);
        this.pageSinkProvider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(this.config, this.hdfsEnvironment), (TrinoFileSystemFactory)new HdfsFileSystemFactory(this.hdfsEnvironment), this.hdfsEnvironment, HiveTestUtils.PAGE_SORTER, HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastoreClient), (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler(typeOperators), blockTypeOperators), InternalTypeManager.TESTING_TYPE_MANAGER, this.config, new SortingFileWriterConfig(), this.locationService, partitionUpdateCodec, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), HiveTestUtils.getHiveSessionProperties(this.config), new HiveWriterStats());
        this.pageSourceProvider = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, this.hdfsEnvironment, this.config, HiveTestUtils.getDefaultHivePageSourceFactories(this.hdfsEnvironment, this.config), HiveTestUtils.getDefaultHiveRecordCursorProviders(this.config, this.hdfsEnvironment), new GenericHiveRecordCursorProvider(this.hdfsEnvironment, this.config));
        this.onSetupComplete();
    }

    protected ConnectorSession newSession() {
        return HiveFileSystemTestUtils.newSession(this.config);
    }

    protected AbstractTestHive.Transaction newTransaction() {
        return HiveFileSystemTestUtils.newTransaction(this.transactionManager);
    }

    protected MaterializedResult readTable(SchemaTableName tableName) throws IOException {
        return HiveFileSystemTestUtils.readTable(tableName, this.transactionManager, this.config, this.pageSourceProvider, this.splitManager);
    }

    protected MaterializedResult filterTable(SchemaTableName tableName, List<ColumnHandle> projectedColumns) throws IOException {
        return HiveFileSystemTestUtils.filterTable(tableName, projectedColumns, this.transactionManager, this.config, this.pageSourceProvider, this.splitManager);
    }

    @Test
    public void testGetRecords() throws Exception {
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.table), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{3L}).row(new Object[]{14L}).row(new Object[]{15L}).row(new Object[]{92L}).row(new Object[]{65L}).row(new Object[]{35L}).row(new Object[]{89L}).row(new Object[]{79L}).row(new Object[]{32L}).row(new Object[]{38L}).row(new Object[]{46L}).row(new Object[]{26L}).build());
    }

    @Test
    public void testGetRecordsWithHeader() throws IOException {
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.tableWithHeader), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{2L}).row(new Object[]{71L}).row(new Object[]{82L}).row(new Object[]{81L}).row(new Object[]{82L}).row(new Object[]{84L}).row(new Object[]{59L}).row(new Object[]{4L}).row(new Object[]{52L}).row(new Object[]{35L}).row(new Object[]{36L}).row(new Object[]{2L}).build());
    }

    @Test
    public void testGetRecordsWithHeaderAndFooter() throws IOException {
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)this.readTable(this.tableWithHeaderAndFooter), (Iterable)MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{41L}).row(new Object[]{42L}).row(new Object[]{13L}).row(new Object[]{56L}).row(new Object[]{23L}).row(new Object[]{73L}).row(new Object[]{9L}).row(new Object[]{50L}).row(new Object[]{48L}).row(new Object[]{80L}).row(new Object[]{16L}).build());
    }

    @Test
    public void testGetFileStatus() throws Exception {
        Path basePath = this.getBasePath();
        Path tablePath = new Path(basePath, "trino_test_external_fs");
        Path filePath = new Path(tablePath, "test_table.csv");
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertTrue((boolean)fs.getFileStatus(basePath).isDirectory(), (String)"basePath should be considered a directory");
        Assert.assertTrue((boolean)fs.getFileStatus(tablePath).isDirectory(), (String)"tablePath should be considered a directory");
        Assert.assertTrue((boolean)fs.getFileStatus(filePath).isFile(), (String)"filePath should be considered a file");
        Assert.assertFalse((boolean)fs.getFileStatus(filePath).isDirectory(), (String)"filePath should not be considered a directory");
        Assert.assertFalse((boolean)fs.exists(new Path(basePath, "foo-" + UUID.randomUUID())), (String)"foo-random path should be found not to exist");
        Assert.assertFalse((boolean)fs.exists(new Path(basePath, "foo")), (String)"foo path should be found not to exist");
    }

    @Test
    public void testRename() throws Exception {
        Path basePath = new Path(this.getBasePath(), UUID.randomUUID().toString());
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertFalse((boolean)fs.exists(basePath));
        Path path = new Path(basePath, "foo.txt");
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertTrue((boolean)fs.exists(path));
        Path newPath = new Path(basePath, "bar.txt");
        Assert.assertFalse((boolean)fs.exists(newPath));
        Assert.assertTrue((boolean)fs.rename(path, newPath));
        Assert.assertFalse((boolean)fs.exists(path));
        Assert.assertTrue((boolean)fs.exists(newPath));
        Assert.assertFalse((boolean)fs.rename(path, path));
        Assert.assertTrue((boolean)fs.createNewFile(path));
        Assert.assertFalse((boolean)fs.rename(path, newPath));
        Assert.assertEquals((boolean)fs.rename(path, path), (boolean)(FileSystemUtils.getRawFileSystem((FileSystem)fs) instanceof AzureBlobFileSystem));
        Assert.assertTrue((boolean)fs.delete(path, false));
        Assert.assertFalse((boolean)fs.exists(path));
        Path source = new Path(basePath, "source");
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Path target = new Path(basePath, "target");
        Assert.assertFalse((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.createNewFile(new Path(source, "test.txt")));
        Assert.assertTrue((boolean)fs.rename(source, target));
        Assert.assertFalse((boolean)fs.exists(source));
        target = new Path(target, "source");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.exists(new Path(target, "test.txt")));
        target = new Path(basePath, "target");
        Assert.assertTrue((boolean)fs.exists(target));
        Assert.assertTrue((boolean)fs.delete(target, true));
        Assert.assertFalse((boolean)fs.exists(target));
        fs.delete(basePath, true);
    }

    @Test
    public void testFileIteratorListing() throws Exception {
        Table.Builder tableBuilder = Table.builder().setDatabaseName(this.table.getSchemaName()).setTableName(this.table.getTableName()).setDataColumns((List)ImmutableList.of((Object)new Column("one", HiveType.HIVE_LONG, Optional.empty()))).setPartitionColumns((List)ImmutableList.of()).setOwner(Optional.empty()).setTableType("fake");
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.CSV));
        Table fakeTable = tableBuilder.build();
        Path basePath = new Path(this.getBasePath(), "test-file-iterator-listing");
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        fs.mkdirs(basePath);
        Path fileInHiddenParent = new Path(new Path(basePath, ".hidden"), "nested-file-in-hidden.txt");
        fs.createNewFile(fileInHiddenParent);
        Path nestedHiddenFile = new Path(new Path(basePath, "parent"), "_nested-hidden-file.txt");
        fs.createNewFile(nestedHiddenFile);
        Path nestedFile = new Path(new Path(basePath, "parent"), "nested-file.txt");
        fs.createNewFile(nestedFile);
        Path baseFile = new Path(basePath, "base-path-file.txt");
        fs.createNewFile(baseFile);
        Path hiddenBase = new Path(basePath, ".hidden-in-base.txt");
        fs.createNewFile(hiddenBase);
        Path emptyDirectory = new Path(basePath, "empty-directory");
        fs.mkdirs(emptyDirectory);
        HiveFileIterator recursiveIterator = new HiveFileIterator(fakeTable, basePath, fs, (DirectoryLister)new FileSystemDirectoryLister(), new NamenodeStats(), HiveFileIterator.NestedDirectoryPolicy.RECURSE, false);
        ArrayList recursiveListing = Lists.newArrayList((Iterator)Iterators.transform((Iterator)recursiveIterator, TrinoFileStatus::getPath));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)recursiveListing, (Iterable)ImmutableList.of((Object)nestedFile, (Object)baseFile));
        HiveFileIterator shallowIterator = new HiveFileIterator(fakeTable, basePath, fs, (DirectoryLister)new FileSystemDirectoryLister(), new NamenodeStats(), HiveFileIterator.NestedDirectoryPolicy.IGNORED, false);
        ArrayList shallowListing = Lists.newArrayList((Iterator)Iterators.transform((Iterator)shallowIterator, TrinoFileStatus::getPath));
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)shallowListing, (Iterable)ImmutableList.of((Object)baseFile));
    }

    @Test
    public void testDirectoryWithTrailingSpace() throws Exception {
        Path basePath = new Path(this.getBasePath(), UUID.randomUUID().toString());
        FileSystem fs = this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, basePath);
        Assert.assertFalse((boolean)fs.exists(basePath));
        Path path = new Path(new Path(basePath, "dir_with_space "), "foo.txt");
        try (FSDataOutputStream outputStream = fs.create(path);){
            outputStream.write("test".getBytes(StandardCharsets.UTF_8));
        }
        Assert.assertTrue((boolean)fs.exists(path));
        try (FSDataInputStream inputStream = fs.open(path);){
            String content = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8)).readLine();
            Assert.assertEquals((String)content, (String)"test");
        }
        fs.delete(basePath, true);
    }

    @Test
    public void testTableCreation() throws Exception {
        for (HiveStorageFormat storageFormat : HiveStorageFormat.values()) {
            if (storageFormat == HiveStorageFormat.CSV || storageFormat == HiveStorageFormat.REGEX) continue;
            this.createTable(this.temporaryCreateTable, storageFormat);
            this.dropTable(this.temporaryCreateTable);
        }
    }

    private void createTable(SchemaTableName tableName, HiveStorageFormat storageFormat) throws Exception {
        ConnectorSession session;
        ConnectorMetadata metadata;
        ImmutableList columns = ImmutableList.of((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT));
        MaterializedResult data = MaterializedResult.resultBuilder((ConnectorSession)this.newSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).row(new Object[]{3L}).row(new Object[]{2L}).build();
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName, (List)columns, AbstractTestHive.createTableProperties(storageFormat));
            ConnectorOutputTableHandle outputHandle = metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
            ConnectorPageSink sink = this.pageSinkProvider.createPageSink(transaction.getTransactionHandle(), session, outputHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
            sink.appendPage(data.toPage());
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)sink.finish());
            metadata.finishCreateTable(session, outputHandle, fragments, (Collection)ImmutableList.of());
            transaction.commit();
            this.metastoreClient.updateTableLocation(this.database, tableName.getTableName(), this.locationService.getTableWriteInfo(((HiveOutputTableHandle)outputHandle).getLocationHandle(), false).getTargetPath().toString());
        }
        transaction = this.newTransaction();
        try {
            metadata = transaction.getMetadata();
            session = this.newSession();
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHive.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session, this.getTableHandle(metadata, tableName));
            Assert.assertEquals(AbstractTestHive.filterNonHiddenColumnMetadata(tableMetadata.getColumns()), (Collection)columns);
            metadata.beginQuery(session);
            ConnectorSplitSource splitSource = AbstractTestHive.getSplits(this.splitManager, transaction, session, tableHandle);
            ConnectorSplit split = (ConnectorSplit)Iterables.getOnlyElement(AbstractTestHive.getAllSplits(splitSource));
            try (ConnectorPageSource pageSource = this.pageSourceProvider.createPageSource(transaction.getTransactionHandle(), session, split, tableHandle, columnHandles, DynamicFilter.EMPTY);){
                MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, HiveTestUtils.getTypes(columnHandles));
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)result.getMaterializedRows(), (Iterable)data.getMaterializedRows());
            }
            metadata.cleanupQuery(session);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void dropTable(SchemaTableName table) {
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            transaction.getMetastore().dropTable(this.newSession(), table.getSchemaName(), table.getTableName());
            transaction.commit();
        }
    }

    private ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        return HiveFileSystemTestUtils.getTableHandle(metadata, tableName, this.newSession());
    }

    public static class TestingHiveMetastore
    extends ForwardingHiveMetastore {
        private final Path basePath;
        private final HdfsEnvironment hdfsEnvironment;

        public TestingHiveMetastore(HiveMetastore delegate, Path basePath, HdfsEnvironment hdfsEnvironment) {
            super(delegate);
            this.basePath = basePath;
            this.hdfsEnvironment = hdfsEnvironment;
        }

        public Optional<Database> getDatabase(String databaseName) {
            return super.getDatabase(databaseName).map(database -> Database.builder((Database)database).setLocation(Optional.of(this.basePath.toString())).build());
        }

        public void createTable(Table table, PrincipalPrivileges privileges) {
            Table.Builder tableBuilder = Table.builder((Table)table);
            tableBuilder.getStorageBuilder().setLocation("/");
            super.createTable(tableBuilder.build(), privileges);
        }

        public void dropTable(String databaseName, String tableName, boolean deleteData) {
            try {
                Table table = (Table)this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
                List<String> locations = this.listAllDataPaths(databaseName, tableName);
                Table.Builder tableBuilder = Table.builder((Table)table);
                tableBuilder.getStorageBuilder().setLocation("/");
                this.replaceTable(databaseName, tableName, tableBuilder.build(), PrincipalPrivileges.NO_PRIVILEGES);
                super.dropTable(databaseName, tableName, false);
                if (deleteData) {
                    for (String location : locations) {
                        Path path = new Path(location);
                        this.hdfsEnvironment.getFileSystem(TESTING_CONTEXT, path).delete(path, true);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void updateTableLocation(String databaseName, String tableName, String location) {
            Table table = (Table)this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
            Table.Builder tableBuilder = Table.builder((Table)table);
            tableBuilder.getStorageBuilder().setLocation(location);
            this.replaceTable(databaseName, tableName, tableBuilder.build(), PrincipalPrivileges.NO_PRIVILEGES);
        }

        private List<String> listAllDataPaths(String schemaName, String tableName) {
            Optional partitionNames;
            ImmutableList.Builder locations = ImmutableList.builder();
            Table table = (Table)this.getTable(schemaName, tableName).get();
            List partitionColumnNames = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
            if (table.getStorage().getLocation() != null) {
                locations.add((Object)table.getStorage().getLocation());
            }
            if ((partitionNames = this.getPartitionNamesByFilter(schemaName, tableName, partitionColumnNames, TupleDomain.all())).isPresent()) {
                this.getPartitionsByNames(table, (List)partitionNames.get()).values().stream().map(Optional::get).map(partition -> partition.getStorage().getLocation()).filter(location -> !location.startsWith(table.getStorage().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
            }
            return locations.build();
        }
    }
}

