/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.reflect.ClassPath;
import io.airlift.log.Logger;
import io.trino.plugin.hive.AbstractTestHive;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.testing.MaterializedResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class AbstractTestHiveLocal
extends AbstractTestHive {
    private static final Logger log = Logger.get(AbstractTestHiveLocal.class);
    private static final String DEFAULT_TEST_DB_NAME = "test";
    private File tempDir;
    private final String testDbName;

    protected AbstractTestHiveLocal() {
        this(DEFAULT_TEST_DB_NAME);
    }

    protected AbstractTestHiveLocal(String testDbName) {
        this.testDbName = Objects.requireNonNull(testDbName, "testDbName is null");
    }

    protected abstract HiveMetastore createMetastore(File var1);

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        HiveMetastore metastore = this.createMetastore(this.tempDir);
        metastore.createDatabase(Database.builder().setDatabaseName(this.testDbName).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build());
        HiveConfig hiveConfig = new HiveConfig().setParquetTimeZone("America/Los_Angeles").setRcfileTimeZone("America/Los_Angeles");
        this.setup(this.testDbName, hiveConfig, metastore, HiveTestUtils.HDFS_ENVIRONMENT);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws IOException {
        try {
            this.getMetastoreClient().dropDatabase(this.testDbName, true);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((java.nio.file.Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((java.nio.file.Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Override
    protected ConnectorTableHandle getTableHandle(ConnectorMetadata metadata, SchemaTableName tableName) {
        if (tableName.getTableName().startsWith("tmp_trino_test_")) {
            return super.getTableHandle(metadata, tableName);
        }
        throw new SkipException("tests using existing tables are not supported");
    }

    @Override
    public void testGetAllTableNames() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetAllTableColumns() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetAllTableColumnsInSchema() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetTableNames() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Override
    public void testGetTableSchemaOffline() {
        throw new SkipException("Test disabled for this subclass");
    }

    @Test
    public void testSparkBucketedTableValidation() throws Exception {
        SchemaTableName table = this.temporaryTable("spark_bucket_validation");
        try {
            this.doTestSparkBucketedTableValidation(table);
        }
        finally {
            this.dropTable(table);
        }
    }

    private void doTestSparkBucketedTableValidation(SchemaTableName tableName) throws Exception {
        java.nio.file.Path externalLocation = this.copyResourceDirToTemporaryDirectory("spark_bucketed_nation");
        try {
            this.createExternalTable(tableName, HiveStorageFormat.ORC, (List<Column>)ImmutableList.of((Object)new Column("nationkey", HiveType.HIVE_INT, Optional.empty()), (Object)new Column("name", HiveType.HIVE_STRING, Optional.empty()), (Object)new Column("regionkey", HiveType.HIVE_INT, Optional.empty()), (Object)new Column("comment", HiveType.HIVE_STRING, Optional.empty())), (List<Column>)ImmutableList.of(), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"nationkey"), HiveBucketing.BucketingVersion.BUCKETING_V1, 3, (List)ImmutableList.of((Object)new SortingColumn("name", SortingColumn.Order.ASCENDING)))), new Path(URI.create("file://" + externalLocation.toString())));
            this.assertReadFailsWithMessageMatching(HiveStorageFormat.ORC, tableName, "Hive table is corrupt\\. File '.*/.*' is for bucket [0-2], but contains a row for bucket [0-2].");
            this.markTableAsCreatedBySpark(tableName, "orc");
            this.assertReadReturnsRowCount(HiveStorageFormat.ORC, tableName, 25);
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((java.nio.file.Path)externalLocation, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((java.nio.file.Path)externalLocation, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private void assertReadReturnsRowCount(HiveStorageFormat storageFormat, SchemaTableName tableName, int rowCount) throws Exception {
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            ConnectorMetadata metadata = transaction.getMetadata();
            metadata.beginQuery(session);
            ConnectorTableHandle tableHandle = this.getTableHandle(metadata, tableName);
            List<ColumnHandle> columnHandles = AbstractTestHiveLocal.filterNonHiddenColumnHandles(metadata.getColumnHandles(session, tableHandle).values());
            MaterializedResult result = this.readTable(transaction, tableHandle, columnHandles, session, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalInt.empty(), Optional.of(storageFormat));
            Assert.assertEquals((int)result.getRowCount(), (int)rowCount);
        }
    }

    private void markTableAsCreatedBySpark(SchemaTableName tableName, String provider) {
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(session);
            Table oldTable = (Table)transaction.getMetastore().getTable(tableName.getSchemaName(), tableName.getTableName()).get();
            Table.Builder newTable = Table.builder((Table)oldTable).setParameter("spark.sql.sources.provider", provider);
            transaction.getMetastore().replaceTable(tableName.getSchemaName(), tableName.getTableName(), newTable.build(), principalPrivileges);
            transaction.commit();
        }
    }

    private void createExternalTable(SchemaTableName schemaTableName, HiveStorageFormat hiveStorageFormat, List<Column> columns, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Path externalLocation) {
        try (AbstractTestHive.Transaction transaction = this.newTransaction();){
            ConnectorSession session = this.newSession();
            String tableOwner = session.getUser();
            String schemaName = schemaTableName.getSchemaName();
            String tableName = schemaTableName.getTableName();
            Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(tableOwner)).setTableType(TableType.EXTERNAL_TABLE.name()).setParameters((Map)ImmutableMap.of((Object)"presto_version", (Object)"test_version", (Object)"presto_query_id", (Object)session.getQueryId())).setDataColumns(columns).setPartitionColumns(partitionColumns);
            tableBuilder.getStorageBuilder().setLocation(externalLocation.toString()).setStorageFormat(StorageFormat.create((String)hiveStorageFormat.getSerde(), (String)hiveStorageFormat.getInputFormat(), (String)hiveStorageFormat.getOutputFormat())).setBucketProperty(bucketProperty).setSerdeParameters((Map)ImmutableMap.of());
            PrincipalPrivileges principalPrivileges = this.testingPrincipalPrivilege(tableOwner, session.getUser());
            transaction.getMetastore().createTable(session, tableBuilder.build(), principalPrivileges, Optional.of(externalLocation), Optional.empty(), true, EMPTY_TABLE_STATISTICS, false);
            transaction.commit();
        }
    }

    private java.nio.file.Path copyResourceDirToTemporaryDirectory(String resourceName) throws IOException {
        java.nio.file.Path tempDir = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]).normalize();
        log.info("Copying resource dir '%s' to %s", new Object[]{resourceName, tempDir});
        ClassPath.from((ClassLoader)this.getClass().getClassLoader()).getResources().stream().filter(resourceInfo -> resourceInfo.getResourceName().startsWith(resourceName)).forEach(resourceInfo -> {
            try {
                java.nio.file.Path target = tempDir.resolve(resourceInfo.getResourceName());
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                try (InputStream inputStream = resourceInfo.asByteSource().openStream();){
                    Files.copy(inputStream, target, new CopyOption[0]);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return tempDir.resolve(resourceName).normalize();
    }
}

