/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.MoreCollectors;
import io.trino.Session;
import io.trino.execution.QueryStats;
import io.trino.operator.OperatorStats;
import io.trino.spi.QueryId;
import io.trino.spi.metrics.Count;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedResultWithQueryId;
import io.trino.testing.QueryAssertions;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestParquetPageSkipping
extends AbstractTestQueryFramework {
    private void buildSortedTables(String tableName, String sortByColumnName, String sortByColumnType) {
        String createTableTemplate = "CREATE TABLE %s (    orderkey bigint,    custkey bigint,    orderstatus varchar(1),    totalprice double,    orderdate date,    orderpriority varchar(15),    clerk varchar(15),    shippriority integer,    comment varchar(79),    rvalues double array ) WITH (    format = 'PARQUET',    bucketed_by = array['orderstatus'],    bucket_count = 1,    sorted_by = array['%s'] )";
        createTableTemplate = createTableTemplate.replaceFirst(sortByColumnName + "[ ]+([^,]*)", sortByColumnName + " " + sortByColumnType);
        this.assertUpdate(String.format(createTableTemplate, tableName, sortByColumnName));
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "parquet_writer_page_size", "10000B").setCatalogSessionProperty(catalog, "parquet_writer_block_size", "100GB").build(), String.format("INSERT INTO %s SELECT *, ARRAY[rand(), rand(), rand()] FROM tpch.tiny.orders", tableName), 15000L);
    }

    @Test
    public void testAndPredicates() {
        String tableName = "test_and_predicate_" + TestingNames.randomNameSuffix();
        this.buildSortedTables(tableName, "totalprice", "double");
        int rowCount = this.assertColumnIndexResults("SELECT * FROM " + tableName + " WHERE totalprice BETWEEN 100000 AND 131280 AND clerk = 'Clerk#000000624'");
        Assertions.assertThat((int)rowCount).isGreaterThan(0);
        this.assertRowGroupPruning("SELECT * FROM " + tableName + " WHERE totalprice BETWEEN 51890 AND 51900 AND orderkey > 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testPageSkippingWithNonSequentialOffsets() {
        String tableName = "test_random_" + TestingNames.randomNameSuffix();
        int updateCount = 8192;
        this.assertUpdate("CREATE TABLE " + tableName + " (col) WITH (format = 'PARQUET') AS SELECT * FROM unnest(transform(repeat(1, 8192), x -> rand()))", updateCount);
        for (int i = 0; i < 8; ++i) {
            this.assertUpdate("INSERT INTO " + tableName + " SELECT rand() FROM " + tableName, updateCount);
            updateCount += updateCount;
        }
        for (double i = 0.0; i < 1.0; i += 0.1) {
            this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE col BETWEEN %f AND %f", tableName, i - 1.0E-5, i + 1.0E-5));
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testFilteringOnColumnNameWithDot() {
        String nameInSql = "\"a.dot\"";
        String tableName = "test_column_name_with_dot_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(key varchar(50), " + nameInSql + " varchar(50)) WITH (format = 'PARQUET')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('null value', NULL), ('sample value', 'abc'), ('other value', 'xyz')", 3L);
        this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " IS NULL", "VALUES ('null value')");
        this.assertQuery("SELECT key FROM " + tableName + " WHERE " + nameInSql + " = 'abc'", "VALUES ('sample value')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test(dataProvider="dataType")
    public void testPageSkipping(String sortByColumn, String sortByColumnType, Object[][] valuesArray) {
        String tableName = "test_page_skipping_" + TestingNames.randomNameSuffix();
        this.buildSortedTables(tableName, sortByColumn, sortByColumnType);
        for (Object[] values : valuesArray) {
            Object lowValue = values[0];
            Object middleLowValue = values[1];
            Object middleHighValue = values[2];
            Object highValue = values[3];
            this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s = %s", sortByColumn, tableName, sortByColumn, middleLowValue));
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s < %s", sortByColumn, tableName, sortByColumn, lowValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s > %s", sortByColumn, tableName, sortByColumn, highValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT %s FROM %s WHERE %s BETWEEN %s AND %s", sortByColumn, tableName, sortByColumn, middleLowValue, middleHighValue))).isGreaterThan(0);
            this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s = %s", tableName, sortByColumn, middleLowValue));
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s < %s", tableName, sortByColumn, lowValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s > %s", tableName, sortByColumn, highValue))).isGreaterThan(0);
            Assertions.assertThat((int)this.assertColumnIndexResults(String.format("SELECT * FROM %s WHERE %s BETWEEN %s AND %s", tableName, sortByColumn, middleLowValue, middleHighValue))).isGreaterThan(0);
            this.assertColumnIndexResults(String.format("SELECT rvalues FROM %s WHERE %s IN (%s, %s, %s, %s)", tableName, sortByColumn, lowValue, middleLowValue, middleHighValue, highValue));
            this.assertColumnIndexResults(String.format("SELECT orderkey, orderdate FROM %s WHERE %s IN (%s, %s, %s, %s)", tableName, sortByColumn, lowValue, middleLowValue, middleHighValue, highValue));
        }
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testFilteringWithColumnIndex() {
        String tableName = "test_page_filtering_" + TestingNames.randomNameSuffix();
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "parquet_writer_page_size", "32kB").build(), "CREATE TABLE " + tableName + " WITH (format = 'PARQUET', bucket_count = 1, bucketed_by = ARRAY['suppkey'], sorted_by = ARRAY['suppkey']) AS SELECT suppkey, extendedprice, shipmode, comment FROM tpch.tiny.lineitem", 60175L);
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey = 10");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey BETWEEN 25 AND 35");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey >= 60");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey <= 40");
        this.verifyFilteringWithColumnIndex("SELECT * FROM " + tableName + " WHERE suppkey IN (25, 35, 50, 80)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void verifyFilteringWithColumnIndex(@Language(value="SQL") String query) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        MaterializedResultWithQueryId resultWithoutColumnIndex = queryRunner.executeWithQueryId(this.noParquetColumnIndexFiltering(this.getSession()), query);
        QueryStats queryStatsWithoutColumnIndex = this.getQueryStats(resultWithoutColumnIndex.getQueryId());
        Assertions.assertThat((long)queryStatsWithoutColumnIndex.getPhysicalInputPositions()).isGreaterThan(0L);
        Map metricsWithoutColumnIndex = this.getScanOperatorStats(resultWithoutColumnIndex.getQueryId()).getConnectorMetrics().getMetrics();
        Assertions.assertThat((Map)metricsWithoutColumnIndex).doesNotContainKey((Object)"ParquetColumnIndexRowsFiltered");
        MaterializedResultWithQueryId resultWithColumnIndex = queryRunner.executeWithQueryId(this.getSession(), query);
        QueryStats queryStatsWithColumnIndex = this.getQueryStats(resultWithColumnIndex.getQueryId());
        Assertions.assertThat((long)queryStatsWithColumnIndex.getPhysicalInputPositions()).isGreaterThan(0L);
        Assertions.assertThat((long)queryStatsWithColumnIndex.getPhysicalInputPositions()).isLessThan(queryStatsWithoutColumnIndex.getPhysicalInputPositions());
        Map metricsWithColumnIndex = this.getScanOperatorStats(resultWithColumnIndex.getQueryId()).getConnectorMetrics().getMetrics();
        Assertions.assertThat((Map)metricsWithColumnIndex).containsKey((Object)"ParquetColumnIndexRowsFiltered");
        Assertions.assertThat((long)((Count)metricsWithColumnIndex.get("ParquetColumnIndexRowsFiltered")).getTotal()).isGreaterThan(0L);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)resultWithColumnIndex.getResult(), (Iterable)resultWithoutColumnIndex.getResult());
    }

    private int assertColumnIndexResults(String query) {
        MaterializedResult withColumnIndexing = this.computeActual(query);
        MaterializedResult withoutColumnIndexing = this.computeActual(this.noParquetColumnIndexFiltering(this.getSession()), query);
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)withColumnIndexing, (Iterable)withoutColumnIndexing);
        return withoutColumnIndexing.getRowCount();
    }

    private void assertRowGroupPruning(@Language(value="SQL") String sql) {
        this.assertQueryStats(this.noParquetColumnIndexFiltering(this.getSession()), sql, queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), sql, queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isEqualTo(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(0L);
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
    }

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{"orderkey", "bigint", new Object[][]{{2, 7520, 7523, 14950}}}, {"totalprice", "double", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}}}, {"totalprice", "real", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}}}, {"totalprice", "decimal(12,2)", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}, {973, 131095, 131280, 406950}, {974.04123, 131094.34123, 131279.97012, 406938.36555}}}, {"totalprice", "decimal(12,0)", new Object[][]{{973, 131095, 131280, 406950}}}, {"totalprice", "decimal(35,2)", new Object[][]{{974.04, 131094.34, 131279.97, 406938.36}, {973, 131095, 131280, 406950}, {974.04123, 131094.34123, 131279.97012, 406938.36555}}}, {"orderdate", "date", new Object[][]{{"DATE '1992-01-05'", "DATE '1995-10-13'", "DATE '1995-10-13'", "DATE '1998-07-29'"}}}, {"orderdate", "timestamp", new Object[][]{{"TIMESTAMP '1992-01-05'", "TIMESTAMP '1995-10-13'", "TIMESTAMP '1995-10-14'", "TIMESTAMP '1998-07-29'"}}}, {"clerk", "varchar(15)", new Object[][]{{"'Clerk#000000006'", "'Clerk#000000508'", "'Clerk#000000513'", "'Clerk#000000996'"}}}, {"custkey", "integer", new Object[][]{{4, 634, 640, 1493}}}, {"custkey", "smallint", new Object[][]{{4, 634, 640, 1493}}}};
    }

    private Session noParquetColumnIndexFiltering(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "parquet_use_column_index", "false").build();
    }

    private QueryStats getQueryStats(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats();
    }

    private OperatorStats getScanOperatorStats(QueryId queryId) {
        return (OperatorStats)this.getQueryStats(queryId).getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().startsWith("TableScan") || summary.getOperatorType().startsWith("Scan")).collect(MoreCollectors.onlyElement());
    }
}

