/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.airlift.log.Level;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.tpcds.TpcdsPlugin;
import io.trino.plugin.tpch.ColumnNaming;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.SelectedRole;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.joda.time.DateTimeZone;
import org.testng.Assert;

public final class HiveQueryRunner {
    private static final Logger log = Logger.get(HiveQueryRunner.class);
    public static final String HIVE_CATALOG = "hive";
    private static final String HIVE_BUCKETED_CATALOG = "hive_bucketed";
    public static final String TPCH_SCHEMA = "tpch";
    private static final String TPCH_BUCKETED_SCHEMA = "tpch_bucketed";
    private static final DateTimeZone TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");

    private HiveQueryRunner() {
    }

    public static DistributedQueryRunner create() throws Exception {
        return HiveQueryRunner.builder().build();
    }

    public static Builder<Builder<?>> builder() {
        return new Builder();
    }

    public static Builder<Builder<?>> builder(Session defaultSession) {
        return new Builder(defaultSession);
    }

    private static void setupLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel("org.apache.parquet.hadoop", Level.WARN);
    }

    private static Database createDatabaseMetastoreObject(String name, Optional<String> locationBase) {
        return Database.builder().setLocation(locationBase.map(base -> base + "/" + name)).setDatabaseName(name).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
    }

    private static Session createSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)HIVE_CATALOG).withConnectorRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog(HIVE_CATALOG).setSchema(TPCH_SCHEMA).build();
    }

    public static Session createBucketedSession(Optional<SelectedRole> role) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)HIVE_CATALOG).withConnectorRoles((Map)role.map(selectedRole -> ImmutableMap.of((Object)HIVE_CATALOG, (Object)selectedRole, (Object)HIVE_BUCKETED_CATALOG, (Object)selectedRole)).orElse(ImmutableMap.of())).build()).setCatalog(HIVE_BUCKETED_CATALOG).setSchema(TPCH_BUCKETED_SCHEMA).build();
    }

    private static void copyTpchTablesBucketed(QueryRunner queryRunner, String sourceCatalog, String sourceSchema, Session session, Iterable<TpchTable<?>> tables, ColumnNaming columnNaming) {
        log.info("Loading data from %s.%s...", new Object[]{sourceCatalog, sourceSchema});
        long startTime = System.nanoTime();
        for (TpchTable<?> table : tables) {
            HiveQueryRunner.copyTableBucketed(queryRunner, new QualifiedObjectName(sourceCatalog, sourceSchema, table.getTableName().toLowerCase(Locale.ENGLISH)), table, session, columnNaming);
        }
        log.info("Loading from %s.%s complete in %s", new Object[]{sourceCatalog, sourceSchema, Duration.nanosSince((long)startTime).toString(TimeUnit.SECONDS)});
    }

    private static void copyTableBucketed(QueryRunner queryRunner, QualifiedObjectName tableName, TpchTable<?> table, Session session, ColumnNaming columnNaming) {
        long start = System.nanoTime();
        log.info("Running import for %s", new Object[]{tableName.getObjectName()});
        long rows = (Long)((MaterializedRow)queryRunner.execute(session, switch (tableName.getObjectName()) {
            case "part", "partsupp", "supplier", "nation", "region" -> String.format("CREATE TABLE %s AS SELECT * FROM %s", tableName.getObjectName(), tableName);
            case "lineitem" -> String.format("CREATE TABLE %s WITH (bucketed_by=array['%s'], bucket_count=11) AS SELECT * FROM %s", tableName.getObjectName(), columnNaming.getName(table.getColumn("orderkey")), tableName);
            case "customer", "orders" -> String.format("CREATE TABLE %s WITH (bucketed_by=array['%s'], bucket_count=11) AS SELECT * FROM %s", tableName.getObjectName(), columnNaming.getName(table.getColumn("custkey")), tableName);
            default -> throw new UnsupportedOperationException();
        }).getMaterializedRows().get(0)).getField(0);
        log.info("Imported %s rows for %s in %s", new Object[]{rows, tableName.getObjectName(), Duration.nanosSince((long)start).convertToMostSuccinctTimeUnit()});
    }

    public static void main(String[] args) throws Exception {
        Optional<Object> baseDataDir = Optional.empty();
        if (args.length > 0) {
            if (args.length != 1) {
                System.err.println("usage: HiveQueryRunner [baseDataDir]");
                System.exit(1);
            }
            Path path = Paths.get(args[0], new String[0]);
            Files.createDirectories(path, new FileAttribute[0]);
            baseDataDir = Optional.of(path);
        }
        DistributedQueryRunner queryRunner = ((Builder)((Object)((Builder)((Object)((Builder)((Builder)((Object)((Builder)((Object)((Builder)HiveQueryRunner.builder().setExtraProperties((Map)ImmutableMap.of((Object)"http-server.http.port", (Object)"8080"))).setSkipTimezoneSetup(true))).setHiveProperties((Map<String, String>)ImmutableMap.of()))).setInitialTables(TpchTable.getTables()).setBaseDataDir(baseDataDir)).setTpcdsCatalogEnabled(true))).setSecurity("allow-all"))).build();
        Thread.sleep(10L);
        log.info("======== SERVER STARTED ========");
        log.info("\n====\n%s\n====", new Object[]{queryRunner.getCoordinator().getBaseUrl()});
    }

    public static class Builder<SELF extends Builder<?>>
    extends DistributedQueryRunner.Builder<SELF> {
        private boolean skipTimezoneSetup;
        private ImmutableMap.Builder<String, String> hiveProperties = ImmutableMap.builder();
        private List<TpchTable<?>> initialTables = ImmutableList.of();
        private Optional<String> initialSchemasLocationBase = Optional.empty();
        private Function<Session, Session> initialTablesSessionMutator = Function.identity();
        private Function<DistributedQueryRunner, HiveMetastore> metastore = queryRunner -> {
            File baseDir = queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data").toFile();
            return FileHiveMetastore.createTestingFileHiveMetastore((File)baseDir);
        };
        private Module module = Modules.EMPTY_MODULE;
        private Optional<DirectoryLister> directoryLister = Optional.empty();
        private boolean tpcdsCatalogEnabled;
        private boolean tpchBucketedCatalogEnabled;
        private String security = "sql-standard";
        private boolean createTpchSchemas = true;
        private ColumnNaming tpchColumnNaming = ColumnNaming.SIMPLIFIED;
        private DecimalTypeMapping tpchDecimalTypeMapping = DecimalTypeMapping.DOUBLE;

        protected Builder() {
            this(HiveQueryRunner.createSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin")))));
        }

        protected Builder(Session defaultSession) {
            super(defaultSession);
        }

        public SELF setSkipTimezoneSetup(boolean skipTimezoneSetup) {
            this.skipTimezoneSetup = skipTimezoneSetup;
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setHiveProperties(Map<String, String> hiveProperties) {
            this.hiveProperties = ImmutableMap.builder().putAll(Objects.requireNonNull(hiveProperties, "hiveProperties is null"));
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF addHiveProperty(String key, String value) {
            this.hiveProperties.put((Object)key, (Object)value);
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setInitialTables(Iterable<TpchTable<?>> initialTables) {
            this.initialTables = ImmutableList.copyOf(Objects.requireNonNull(initialTables, "initialTables is null"));
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setInitialSchemasLocationBase(String initialSchemasLocationBase) {
            this.initialSchemasLocationBase = Optional.of(initialSchemasLocationBase);
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setInitialTablesSessionMutator(Function<Session, Session> initialTablesSessionMutator) {
            this.initialTablesSessionMutator = Objects.requireNonNull(initialTablesSessionMutator, "initialTablesSessionMutator is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setMetastore(Function<DistributedQueryRunner, HiveMetastore> metastore) {
            this.metastore = Objects.requireNonNull(metastore, "metastore is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setModule(Module module) {
            this.module = Objects.requireNonNull(module, "module is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setDirectoryLister(DirectoryLister directoryLister) {
            this.directoryLister = Optional.ofNullable(directoryLister);
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setTpcdsCatalogEnabled(boolean tpcdsCatalogEnabled) {
            this.tpcdsCatalogEnabled = tpcdsCatalogEnabled;
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setTpchBucketedCatalogEnabled(boolean tpchBucketedCatalogEnabled) {
            this.tpchBucketedCatalogEnabled = tpchBucketedCatalogEnabled;
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setSecurity(String security) {
            this.security = Objects.requireNonNull(security, "security is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setCreateTpchSchemas(boolean createTpchSchemas) {
            this.createTpchSchemas = createTpchSchemas;
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setTpchColumnNaming(ColumnNaming tpchColumnNaming) {
            this.tpchColumnNaming = Objects.requireNonNull(tpchColumnNaming, "tpchColumnNaming is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public SELF setTpchDecimalTypeMapping(DecimalTypeMapping tpchDecimalTypeMapping) {
            this.tpchDecimalTypeMapping = Objects.requireNonNull(tpchDecimalTypeMapping, "tpchDecimalTypeMapping is null");
            return (SELF)((Object)((Builder)this.self()));
        }

        public DistributedQueryRunner build() throws Exception {
            HiveQueryRunner.setupLogging();
            DistributedQueryRunner queryRunner = super.build();
            try {
                queryRunner.installPlugin((Plugin)new TpchPlugin());
                ImmutableMap tpchCatalogProperties = ImmutableMap.builder().put((Object)"tpch.column-naming", (Object)this.tpchColumnNaming.name()).put((Object)"tpch.double-type-mapping", (Object)this.tpchDecimalTypeMapping.name()).buildOrThrow();
                queryRunner.createCatalog(HiveQueryRunner.TPCH_SCHEMA, HiveQueryRunner.TPCH_SCHEMA, (Map)tpchCatalogProperties);
                if (this.tpcdsCatalogEnabled) {
                    queryRunner.installPlugin((Plugin)new TpcdsPlugin());
                    queryRunner.createCatalog("tpcds", "tpcds");
                }
                HiveMetastore metastore = this.metastore.apply(queryRunner);
                queryRunner.installPlugin((Plugin)new TestingHivePlugin(Optional.of(metastore), this.module, this.directoryLister));
                HashMap<String, String> hiveProperties = new HashMap<String, String>();
                if (!this.skipTimezoneSetup) {
                    Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)TIME_ZONE, (String)"Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments");
                    hiveProperties.put("hive.rcfile.time-zone", TIME_ZONE.getID());
                    hiveProperties.put("hive.parquet.time-zone", TIME_ZONE.getID());
                }
                hiveProperties.put("hive.max-partitions-per-scan", "1000");
                hiveProperties.put("hive.max-partitions-for-eager-load", "1000");
                hiveProperties.put("hive.security", this.security);
                hiveProperties.putAll((Map<String, String>)this.hiveProperties.buildOrThrow());
                if (this.tpchBucketedCatalogEnabled) {
                    Object hiveBucketedProperties = ImmutableMap.builder().putAll(hiveProperties).put((Object)"hive.max-initial-split-size", (Object)"10kB").put((Object)"hive.max-split-size", (Object)"10kB").put((Object)"hive.storage-format", (Object)"TEXTFILE").buildOrThrow();
                    hiveBucketedProperties = new HashMap(hiveBucketedProperties);
                    hiveBucketedProperties.put("hive.compression-codec", "NONE");
                    queryRunner.createCatalog(HiveQueryRunner.HIVE_BUCKETED_CATALOG, HiveQueryRunner.HIVE_CATALOG, (Map)hiveBucketedProperties);
                }
                queryRunner.createCatalog(HiveQueryRunner.HIVE_CATALOG, HiveQueryRunner.HIVE_CATALOG, hiveProperties);
                if (this.createTpchSchemas) {
                    this.populateData(queryRunner, metastore);
                }
                return queryRunner;
            }
            catch (Exception e) {
                queryRunner.close();
                throw e;
            }
        }

        private void populateData(DistributedQueryRunner queryRunner, HiveMetastore metastore) {
            Session session;
            if (metastore.getDatabase(HiveQueryRunner.TPCH_SCHEMA).isEmpty()) {
                metastore.createDatabase(HiveQueryRunner.createDatabaseMetastoreObject(HiveQueryRunner.TPCH_SCHEMA, this.initialSchemasLocationBase));
                session = this.initialTablesSessionMutator.apply(HiveQueryRunner.createSession(Optional.empty()));
                QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)HiveQueryRunner.TPCH_SCHEMA, (String)"tiny", (Session)session, this.initialTables);
            }
            if (this.tpchBucketedCatalogEnabled && metastore.getDatabase(HiveQueryRunner.TPCH_BUCKETED_SCHEMA).isEmpty()) {
                metastore.createDatabase(HiveQueryRunner.createDatabaseMetastoreObject(HiveQueryRunner.TPCH_BUCKETED_SCHEMA, this.initialSchemasLocationBase));
                session = this.initialTablesSessionMutator.apply(HiveQueryRunner.createBucketedSession(Optional.empty()));
                HiveQueryRunner.copyTpchTablesBucketed((QueryRunner)queryRunner, HiveQueryRunner.TPCH_SCHEMA, "tiny", session, this.initialTables, this.tpchColumnNaming);
            }
        }
    }
}

