/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.GenericHiveRecordCursorProvider;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HiveFormatsConfig;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.RcFileFileWriterFactory;
import io.trino.plugin.hive.azure.HiveAzureConfig;
import io.trino.plugin.hive.azure.TrinoAzureConfigurationInitializer;
import io.trino.plugin.hive.gcs.GoogleGcsConfigurationInitializer;
import io.trino.plugin.hive.gcs.HiveGcsConfig;
import io.trino.plugin.hive.line.CsvFileWriterFactory;
import io.trino.plugin.hive.line.CsvPageSourceFactory;
import io.trino.plugin.hive.line.JsonFileWriterFactory;
import io.trino.plugin.hive.line.JsonPageSourceFactory;
import io.trino.plugin.hive.line.OpenXJsonFileWriterFactory;
import io.trino.plugin.hive.line.OpenXJsonPageSourceFactory;
import io.trino.plugin.hive.line.RegexFileWriterFactory;
import io.trino.plugin.hive.line.RegexPageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFileWriterFactory;
import io.trino.plugin.hive.line.SimpleTextFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleTextFileWriterFactory;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TrinoS3ConfigurationInitializer;
import io.trino.plugin.hive.s3select.S3SelectRecordCursorProvider;
import io.trino.plugin.hive.s3select.TrinoS3ClientFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.NamedTypeSignature;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hive.common.type.Date;

public final class HiveTestUtils {
    public static final ConnectorSession SESSION = HiveTestUtils.getHiveSession(new HiveConfig());
    public static final Optional<HostAndPort> SOCKS_PROXY = Optional.ofNullable(System.getProperty("hive.metastore.thrift.client.socks-proxy")).map(HostAndPort::fromString);
    public static final DynamicHdfsConfiguration HDFS_CONFIGURATION = new DynamicHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig().setSocksProxy((HostAndPort)SOCKS_PROXY.orElse(null)), (Set)ImmutableSet.of((Object)new TrinoS3ConfigurationInitializer(new HiveS3Config()), (Object)new GoogleGcsConfigurationInitializer(new HiveGcsConfig()), (Object)new TrinoAzureConfigurationInitializer(new HiveAzureConfig()))), (Set)ImmutableSet.of());
    public static final HdfsEnvironment HDFS_ENVIRONMENT = new HdfsEnvironment((HdfsConfiguration)HDFS_CONFIGURATION, new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
    public static final HdfsFileSystemFactory HDFS_FILE_SYSTEM_FACTORY = new HdfsFileSystemFactory(HDFS_ENVIRONMENT);
    public static final PageSorter PAGE_SORTER = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));

    private HiveTestUtils() {
    }

    public static ConnectorSession getHiveSession(HiveConfig hiveConfig) {
        return HiveTestUtils.getHiveSession(hiveConfig, new OrcReaderConfig());
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, orcReaderConfig).getSessionProperties()).build();
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, ParquetWriterConfig parquetWriterConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, parquetWriterConfig).getSessionProperties()).build();
    }

    public static TestingConnectorSession getHiveSession(HiveConfig hiveConfig, ParquetReaderConfig parquetReaderConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(HiveTestUtils.getHiveSessionProperties(hiveConfig, parquetReaderConfig).getSessionProperties()).build();
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig) {
        return HiveTestUtils.getHiveSessionProperties(hiveConfig, new OrcReaderConfig());
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, OrcReaderConfig orcReaderConfig) {
        return new HiveSessionProperties(hiveConfig, new HiveFormatsConfig(), orcReaderConfig, new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig());
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, ParquetWriterConfig parquetWriterConfig) {
        return new HiveSessionProperties(hiveConfig, new HiveFormatsConfig(), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), parquetWriterConfig);
    }

    public static HiveSessionProperties getHiveSessionProperties(HiveConfig hiveConfig, ParquetReaderConfig parquetReaderConfig) {
        return new HiveSessionProperties(hiveConfig, new HiveFormatsConfig(), new OrcReaderConfig(), new OrcWriterConfig(), parquetReaderConfig, new ParquetWriterConfig());
    }

    public static Set<HivePageSourceFactory> getDefaultHivePageSourceFactories(HdfsEnvironment hdfsEnvironment, HiveConfig hiveConfig) {
        HdfsFileSystemFactory fileSystemFactory = new HdfsFileSystemFactory(hdfsEnvironment);
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        return ImmutableSet.builder().add((Object)new CsvPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new JsonPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new OpenXJsonPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new RegexPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new SimpleTextFilePageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new SimpleSequenceFilePageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new RcFilePageSourceFactory(InternalTypeManager.TESTING_TYPE_MANAGER, hdfsEnvironment, stats, hiveConfig)).add((Object)new OrcPageSourceFactory(new OrcReaderConfig(), (TrinoFileSystemFactory)fileSystemFactory, stats, hiveConfig)).add((Object)new ParquetPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory, stats, new ParquetReaderConfig(), hiveConfig)).build();
    }

    public static Set<HiveRecordCursorProvider> getDefaultHiveRecordCursorProviders(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment) {
        return ImmutableSet.of((Object)new S3SelectRecordCursorProvider(hdfsEnvironment, new TrinoS3ClientFactory(hiveConfig)));
    }

    public static Set<HiveFileWriterFactory> getDefaultHiveFileWriterFactories(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment) {
        HdfsFileSystemFactory fileSystemFactory = new HdfsFileSystemFactory(hdfsEnvironment);
        NodeVersion nodeVersion = new NodeVersion("test_version");
        return ImmutableSet.builder().add((Object)new CsvFileWriterFactory((TrinoFileSystemFactory)fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new JsonFileWriterFactory((TrinoFileSystemFactory)fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new RegexFileWriterFactory()).add((Object)new OpenXJsonFileWriterFactory((TrinoFileSystemFactory)fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new SimpleTextFileWriterFactory((TrinoFileSystemFactory)fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).add((Object)new SimpleSequenceFileWriterFactory((TrinoFileSystemFactory)fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, nodeVersion)).add((Object)new RcFileFileWriterFactory(hdfsEnvironment, InternalTypeManager.TESTING_TYPE_MANAGER, nodeVersion, hiveConfig)).add((Object)HiveTestUtils.getDefaultOrcFileWriterFactory(hdfsEnvironment)).build();
    }

    private static OrcFileWriterFactory getDefaultOrcFileWriterFactory(HdfsEnvironment hdfsEnvironment) {
        return new OrcFileWriterFactory((TrinoFileSystemFactory)new HdfsFileSystemFactory(hdfsEnvironment), InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"), new FileFormatDataSourceStats(), new OrcWriterConfig());
    }

    public static List<Type> getTypes(List<? extends ColumnHandle> columnHandles) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (ColumnHandle columnHandle : columnHandles) {
            types.add((Object)((HiveColumnHandle)columnHandle).getType());
        }
        return types.build();
    }

    public static HiveRecordCursorProvider createGenericHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
        return new GenericHiveRecordCursorProvider(hdfsEnvironment, DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType.getTypeSignature())));
    }

    public static ArrayType arrayType(Type elementType) {
        return (ArrayType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("array", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)elementType.getTypeSignature())));
    }

    public static RowType rowType(List<NamedTypeSignature> elementTypeSignatures) {
        return (RowType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("row", (List)elementTypeSignatures.stream().map(TypeSignatureParameter::namedTypeParameter).collect(ImmutableList.toImmutableList()));
    }

    public static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    public static Int128 longDecimal(String value) {
        return Decimals.valueOf((BigDecimal)new BigDecimal(value));
    }

    public static MethodHandle distinctFromOperator(Type type) {
        return InternalTypeManager.TESTING_TYPE_MANAGER.getTypeOperators().getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NULL_FLAG, InvocationConvention.InvocationArgumentConvention.NULL_FLAG}));
    }

    public static boolean isDistinctFrom(MethodHandle handle, Block left, Block right) {
        try {
            return handle.invokeExact(left, left == null, right, right == null);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public static Object toNativeContainerValue(Type type, Object hiveValue) {
        if (hiveValue == null) {
            return null;
        }
        if (type instanceof ArrayType) {
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object subElement : (Iterable)hiveValue) {
                StructuralTestUtil.appendToBlockBuilder((Type)((Type)type.getTypeParameters().get(0)), subElement, (BlockBuilder)subBlockBuilder);
            }
            blockBuilder.closeEntry();
            return type.getObject((Block)blockBuilder, 0);
        }
        if (type instanceof RowType) {
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            int field = 0;
            for (Object subElement : (Iterable)hiveValue) {
                StructuralTestUtil.appendToBlockBuilder((Type)((Type)type.getTypeParameters().get(field)), subElement, (BlockBuilder)subBlockBuilder);
                ++field;
            }
            blockBuilder.closeEntry();
            return type.getObject((Block)blockBuilder, 0);
        }
        if (type instanceof MapType) {
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : ((Map)hiveValue).entrySet()) {
                StructuralTestUtil.appendToBlockBuilder((Type)((Type)type.getTypeParameters().get(0)), entry.getKey(), (BlockBuilder)subBlockBuilder);
                StructuralTestUtil.appendToBlockBuilder((Type)((Type)type.getTypeParameters().get(1)), entry.getValue(), (BlockBuilder)subBlockBuilder);
            }
            blockBuilder.closeEntry();
            return type.getObject((Block)blockBuilder, 0);
        }
        if (type instanceof BooleanType) {
            return hiveValue;
        }
        if (type instanceof TinyintType) {
            return (long)((Byte)hiveValue).byteValue();
        }
        if (type instanceof SmallintType) {
            return (long)((Short)hiveValue).shortValue();
        }
        if (type instanceof IntegerType) {
            return (long)((Integer)hiveValue).intValue();
        }
        if (type instanceof BigintType) {
            return hiveValue;
        }
        if (type instanceof RealType) {
            return (long)Float.floatToRawIntBits(((Float)hiveValue).floatValue());
        }
        if (type instanceof DoubleType) {
            return hiveValue;
        }
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)hiveValue.toString());
        }
        if (type instanceof VarbinaryType) {
            return Slices.wrappedBuffer((byte[])((byte[])hiveValue));
        }
        if (type instanceof UuidType) {
            return UuidType.javaUuidToTrinoUuid((UUID)HiveTestUtils.uuidFromBytes((byte[])hiveValue));
        }
        if (type instanceof DateType) {
            return (long)((Date)hiveValue).toEpochDay();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private static UUID uuidFromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }
}

