/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.BackgroundHiveSplitLoader;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartition;
import io.trino.plugin.hive.HivePartitionMetadata;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveSplitLoader;
import io.trino.plugin.hive.HiveSplitSource;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.InternalHiveSplit;
import io.trino.plugin.hive.NamenodeStats;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.fs.CachingDirectoryLister;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.ValidWriteIdList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestBackgroundHiveSplitLoader {
    private static final int BUCKET_COUNT = 2;
    private static final String SAMPLE_PATH = "hdfs://VOL1:9000/db_name/table_name/000000_0";
    private static final String SAMPLE_PATH_FILTERED = "hdfs://VOL1:9000/db_name/table_name/000000_1";
    private static final org.apache.hadoop.fs.Path RETURNED_PATH = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/000000_0");
    private static final org.apache.hadoop.fs.Path FILTERED_PATH = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/000000_1");
    private static final TupleDomain<HiveColumnHandle> RETURNED_PATH_DOMAIN = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)HiveColumnHandle.pathColumnHandle(), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)RETURNED_PATH.toString()))));
    private static final List<LocatedFileStatus> TEST_FILES = ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(RETURNED_PATH), (Object)TestBackgroundHiveSplitLoader.locatedFileStatus(FILTERED_PATH));
    private static final List<Column> PARTITION_COLUMNS = ImmutableList.of((Object)new Column("partitionColumn", HiveType.HIVE_INT, Optional.empty()));
    private static final List<HiveColumnHandle> BUCKET_COLUMN_HANDLES = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"col1", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
    private static final Optional<HiveBucketProperty> BUCKET_PROPERTY = Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"col1"), HiveBucketing.BucketingVersion.BUCKETING_V1, 2, (List)ImmutableList.of()));
    private static final Table SIMPLE_TABLE = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of());
    private static final Table PARTITIONED_TABLE = TestBackgroundHiveSplitLoader.table(PARTITION_COLUMNS, BUCKET_PROPERTY, (ImmutableMap<String, String>)ImmutableMap.of());
    private ExecutorService executor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testNoPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, (TupleDomain<HiveColumnHandle>)TupleDomain.none());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drain(hiveSplitSource).size(), (int)2);
    }

    @Test
    public void testCsv() throws Exception {
        DataSize fileSize = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of(), fileSize, 33);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"1"), fileSize, 33);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"2"), fileSize, 1);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.footer.line.count", (Object)"1"), fileSize, 1);
        this.assertSplitCount(HiveStorageFormat.CSV, (Map<String, String>)ImmutableMap.of((Object)"skip.header.line.count", (Object)"1", (Object)"skip.footer.line.count", (Object)"1"), fileSize, 1);
    }

    @Test
    public void testSplittableNotCheckedOnSmallFiles() throws Exception {
        DataSize initialSplitSize = HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION);
        Table table = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), (Map<String, String>)ImmutableMap.of(), StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)TestSplittableFailureInputFormat.class.getName(), (String)TestSplittableFailureInputFormat.class.getName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), initialSplitSize.toBytes())), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)1);
        backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), initialSplitSize.toBytes() + 1L)), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty());
        HiveSplitSource finalHiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(finalHiveSplitSource);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.drainSplits(finalHiveSplitSource)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_UNKNOWN_ERROR}).isInstanceOfSatisfying(TrinoException.class, e -> {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            Assert.assertTrue((boolean)(cause instanceof IllegalStateException));
            Assert.assertEquals((String)cause.getMessage(), (String)"isSplittable called");
        });
    }

    private void assertSplitCount(HiveStorageFormat storageFormat, Map<String, String> tableProperties, DataSize fileSize, int expectedSplitCount) throws Exception {
        Table table = TestBackgroundHiveSplitLoader.table((List<Column>)ImmutableList.of(), Optional.empty(), (Map<String, String>)ImmutableMap.copyOf(tableProperties), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)storageFormat));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), fileSize.toBytes())), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)expectedSplitCount);
    }

    @Test
    public void testPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, RETURNED_PATH_DOMAIN);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testPathFilterOneBucketMatchPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, RETURNED_PATH_DOMAIN, Optional.of(new HiveBucketing.HiveBucketFilter((Set)ImmutableSet.of((Object)0, (Object)1))), PARTITIONED_TABLE, Optional.of(new HiveBucketHandle(BUCKET_COLUMN_HANDLES, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, 2, (List)ImmutableList.of())));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testPathFilterBucketedPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, RETURNED_PATH_DOMAIN, Optional.empty(), PARTITIONED_TABLE, Optional.of(new HiveBucketHandle(HiveUtil.getRegularColumnHandles((Table)PARTITIONED_TABLE, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveTimestampPrecision)HiveTimestampPrecision.DEFAULT_PRECISION), HiveBucketing.BucketingVersion.BUCKETING_V1, 2, 2, (List)ImmutableList.of())));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertEquals((int)paths.size(), (int)1);
        Assert.assertEquals((String)paths.get(0), (String)RETURNED_PATH.toString());
    }

    @Test
    public void testEmptyFileWithNoBlocks() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatusWithNoBlocks(RETURNED_PATH)), (TupleDomain<HiveColumnHandle>)TupleDomain.none());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<HiveSplit> splits = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
        Assert.assertEquals((int)splits.size(), (int)0);
    }

    @Test
    public void testNoHangIfPartitionIsOffline() {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoaderOfflinePartitions();
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).isInstanceOf(TrinoException.class)).hasMessage("OFFLINE");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((HiveSplitSource)hiveSplitSource).isFinished()).isInstanceOf(TrinoException.class)).hasMessage("OFFLINE");
    }

    @Test(timeOut=30000L)
    public void testIncompleteDynamicFilterTimeout() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return ImmutableSet.of();
            }

            public CompletableFuture<?> isBlocked() {
                return MoreFutures.unmodifiableFuture(CompletableFuture.runAsync(() -> {
                    try {
                        TimeUnit.HOURS.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }));
            }

            public boolean isComplete() {
                return false;
            }

            public boolean isAwaitable() {
                return true;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return TupleDomain.all();
            }
        }, new Duration(1.0, TimeUnit.SECONDS));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drain(hiveSplitSource).size(), (int)2);
        Assert.assertTrue((boolean)hiveSplitSource.isFinished());
    }

    @Test
    public void testCachedDirectoryLister() throws Exception {
        CachingDirectoryLister cachingDirectoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of((Object)"test_dbname.test_table"));
        Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)0L);
        int totalCount = 100;
        CountDownLatch firstVisit = new CountDownLatch(1);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        futures.add(this.executor.submit(() -> {
            BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, (DirectoryLister)cachingDirectoryLister);
            HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
            backgroundHiveSplitLoader.start(hiveSplitSource);
            try {
                List<HiveSplit> list = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
                return list;
            }
            finally {
                firstVisit.countDown();
            }
        }));
        for (int i = 0; i < totalCount - 1; ++i) {
            futures.add(this.executor.submit(() -> {
                firstVisit.await();
                BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_FILES, (DirectoryLister)cachingDirectoryLister);
                HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
                backgroundHiveSplitLoader.start(hiveSplitSource);
                return TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
            }));
        }
        for (Future future : futures) {
            Assert.assertEquals((int)((List)future.get()).size(), (int)TEST_FILES.size());
        }
        Assert.assertEquals((long)cachingDirectoryLister.getRequestCount(), (long)totalCount);
        Assert.assertEquals((long)cachingDirectoryLister.getHitCount(), (long)(totalCount - 1));
        Assert.assertEquals((long)cachingDirectoryLister.getMissCount(), (long)1L);
    }

    @Test
    public void testGetBucketNumber() {
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234.txt"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_235847_87654_fn7s5_bucket-56789"), (Object)OptionalInt.of(56789));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"000234_0"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_99"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0.txt"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0_copy_1"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"234_99"), (Object)OptionalInt.of(234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"1234_0_copy_1"), (Object)OptionalInt.of(1234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"bucket_1234"), (Object)OptionalInt.of(1234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"bucket_01234"), (Object)OptionalInt.of(1234));
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234.txt"), (Object)OptionalInt.empty());
        Assert.assertEquals((Object)BackgroundHiveSplitLoader.getBucketNumber((String)"0234.txt"), (Object)OptionalInt.empty());
    }

    @Test
    public void testGetAttemptId() {
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000"));
        Assert.assertTrue((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_0"));
        Assert.assertTrue((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_10"));
        Assert.assertTrue((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_1000"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000__1000"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_a"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_ad"));
        Assert.assertFalse((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"base_00000_00"));
    }

    @Test(dataProvider="testPropagateExceptionDataProvider", timeOut=60000L)
    public void testPropagateException(final boolean error, int threads) {
        final AtomicBoolean iteratorUsedAfterException = new AtomicBoolean();
        TestingHdfsEnvironment hdfsEnvironment = new TestingHdfsEnvironment(TEST_FILES);
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = new BackgroundHiveSplitLoader(SIMPLE_TABLE, (Iterator)new Iterator<HivePartitionMetadata>(){
            private boolean threw;

            @Override
            public boolean hasNext() {
                iteratorUsedAfterException.compareAndSet(false, this.threw);
                return !this.threw;
            }

            @Override
            public HivePartitionMetadata next() {
                iteratorUsedAfterException.compareAndSet(false, this.threw);
                this.threw = true;
                if (error) {
                    throw new Error("loading error occurred");
                }
                throw new RuntimeException("loading error occurred");
            }
        }, TupleDomain.all(), DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), InternalTypeManager.TESTING_TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), HiveTestUtils.SESSION, (TrinoFileSystemFactory)new HdfsFileSystemFactory((HdfsEnvironment)hdfsEnvironment), (HdfsEnvironment)hdfsEnvironment, new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, threads, false, false, true, Optional.empty(), Optional.empty(), 100);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).hasMessageEndingWith("loading error occurred");
        Assertions.assertThatThrownBy(() -> ((HiveSplitSource)hiveSplitSource).isFinished()).hasMessageEndingWith("loading error occurred");
        if (threads == 1) {
            Assert.assertFalse((boolean)iteratorUsedAfterException.get());
        }
    }

    @DataProvider
    public Object[][] testPropagateExceptionDataProvider() {
        return new Object[][]{{false, 1}, {true, 1}, {false, 2}, {true, 2}, {false, 4}, {true, 4}};
    }

    @Test
    public void testMultipleSplitsPerBucket() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(new org.apache.hadoop.fs.Path(SAMPLE_PATH), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes())), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), SIMPLE_TABLE, Optional.of(new HiveBucketHandle(BUCKET_COLUMN_HANDLES, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, 2, (List)ImmutableList.of())));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assert.assertEquals((int)TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource).size(), (int)17);
    }

    @Test
    public void testSplitsGenerationWithAbortedTransactions() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true", (Object)"transactional_properties", (Object)"insert_only"));
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/delta_0000001_0000001_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000001_0000001_0000/bucket_00000"), (Object)(tablePath + "/delta_0000002_0000002_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"), (Object)(tablePath + "/delta_0000003_0000003_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000003_0000003_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file);
        }
        String validWriteIdsList = String.format("4$%s.%s:3:9223372036854775807::2", table.getDatabaseName(), table.getTableName());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.none(), Optional.empty(), table, Optional.empty(), Optional.of(new ValidWriteIdList(validWriteIdsList)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> splits = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertTrue((boolean)splits.stream().anyMatch(arg_0 -> TestBackgroundHiveSplitLoader.lambda$testSplitsGenerationWithAbortedTransactions$6((List)filePaths, arg_0)), (String)String.format("%s not found in splits %s", filePaths.get(1), splits));
        Assert.assertTrue((boolean)splits.stream().anyMatch(arg_0 -> TestBackgroundHiveSplitLoader.lambda$testSplitsGenerationWithAbortedTransactions$7((List)filePaths, arg_0)), (String)String.format("%s not found in splits %s", filePaths.get(5), splits));
        MoreFiles.deleteRecursively((Path)tablePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testFullAcidTableWithOriginalFiles() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true"));
        String originalFile = tablePath + "/000000_1";
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/delta_0000002_0000002_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file);
        }
        Files.write(Paths.get(originalFile, new String[0]), "test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> splits = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assert.assertTrue((boolean)splits.stream().anyMatch(p -> p.contains(originalFile)), (String)String.format("%s not found in splits %s", filePaths.get(0), splits));
        Assert.assertTrue((boolean)splits.stream().anyMatch(arg_0 -> TestBackgroundHiveSplitLoader.lambda$testFullAcidTableWithOriginalFiles$9((List)filePaths, arg_0)), (String)String.format("%s not found in splits %s", filePaths.get(1), splits));
    }

    @Test
    public void testVersionValidationNoOrcAcidVersionFile() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true"));
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/000000_1"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractListAssert)Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).extracting(HiveSplit::getAcidInfo).allMatch(Optional::isPresent)).extracting(Optional::get).noneMatch(AcidInfo::isOrcAcidVersionValidated);
        MoreFiles.deleteRecursively((Path)tablePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testVersionValidationOrcAcidVersionFileHasVersion2() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true"));
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/000000_1"), (Object)(tablePath + "/delta_0000002_0000002_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file, 2);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).extracting(HiveSplit::getAcidInfo).allMatch(acidInfo -> acidInfo.isEmpty() || ((AcidInfo)acidInfo.get()).isOrcAcidVersionValidated());
        MoreFiles.deleteRecursively((Path)tablePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testVersionValidationOrcAcidVersionFileHasVersion1() throws Exception {
        Path tablePath = Files.createTempDirectory("TestBackgroundHiveSplitLoader", new FileAttribute[0]);
        Table table = TestBackgroundHiveSplitLoader.table(tablePath.toString(), (List<Column>)ImmutableList.of(), Optional.empty(), (ImmutableMap<String, String>)ImmutableMap.of((Object)"transactional", (Object)"true"));
        ImmutableList filePaths = ImmutableList.of((Object)(tablePath + "/000000_1"), (Object)(tablePath + "/delta_0000002_0000002_0000/_orc_acid_version"), (Object)(tablePath + "/delta_0000002_0000002_0000/bucket_00000"));
        for (String path : filePaths) {
            File file = new File(path);
            Assert.assertTrue((file.getParentFile().exists() || file.getParentFile().mkdirs() ? 1 : 0) != 0, (String)("Failed creating directory " + file.getParentFile()));
            TestBackgroundHiveSplitLoader.createOrcAcidFile(file, 1);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(HiveTestUtils.HDFS_ENVIRONMENT, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractListAssert)Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).extracting(HiveSplit::getAcidInfo).allMatch(Optional::isPresent)).extracting(Optional::get).noneMatch(AcidInfo::isOrcAcidVersionValidated);
        MoreFiles.deleteRecursively((Path)tablePath, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testValidateFileBuckets() {
        ArrayListMultimap bucketFiles = ArrayListMultimap.create();
        bucketFiles.put((Object)1, null);
        bucketFiles.put((Object)3, null);
        bucketFiles.put((Object)4, null);
        bucketFiles.put((Object)6, null);
        bucketFiles.put((Object)9, null);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$11((ListMultimap)bucketFiles)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (1) for partition: partitionName");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$12((ListMultimap)bucketFiles)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (5) for partition: partitionName");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$13((ListMultimap)bucketFiles)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (9) for partition: partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)10, (String)"tableName", (String)"partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)20, (String)"tableName", (String)"partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)30, (String)"tableName", (String)"partitionName");
    }

    @Test
    public void testBuildManifestFileIterator() throws Exception {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(0.0, TimeUnit.MINUTES), 0L, (List)ImmutableList.of());
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
        schema.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerde());
        org.apache.hadoop.fs.Path firstFilePath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/file1");
        org.apache.hadoop.fs.Path secondFilePath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/file2");
        ImmutableList paths = ImmutableList.of((Object)firstFilePath, (Object)secondFilePath);
        List files = (List)paths.stream().map(TestBackgroundHiveSplitLoader::locatedFileStatus).collect(ImmutableList.toImmutableList());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)files, (DirectoryLister)directoryLister);
        Optional splitIterator = backgroundHiveSplitLoader.buildManifestFileIterator((InputFormat)new AvroContainerInputFormat(), "partition", schema, (List)ImmutableList.of(), TupleDomain.all(), () -> true, false, TableToPartitionMapping.empty(), new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name"), (List)paths, true);
        Assert.assertTrue((boolean)splitIterator.isPresent());
        ImmutableList splits = ImmutableList.copyOf((Iterator)((Iterator)splitIterator.get()));
        Assert.assertEquals((int)splits.size(), (int)2);
        Assert.assertEquals((String)((InternalHiveSplit)splits.get(0)).getPath(), (String)firstFilePath.toString());
        Assert.assertEquals((String)((InternalHiveSplit)splits.get(1)).getPath(), (String)secondFilePath.toString());
    }

    @Test
    public void testBuildManifestFileIteratorNestedDirectory() throws Exception {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), 1000L, (List)ImmutableList.of());
        Properties schema = new Properties();
        schema.setProperty("file.inputformat", SymlinkTextInputFormat.class.getName());
        schema.setProperty("serialization.lib", HiveStorageFormat.AVRO.getSerde());
        org.apache.hadoop.fs.Path filePath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/file1");
        org.apache.hadoop.fs.Path directoryPath = new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name/dir");
        ImmutableList paths = ImmutableList.of((Object)filePath, (Object)directoryPath);
        ImmutableList files = ImmutableList.of((Object)TestBackgroundHiveSplitLoader.locatedFileStatus(filePath), (Object)TestBackgroundHiveSplitLoader.locatedDirectoryStatus(directoryPath));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<LocatedFileStatus>)files, (DirectoryLister)directoryLister);
        Optional splitIterator = backgroundHiveSplitLoader.buildManifestFileIterator((InputFormat)new AvroContainerInputFormat(), "partition", schema, (List)ImmutableList.of(), TupleDomain.all(), () -> true, false, TableToPartitionMapping.empty(), new org.apache.hadoop.fs.Path("hdfs://VOL1:9000/db_name/table_name"), (List)paths, false);
        Assert.assertTrue((boolean)splitIterator.isEmpty());
    }

    @Test
    public void testMaxPartitions() throws Exception {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(0.0, TimeUnit.MINUTES), 0L, (List)ImmutableList.of());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<HivePartitionMetadata>)ImmutableList.of(), (List<LocatedFileStatus>)ImmutableList.of(), (DirectoryLister)directoryLister, 0);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).isEmpty();
        backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((List<HivePartitionMetadata>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.createPartitionMetadata()), TEST_FILES, (DirectoryLister)directoryLister, 1);
        hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).hasSize(TEST_FILES.size());
        int partitionLimit = 0;
        BackgroundHiveSplitLoader backgroundHiveSplitLoader2 = this.backgroundHiveSplitLoader((List<HivePartitionMetadata>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.createPartitionMetadata()), TEST_FILES, (DirectoryLister)directoryLister, partitionLimit);
        HiveSplitSource hiveSplitSource2 = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader2);
        backgroundHiveSplitLoader2.start(hiveSplitSource2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource2)).isInstanceOf(TrinoException.class)).hasMessage(String.format("Query over table '%s' can potentially read more than %s partitions", SIMPLE_TABLE.getSchemaTableName(), partitionLimit));
        partitionLimit = 3;
        ImmutableList partitions = ImmutableList.of((Object)TestBackgroundHiveSplitLoader.createPartitionMetadata(), (Object)TestBackgroundHiveSplitLoader.createPartitionMetadata(), (Object)TestBackgroundHiveSplitLoader.createPartitionMetadata());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader3 = this.backgroundHiveSplitLoader((List<HivePartitionMetadata>)partitions, TEST_FILES, (DirectoryLister)directoryLister, partitionLimit);
        HiveSplitSource hiveSplitSource3 = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader3);
        backgroundHiveSplitLoader3.start(hiveSplitSource3);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource3)).hasSize(TEST_FILES.size() * partitions.size());
        partitionLimit = 3;
        backgroundHiveSplitLoader2 = this.backgroundHiveSplitLoader((List<HivePartitionMetadata>)ImmutableList.of((Object)TestBackgroundHiveSplitLoader.createPartitionMetadata(), (Object)TestBackgroundHiveSplitLoader.createPartitionMetadata(), (Object)TestBackgroundHiveSplitLoader.createPartitionMetadata(), (Object)TestBackgroundHiveSplitLoader.createPartitionMetadata()), TEST_FILES, (DirectoryLister)directoryLister, partitionLimit);
        hiveSplitSource2 = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader2);
        backgroundHiveSplitLoader2.start(hiveSplitSource2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource2)).isInstanceOf(TrinoException.class)).hasMessage(String.format("Query over table '%s' can potentially read more than %s partitions", SIMPLE_TABLE.getSchemaTableName(), partitionLimit));
    }

    private static HivePartitionMetadata createPartitionMetadata() {
        return new HivePartitionMetadata(new HivePartition(SIMPLE_TABLE.getSchemaTableName()), Optional.empty(), TableToPartitionMapping.empty());
    }

    private static void createOrcAcidFile(File file) throws IOException {
        TestBackgroundHiveSplitLoader.createOrcAcidFile(file, 2);
    }

    private static void createOrcAcidFile(File file, int orcAcidVersion) throws IOException {
        if (file.getName().equals("_orc_acid_version")) {
            Files.write(file.toPath(), String.valueOf(orcAcidVersion).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        Files.copy(Resources.getResource((String)"fullacidNationTableWithOriginalFiles/000000_0").openStream(), file.toPath(), new CopyOption[0]);
    }

    private static List<String> drain(HiveSplitSource source) throws Exception {
        return (List)TestBackgroundHiveSplitLoader.drainSplits(source).stream().map(HiveSplit::getPath).collect(ImmutableList.toImmutableList());
    }

    private static List<HiveSplit> drainSplits(HiveSplitSource source) throws Exception {
        ImmutableList.Builder splits = ImmutableList.builder();
        while (!source.isFinished()) {
            ConnectorSplitSource.ConnectorSplitBatch batch;
            try {
                batch = (ConnectorSplitSource.ConnectorSplitBatch)source.getNextBatch(100).get();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw e;
            }
            batch.getSplits().stream().map(HiveSplit.class::cast).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
        }
        return splits.build();
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(DynamicFilter dynamicFilter, Duration dynamicFilteringProbeBlockingTimeoutMillis) {
        return this.backgroundHiveSplitLoader(new TestingHdfsEnvironment(TEST_FILES), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), dynamicFilter, dynamicFilteringProbeBlockingTimeoutMillis, Optional.empty(), SIMPLE_TABLE, Optional.empty(), Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, TupleDomain<HiveColumnHandle> tupleDomain) {
        return this.backgroundHiveSplitLoader(files, tupleDomain, Optional.empty(), SIMPLE_TABLE, Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle) {
        return this.backgroundHiveSplitLoader(files, compactEffectivePredicate, hiveBucketFilter, table, bucketHandle, Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, Optional<ValidWriteIdList> validWriteIds) {
        return this.backgroundHiveSplitLoader(new TestingHdfsEnvironment(files), compactEffectivePredicate, hiveBucketFilter, table, bucketHandle, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(HdfsEnvironment hdfsEnvironment, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, Optional<ValidWriteIdList> validWriteIds) {
        return this.backgroundHiveSplitLoader(hdfsEnvironment, compactEffectivePredicate, DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), hiveBucketFilter, table, bucketHandle, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(HdfsEnvironment hdfsEnvironment, TupleDomain<HiveColumnHandle> compactEffectivePredicate, DynamicFilter dynamicFilter, Duration dynamicFilteringProbeBlockingTimeout, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveBucketHandle> bucketHandle, Optional<ValidWriteIdList> validWriteIds) {
        ImmutableList hivePartitionMetadatas = ImmutableList.of((Object)new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty()));
        return new BackgroundHiveSplitLoader(table, hivePartitionMetadatas.iterator(), compactEffectivePredicate, dynamicFilter, dynamicFilteringProbeBlockingTimeout, InternalTypeManager.TESTING_TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(bucketHandle, hiveBucketFilter), HiveTestUtils.SESSION, (TrinoFileSystemFactory)new HdfsFileSystemFactory(hdfsEnvironment), hdfsEnvironment, new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, 2, false, false, true, validWriteIds, Optional.empty(), 100);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<LocatedFileStatus> files, DirectoryLister directoryLister) {
        ImmutableList partitions = ImmutableList.of((Object)new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty()));
        return this.backgroundHiveSplitLoader((List<HivePartitionMetadata>)partitions, files, directoryLister, 100);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<HivePartitionMetadata> partitions, List<LocatedFileStatus> files, DirectoryLister directoryLister, int maxPartitions) {
        ConnectorSession connectorSession = HiveTestUtils.getHiveSession(new HiveConfig().setMaxSplitSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        TestingHdfsEnvironment hdfsEnvironment = new TestingHdfsEnvironment(files);
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, partitions.iterator(), TupleDomain.none(), DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), connectorSession, (TrinoFileSystemFactory)new HdfsFileSystemFactory((HdfsEnvironment)hdfsEnvironment), (HdfsEnvironment)hdfsEnvironment, new NamenodeStats(), directoryLister, (Executor)this.executor, 2, false, false, true, Optional.empty(), Optional.empty(), maxPartitions);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoaderOfflinePartitions() {
        ConnectorSession connectorSession = HiveTestUtils.getHiveSession(new HiveConfig().setMaxSplitSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        TestingHdfsEnvironment hdfsEnvironment = new TestingHdfsEnvironment(TEST_FILES);
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, TestBackgroundHiveSplitLoader.createPartitionMetadataWithOfflinePartitions(), TupleDomain.all(), DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), InternalTypeManager.TESTING_TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), connectorSession, (TrinoFileSystemFactory)new HdfsFileSystemFactory((HdfsEnvironment)hdfsEnvironment), (HdfsEnvironment)hdfsEnvironment, new NamenodeStats(), (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, 2, false, false, true, Optional.empty(), Optional.empty(), 100);
    }

    private static Iterator<HivePartitionMetadata> createPartitionMetadataWithOfflinePartitions() throws RuntimeException {
        return new AbstractIterator<HivePartitionMetadata>(){
            private int position = -1;

            protected HivePartitionMetadata computeNext() {
                ++this.position;
                switch (this.position) {
                    case 0: {
                        return new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), TableToPartitionMapping.empty());
                    }
                    case 1: {
                        throw new RuntimeException("OFFLINE");
                    }
                }
                return (HivePartitionMetadata)this.endOfData();
            }
        };
    }

    private HiveSplitSource hiveSplitSource(HiveSplitLoader hiveSplitLoader) {
        return HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)SIMPLE_TABLE.getDatabaseName(), (String)SIMPLE_TABLE.getTableName(), (int)1, (int)1, (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)hiveSplitLoader, (Executor)this.executor, (CounterStat)new CounterStat(), (boolean)false);
    }

    private static Table table(List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, ImmutableMap<String, String> tableParameters) {
        return TestBackgroundHiveSplitLoader.table(partitionColumns, bucketProperty, tableParameters, StorageFormat.create((String)"com.facebook.hive.orc.OrcSerde", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat"));
    }

    private static Table table(String location, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, ImmutableMap<String, String> tableParameters) {
        return TestBackgroundHiveSplitLoader.table(location, partitionColumns, bucketProperty, tableParameters, StorageFormat.create((String)"com.facebook.hive.orc.OrcSerde", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.RCFileInputFormat"));
    }

    private static Table table(List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Map<String, String> tableParameters, StorageFormat storageFormat) {
        return TestBackgroundHiveSplitLoader.table("hdfs://VOL1:9000/db_name/table_name", partitionColumns, bucketProperty, tableParameters, storageFormat);
    }

    private static Table table(String location, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Map<String, String> tableParameters, StorageFormat storageFormat) {
        Table.Builder tableBuilder = Table.builder();
        tableBuilder.getStorageBuilder().setStorageFormat(storageFormat).setLocation(location).setSkewed(false).setBucketProperty(bucketProperty);
        return tableBuilder.setDatabaseName("test_dbname").setOwner(Optional.of("testOwner")).setTableName("test_table").setTableType(TableType.MANAGED_TABLE.toString()).setDataColumns((List)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_STRING, Optional.empty()))).setParameters(tableParameters).setPartitionColumns(partitionColumns).build();
    }

    private static LocatedFileStatus locatedFileStatus(org.apache.hadoop.fs.Path path) {
        return TestBackgroundHiveSplitLoader.locatedFileStatus(path, 10L);
    }

    private static LocatedFileStatus locatedFileStatus(org.apache.hadoop.fs.Path path, long fileLength) {
        return new LocatedFileStatus(fileLength, false, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[]{new BlockLocation(new String[1], new String[]{"localhost"}, 0L, fileLength)});
    }

    private static LocatedFileStatus locatedFileStatusWithNoBlocks(org.apache.hadoop.fs.Path path) {
        return new LocatedFileStatus(0L, false, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[0]);
    }

    private static LocatedFileStatus locatedDirectoryStatus(org.apache.hadoop.fs.Path path) {
        return new LocatedFileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, null, path, new BlockLocation[0]);
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$13(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)9, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$12(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)5, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$11(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)1, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ boolean lambda$testFullAcidTableWithOriginalFiles$9(List filePaths, String p) {
        return p.contains((CharSequence)filePaths.get(1));
    }

    private static /* synthetic */ boolean lambda$testSplitsGenerationWithAbortedTransactions$7(List filePaths, String p) {
        return p.contains((CharSequence)filePaths.get(5));
    }

    private static /* synthetic */ boolean lambda$testSplitsGenerationWithAbortedTransactions$6(List filePaths, String p) {
        return p.contains((CharSequence)filePaths.get(1));
    }

    public static final class TestSplittableFailureInputFormat
    extends FileInputFormat<Void, Void> {
        protected boolean isSplitable(FileSystem fs, org.apache.hadoop.fs.Path filename) {
            throw new IllegalStateException("isSplittable called");
        }

        public RecordReader<Void, Void> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class TestingHdfsEnvironment
    extends HdfsEnvironment {
        private final List<LocatedFileStatus> files;

        public TestingHdfsEnvironment(List<LocatedFileStatus> files) {
            super((HdfsConfiguration)new DynamicHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig()), (Set)ImmutableSet.of()), new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
            this.files = ImmutableList.copyOf(files);
        }

        public FileSystem getFileSystem(ConnectorIdentity identity, org.apache.hadoop.fs.Path path, Configuration configuration) {
            return new TestingHdfsFileSystem(this.files);
        }
    }

    private static class TestingHdfsFileSystem
    extends FileSystem {
        private final List<LocatedFileStatus> files;

        public TestingHdfsFileSystem(List<LocatedFileStatus> files) {
            this.files = ImmutableList.copyOf(files);
        }

        public boolean delete(org.apache.hadoop.fs.Path f, boolean recursive) {
            throw new UnsupportedOperationException();
        }

        public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDirectory(org.apache.hadoop.fs.Path dir) {
            throw new UnsupportedOperationException();
        }

        public FileStatus[] listStatus(org.apache.hadoop.fs.Path f) {
            throw new UnsupportedOperationException();
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(org.apache.hadoop.fs.Path f) {
            return new RemoteIterator<LocatedFileStatus>(){
                private final Iterator<LocatedFileStatus> iterator;
                {
                    this.iterator = files.iterator();
                }

                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                public LocatedFileStatus next() {
                    return this.iterator.next();
                }
            };
        }

        public FSDataOutputStream create(org.apache.hadoop.fs.Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public boolean mkdirs(org.apache.hadoop.fs.Path f, FsPermission permission) {
            throw new UnsupportedOperationException();
        }

        public FSDataOutputStream append(org.apache.hadoop.fs.Path f, int bufferSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public FSDataInputStream open(org.apache.hadoop.fs.Path f, int bufferSize) {
            throw new UnsupportedOperationException();
        }

        public FileStatus getFileStatus(org.apache.hadoop.fs.Path f) {
            throw new UnsupportedOperationException();
        }

        public org.apache.hadoop.fs.Path getWorkingDirectory() {
            throw new UnsupportedOperationException();
        }

        public URI getUri() {
            throw new UnsupportedOperationException();
        }
    }
}

