/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.airlift.units.Duration;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveAnalyzeCorruptStatistics
extends AbstractTestQueryFramework {
    private HiveMinioDataLake hiveMinioDataLake;

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass(new HiveMinioDataLake("test-analyze"));
        this.hiveMinioDataLake.start();
        return S3HiveQueryRunner.builder(this.hiveMinioDataLake).setThriftMetastoreTimeout(new Duration(5.0, TimeUnit.MINUTES)).build();
    }

    @Test
    public void testAnalyzeCorruptColumnStatisticsOnEmptyTable() {
        String tableName = "test_analyze_corrupt_column_statistics_" + TestingNames.randomNameSuffix();
        this.prepareBrokenColumnStatisticsTable(tableName);
        this.assertQuerySucceeds("SHOW STATS FOR " + tableName);
        Assertions.assertThatThrownBy(() -> this.query("ANALYZE " + tableName)).hasMessage("%s: Socket is closed by peer.", new Object[]{this.hiveMinioDataLake.getHiveHadoop().getHiveMetastoreEndpoint()}).hasStackTraceContaining("ThriftHiveMetastore.setTableColumnStatistics");
        Assertions.assertThatThrownBy(() -> this.query("CALL system.drop_stats('tpch', '" + tableName + "')")).hasMessageContaining("The query returned more than one instance BUT either unique is set to true or only aggregates are to be returned, so should have returned one result maximum");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void prepareBrokenColumnStatisticsTable(String tableName) {
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 col", 1L);
        Assert.assertEquals((String)this.onMetastore("SELECT COUNT(1) FROM TAB_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'"), (String)"1");
        this.onMetastore("INSERT INTO TAB_COL_STATS  SELECT cs_id + 1, db_name, table_name, column_name, column_type, tbl_id, long_low_value, long_high_value, double_high_value, double_low_value, big_decimal_low_value, big_decimal_high_value, num_nulls, num_distincts, avg_col_len, max_col_len, num_trues, num_falses, last_analyzed FROM TAB_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'");
        Assert.assertEquals((String)this.onMetastore("SELECT COUNT(1) FROM TAB_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'"), (String)"2");
    }

    private String onMetastore(@Language(value="SQL") String sql) {
        return this.hiveMinioDataLake.getHiveHadoop().runOnMetastore(sql);
    }
}

