/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.base.TypeDeserializer;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveColumnHandle {
    @Test
    public void testHiddenColumn() {
        HiveColumnHandle hiddenColumn = HiveColumnHandle.pathColumnHandle();
        this.testRoundTrip(hiddenColumn);
    }

    @Test
    public void testRegularColumn() {
        HiveColumnHandle expectedPartitionColumn = HiveColumnHandle.createBaseColumn((String)"name", (int)88, (HiveType)HiveType.HIVE_FLOAT, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        this.testRoundTrip(expectedPartitionColumn);
    }

    @Test
    public void testPartitionKeyColumn() {
        HiveColumnHandle expectedRegularColumn = HiveColumnHandle.createBaseColumn((String)"name", (int)88, (HiveType)HiveType.HIVE_FLOAT, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.testRoundTrip(expectedRegularColumn);
    }

    @Test
    public void testProjectedColumn() {
        RowType baseType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)VarcharType.VARCHAR), RowType.field((String)"b", (Type)BigintType.BIGINT)));
        HiveType baseHiveType = HiveType.toHiveType((Type)baseType);
        HiveColumnProjectionInfo columnProjectionInfo = new HiveColumnProjectionInfo((List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)"b"), HiveType.HIVE_LONG, (Type)BigintType.BIGINT);
        HiveColumnHandle projectedColumn = new HiveColumnHandle("struct_col", 88, baseHiveType, (Type)baseType, Optional.of(columnProjectionInfo), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        this.testRoundTrip(projectedColumn);
    }

    private void testRoundTrip(HiveColumnHandle expected) {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER)));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(HiveColumnHandle.class);
        String json = codec.toJson((Object)expected);
        HiveColumnHandle actual = (HiveColumnHandle)codec.fromJson(json);
        Assert.assertEquals((String)actual.getBaseColumnName(), (String)expected.getBaseColumnName());
        Assert.assertEquals((int)actual.getBaseHiveColumnIndex(), (int)expected.getBaseHiveColumnIndex());
        Assert.assertEquals((Object)actual.getBaseType(), (Object)expected.getBaseType());
        Assert.assertEquals((Object)actual.getBaseHiveType(), (Object)expected.getBaseHiveType());
        Assert.assertEquals((String)actual.getName(), (String)expected.getName());
        Assert.assertEquals((Object)actual.getType(), (Object)expected.getType());
        Assert.assertEquals((Object)actual.getHiveType(), (Object)expected.getHiveType());
        Assert.assertEquals((Object)actual.getHiveColumnProjectionInfo(), (Object)expected.getHiveColumnProjectionInfo());
        Assert.assertEquals((boolean)actual.isPartitionKey(), (boolean)expected.isPartitionKey());
    }
}

