/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.BaseConnectorSmokeTest;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingConnectorBehavior;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveConnectorSmokeTest
extends BaseConnectorSmokeTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        switch (connectorBehavior) {
            case SUPPORTS_TOPN_PUSHDOWN: {
                return false;
            }
            case SUPPORTS_CREATE_VIEW: {
                return true;
            }
            case SUPPORTS_DELETE: 
            case SUPPORTS_UPDATE: 
            case SUPPORTS_MERGE: {
                return true;
            }
            case SUPPORTS_MULTI_STATEMENT_WRITES: {
                return true;
            }
        }
        return super.hasBehavior(connectorBehavior);
    }

    public void testRowLevelDelete() {
        Assertions.assertThatThrownBy(() -> super.testRowLevelDelete()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    public void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    public void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessage("Modifying Hive table rows is only supported for transactional tables");
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE region"))).isEqualTo("CREATE TABLE hive.tpch.region (\n   regionkey bigint,\n   name varchar(25),\n   comment varchar(152)\n)\nWITH (\n   format = 'ORC'\n)");
    }
}

