/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableMap;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.exchange.filesystem.FileSystemExchangePlugin;
import io.trino.plugin.exchange.filesystem.containers.MinioStorage;
import io.trino.plugin.hive.BaseHiveFailureRecoveryTest;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.spi.Plugin;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import org.testng.annotations.AfterClass;

public class TestHiveQueryFailureRecoveryTest
extends BaseHiveFailureRecoveryTest {
    private HiveMinioDataLake hiveMinioDataLake;
    private MinioStorage minioStorage;

    public TestHiveQueryFailureRecoveryTest() {
        super(RetryPolicy.QUERY);
    }

    protected QueryRunner createQueryRunner(List<TpchTable<?>> requiredTpchTables, Map<String, String> configProperties, Map<String, String> coordinatorProperties) throws Exception {
        String bucketName = "test-hive-insert-overwrite-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake = new HiveMinioDataLake(bucketName);
        this.hiveMinioDataLake.start();
        this.minioStorage = new MinioStorage("test-exchange-spooling-" + TestingNames.randomNameSuffix());
        this.minioStorage.start();
        return ((S3HiveQueryRunner.Builder)((Object)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)((S3HiveQueryRunner.Builder)((Object)S3HiveQueryRunner.builder(this.hiveMinioDataLake).setInitialTables(requiredTpchTables))).setExtraProperties(configProperties)).setCoordinatorProperties(coordinatorProperties)).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemExchangePlugin());
            runner.loadExchangeManager("filesystem", MinioStorage.getExchangeManagerProperties((MinioStorage)this.minioStorage));
        })).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.s3.streaming.enabled", (Object)"false")))).build();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.hiveMinioDataLake != null) {
            this.hiveMinioDataLake.close();
            this.hiveMinioDataLake = null;
        }
        if (this.minioStorage != null) {
            this.minioStorage.close();
            this.minioStorage = null;
        }
    }
}

