/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.base.TypeDeserializer;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import javax.inject.Provider;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSplit {
    @Test
    public void testJsonRoundTrip() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TestingTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(HiveSplit.class);
        Properties schema = new Properties();
        schema.setProperty("foo", "bar");
        schema.setProperty("bar", "baz");
        ImmutableList partitionKeys = ImmutableList.of((Object)new HivePartitionKey("a", "apple"), (Object)new HivePartitionKey("b", "42"));
        ImmutableList addresses = ImmutableList.of((Object)HostAddress.fromParts((String)"127.0.0.1", (int)44), (Object)HostAddress.fromParts((String)"127.0.0.1", (int)45));
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)new Path("file:///data/fullacid"));
        acidInfoBuilder.addDeleteDelta(new Path("file:///data/fullacid/delete_delta_0000004_0000004_0000"));
        acidInfoBuilder.addDeleteDelta(new Path("file:///data/fullacid/delete_delta_0000007_0000007_0000"));
        AcidInfo acidInfo = (AcidInfo)acidInfoBuilder.build().get();
        HiveSplit expected = new HiveSplit("db", "table", "partitionId", "path", 42L, 87L, 88L, Instant.now().toEpochMilli(), schema, (List)partitionKeys, (List)addresses, OptionalInt.empty(), OptionalInt.empty(), 0, true, TableToPartitionMapping.mapColumnsByIndex((Map)ImmutableMap.of((Object)1, (Object)new HiveTypeName("string"))), Optional.of(new HiveSplit.BucketConversion(HiveBucketing.BucketingVersion.BUCKETING_V1, 32, 16, (List)ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"col", (int)5, (HiveType)HiveType.HIVE_LONG, (Type)BigintType.BIGINT, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.of("comment"))))), Optional.empty(), false, Optional.of(acidInfo), 555534L, SplitWeight.fromProportion((double)2.0));
        String json = codec.toJson((Object)expected);
        HiveSplit actual = (HiveSplit)codec.fromJson(json);
        Assert.assertEquals((String)actual.getDatabase(), (String)expected.getDatabase());
        Assert.assertEquals((String)actual.getTable(), (String)expected.getTable());
        Assert.assertEquals((String)actual.getPartitionName(), (String)expected.getPartitionName());
        Assert.assertEquals((String)actual.getPath(), (String)expected.getPath());
        Assert.assertEquals((long)actual.getStart(), (long)expected.getStart());
        Assert.assertEquals((long)actual.getLength(), (long)expected.getLength());
        Assert.assertEquals((long)actual.getEstimatedFileSize(), (long)expected.getEstimatedFileSize());
        Assert.assertEquals((Map)actual.getSchema(), (Map)expected.getSchema());
        Assert.assertEquals((Collection)actual.getPartitionKeys(), (Collection)expected.getPartitionKeys());
        Assert.assertEquals((Collection)actual.getAddresses(), (Collection)expected.getAddresses());
        Assert.assertEquals((Map)actual.getTableToPartitionMapping().getPartitionColumnCoercions(), (Map)expected.getTableToPartitionMapping().getPartitionColumnCoercions());
        Assert.assertEquals((Object)actual.getTableToPartitionMapping().getTableToPartitionColumns(), (Object)expected.getTableToPartitionMapping().getTableToPartitionColumns());
        Assert.assertEquals((Object)actual.getBucketConversion(), (Object)expected.getBucketConversion());
        Assert.assertEquals((boolean)actual.isForceLocalScheduling(), (boolean)expected.isForceLocalScheduling());
        Assert.assertEquals((boolean)actual.isS3SelectPushdownEnabled(), (boolean)expected.isS3SelectPushdownEnabled());
        Assert.assertEquals(actual.getAcidInfo().get(), expected.getAcidInfo().get());
        Assert.assertEquals((long)actual.getSplitNumber(), (long)expected.getSplitNumber());
        Assert.assertEquals((Object)actual.getSplitWeight(), (Object)expected.getSplitWeight());
    }
}

