/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestHiveSystemSecurity
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.security", (Object)"system")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of()))).build();
    }

    @Test
    public void testDefinerView() {
        this.assertUpdate("CREATE VIEW system_security_definer_view AS SELECT 42 as n");
        this.assertQueryFails("SELECT * from system_security_definer_view", "Catalog does not support run-as DEFINER views: hive.tpch.system_security_definer_view");
        this.assertUpdate("DROP VIEW system_security_definer_view");
    }

    @Test
    public void testInvokerView() {
        this.assertUpdate("CREATE VIEW system_security_invoker_view SECURITY INVOKER AS SELECT 42 as n");
        this.assertQuery("SELECT * from system_security_invoker_view", "SELECT 42 as n");
        this.assertQueryFails("ALTER VIEW system_security_invoker_view SET AUTHORIZATION user", "Catalog does not support permission management: hive");
        this.assertQueryFails("ALTER VIEW system_security_invoker_view SET AUTHORIZATION ROLE PUBLIC", ".*Role 'public' does not exist");
        this.assertUpdate("DROP VIEW system_security_invoker_view");
    }

    @Test
    public void testCreateSchema() {
        this.assertUpdate("CREATE SCHEMA system_security_schema");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA system_security_schema"))).doesNotContain(new CharSequence[]{"AUTHORIZATION"});
        this.assertQueryFails("ALTER SCHEMA system_security_schema SET AUTHORIZATION user", "Catalog does not support permission management: hive");
        this.assertQueryFails("ALTER SCHEMA system_security_schema SET AUTHORIZATION ROLE PUBLIC", ".*Role 'public' does not exist");
        this.assertUpdate("DROP SCHEMA system_security_schema");
    }

    @Test
    public void testTableSchema() {
        this.assertUpdate("CREATE table system_security_table (n bigint)");
        this.assertQueryFails("ALTER TABLE system_security_table SET AUTHORIZATION user", "Catalog does not support permission management: hive");
        this.assertQueryFails("ALTER TABLE system_security_table SET AUTHORIZATION ROLE PUBLIC", ".*Role 'public' does not exist");
        this.assertUpdate("DROP TABLE system_security_table");
    }
}

