/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveWriterFactory;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriterFactory {
    @Test
    public void testComputeBucketedFileName() {
        String name = HiveWriterFactory.computeNonTransactionalBucketedFilename((String)"20180102_030405_00641_x1y2z", (int)1234);
        Assertions.assertThat((String)name).matches((CharSequence)"001234_0_.*_20180102_030405_00641_x1y2z");
        Assert.assertEquals((int)Utilities.getBucketIdFromFile((String)name), (int)1234);
        name = HiveWriterFactory.computeTransactionalBucketedFilename((int)1234);
        Assert.assertEquals((String)name, (String)"001234_0");
        Assert.assertEquals((int)Utilities.getBucketIdFromFile((String)name), (int)1234);
    }

    @Test
    public void testSetsSchemeToFile() {
        String pathWithoutScheme = "/simple/file/path";
        String result = HiveWriterFactory.setSchemeToFileIfAbsent((String)pathWithoutScheme);
        Assertions.assertThat((String)result).isEqualTo("file:////simple/file/path");
        URI resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/simple/file/path");
        String pathWithScheme = "s3://simple/file/path";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((String)pathWithScheme);
        Assertions.assertThat((String)result).isEqualTo(pathWithScheme);
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("s3");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/file/path");
        String pathWithEmptySpaces = "/simple/file 1/path";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((String)pathWithEmptySpaces);
        Assertions.assertThat((String)result).isEqualTo("file:////simple/file 1/path");
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/simple/file 1/path");
        String pathWithEmptySpacesAndScheme = "s3://simple/file 1/path";
        result = HiveWriterFactory.setSchemeToFileIfAbsent((String)pathWithEmptySpacesAndScheme);
        Assertions.assertThat((String)result).isEqualTo(pathWithEmptySpacesAndScheme);
        resultUri = new Path(result).toUri();
        Assertions.assertThat((String)resultUri.getScheme()).isEqualTo("s3");
        Assertions.assertThat((String)resultUri.getPath()).isEqualTo("/file 1/path");
    }
}

