/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.TempFile;
import io.trino.metadata.TableHandle;
import io.trino.plugin.hive.GenericHiveRecordCursorProvider;
import io.trino.plugin.hive.HiveBucketHandle;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveFormatsConfig;
import io.trino.plugin.hive.HivePageSource;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingHandles;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestNodeLocalDynamicSplitPruning {
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";
    private static final Column BUCKET_COLUMN = new Column("l_orderkey", HiveType.HIVE_INT, Optional.empty());
    private static final Column PARTITION_COLUMN = new Column("l_partkey", HiveType.HIVE_INT, Optional.empty());
    private static final HiveColumnHandle BUCKET_HIVE_COLUMN_HANDLE = new HiveColumnHandle(BUCKET_COLUMN.getName(), 0, BUCKET_COLUMN.getType(), BUCKET_COLUMN.getType().getType(InternalTypeManager.TESTING_TYPE_MANAGER), Optional.empty(), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    private static final HiveColumnHandle PARTITION_HIVE_COLUMN_HANDLE = new HiveColumnHandle(PARTITION_COLUMN.getName(), 0, PARTITION_COLUMN.getType(), PARTITION_COLUMN.getType().getType(InternalTypeManager.TESTING_TYPE_MANAGER), Optional.empty(), HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());

    @Test
    public void testDynamicBucketPruning() throws IOException {
        HiveConfig config = new HiveConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile tempFile = new TempFile();){
            ConnectorPageSource emptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, tempFile.file(), TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getTupleDomainForBucketSplitPruning()));
            Assert.assertEquals(emptyPageSource.getClass(), EmptyPageSource.class);
            ConnectorPageSource nonEmptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, tempFile.file(), TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getNonSelectiveBucketTupleDomain()));
            Assert.assertEquals(nonEmptyPageSource.getClass(), HivePageSource.class);
        }
    }

    @Test
    public void testDynamicPartitionPruning() throws IOException {
        HiveConfig config = new HiveConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile tempFile = new TempFile();){
            ConnectorPageSource emptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, tempFile.file(), TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getTupleDomainForPartitionSplitPruning()));
            Assert.assertEquals(emptyPageSource.getClass(), EmptyPageSource.class);
            ConnectorPageSource nonEmptyPageSource = TestNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, config, tempFile.file(), TestNodeLocalDynamicSplitPruning.getDynamicFilter(TestNodeLocalDynamicSplitPruning.getNonSelectivePartitionTupleDomain()));
            Assert.assertEquals(nonEmptyPageSource.getClass(), HivePageSource.class);
        }
    }

    private static ConnectorPageSource createTestingPageSource(HiveTransactionHandle transaction, HiveConfig hiveConfig, File outputFile, DynamicFilter dynamicFilter) {
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", hiveConfig.getHiveStorageFormat().getInputFormat());
        splitProperties.setProperty("serialization.lib", hiveConfig.getHiveStorageFormat().getSerde());
        HiveSplit split = new HiveSplit("test", "test", "", "file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), outputFile.lastModified(), splitProperties, (List)ImmutableList.of((Object)new HivePartitionKey(PARTITION_COLUMN.getName(), "42")), (List)ImmutableList.of(), OptionalInt.of(1), OptionalInt.of(1), 0, false, TableToPartitionMapping.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), 0L, SplitWeight.standard());
        TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new HiveTableHandle("test", "test", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), Optional.of(new HiveBucketHandle((List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE), HiveBucketing.BucketingVersion.BUCKETING_V1, 20, 20, (List)ImmutableList.of()))), (ConnectorTransactionHandle)transaction);
        HivePageSourceProvider provider = new HivePageSourceProvider(InternalTypeManager.TESTING_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, hiveConfig, HiveTestUtils.getDefaultHivePageSourceFactories(HiveTestUtils.HDFS_ENVIRONMENT, hiveConfig), HiveTestUtils.getDefaultHiveRecordCursorProviders(hiveConfig, HiveTestUtils.HDFS_ENVIRONMENT), new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT, hiveConfig));
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestNodeLocalDynamicSplitPruning.getSession(hiveConfig), (ConnectorSplit)split, tableHandle.getConnectorHandle(), (List)ImmutableList.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)PARTITION_HIVE_COLUMN_HANDLE), dynamicFilter);
    }

    private static TupleDomain<ColumnHandle> getTupleDomainForBucketSplitPruning() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L)));
    }

    private static TupleDomain<ColumnHandle> getNonSelectiveBucketTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)BUCKET_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    private static TupleDomain<ColumnHandle> getTupleDomainForPartitionSplitPruning() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)PARTITION_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
    }

    private static TupleDomain<ColumnHandle> getNonSelectivePartitionTupleDomain() {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)PARTITION_HIVE_COLUMN_HANDLE, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)42L)));
    }

    private static TestingConnectorSession getSession(HiveConfig config) {
        return TestingConnectorSession.builder().setPropertyMetadata(new HiveSessionProperties(config, new HiveFormatsConfig(), new OrcReaderConfig(), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig()).getSessionProperties()).build();
    }

    private static DynamicFilter getDynamicFilter(final TupleDomain<ColumnHandle> tupleDomain) {
        return new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return tupleDomain.getDomains().map(Map::keySet).orElseGet(ImmutableSet::of);
            }

            public CompletableFuture<?> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public boolean isComplete() {
                return true;
            }

            public boolean isAwaitable() {
                return false;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return tupleDomain;
            }
        };
    }
}

