/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.stats.Distribution;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.hive.orc.MemoryManager;
import io.trino.hive.orc.NullMemoryManager;
import io.trino.hive.orc.impl.WriterImpl;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.TableScanOperator;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveFormatsConfig;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import io.trino.testing.TestingSplit;
import io.trino.testing.TestingTaskContext;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOrcPageSourceMemoryTracking {
    private static final String ORC_RECORD_WRITER = OrcOutputFormat.class.getName() + "$OrcRecordWriter";
    private static final Constructor<? extends FileSinkOperator.RecordWriter> WRITER_CONSTRUCTOR = TestOrcPageSourceMemoryTracking.getOrcWriterConstructor();
    private static final Configuration CONFIGURATION = ConfigurationInstantiator.newEmptyConfiguration();
    private static final int NUM_ROWS = 50000;
    private static final int STRIPE_ROWS = 20000;
    private static final FunctionManager functionManager = FunctionManager.createTestingFunctionManager();
    private static final ExpressionCompiler EXPRESSION_COMPILER = new ExpressionCompiler(functionManager, new PageFunctionCompiler(functionManager, 0));
    private static final ConnectorSession UNCACHED_SESSION = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setTinyStripeThreshold(DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.BYTE)));
    private static final ConnectorSession CACHED_SESSION = HiveTestUtils.SESSION;
    private final Random random = new Random();
    private final List<TestColumn> testColumns = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> "", true)).add((Object)new TestColumn("p_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> Long.toHexString(this.random.nextLong()), false)).build();
    private File tempFile;
    private TestPreparer testPreparer;

    @DataProvider(name="rowCount")
    public static Object[][] rowCount() {
        return new Object[][]{{50000}, {10000}, {5000}};
    }

    @BeforeClass
    public void setUp() throws Exception {
        this.tempFile = File.createTempFile("trino_test_orc_page_source_memory_tracking", "orc");
        this.tempFile.delete();
        this.testPreparer = new TestPreparer(this.tempFile.getAbsolutePath());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tempFile.delete();
    }

    @Test
    public void testPageSourceUncached() throws Exception {
        this.testPageSource(false);
    }

    @Test
    public void testPageSourceCached() throws Exception {
        this.testPageSource(true);
    }

    private void testPageSource(boolean useCache) throws Exception {
        Block block;
        int totalRows;
        Page page;
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        ConnectorPageSource pageSource = this.testPreparer.newPageSource(stats, useCache ? CACHED_SESSION : UNCACHED_SESSION);
        if (useCache) {
            Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 200L));
        } else {
            Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)0L);
        }
        long memoryUsage = -1L;
        for (totalRows = 0; totalRows < 20000; totalRows += page.getPositionCount()) {
            Assert.assertFalse((boolean)pageSource.isFinished());
            page = pageSource.getNextPage();
            Assert.assertNotNull((Object)page);
            block = page.getBlock(1);
            if (memoryUsage == -1L) {
                if (useCache) {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 2000L));
                } else {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1000L));
                }
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                memoryUsage = pageSource.getMemoryUsage();
                if (useCache) {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 270000L), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 280000L));
                    continue;
                }
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                continue;
            }
            Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)memoryUsage);
            VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
            Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)memoryUsage);
        }
        memoryUsage = -1L;
        while (totalRows < 40000) {
            Assert.assertFalse((boolean)pageSource.isFinished());
            page = pageSource.getNextPage();
            Assert.assertNotNull((Object)page);
            block = page.getBlock(1);
            if (memoryUsage == -1L) {
                if (useCache) {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 2000L));
                } else {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1000L));
                }
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                memoryUsage = pageSource.getMemoryUsage();
                if (useCache) {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 270000L), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 280000L));
                } else {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                }
            } else {
                Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)memoryUsage);
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)memoryUsage);
            }
            totalRows += page.getPositionCount();
        }
        memoryUsage = -1L;
        while (totalRows < 50000) {
            Assert.assertFalse((boolean)pageSource.isFinished());
            page = pageSource.getNextPage();
            Assert.assertNotNull((Object)page);
            block = page.getBlock(1);
            if (memoryUsage == -1L) {
                if (useCache) {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 2000L));
                } else {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1000L));
                }
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                memoryUsage = pageSource.getMemoryUsage();
                if (useCache) {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 260000L), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 270000L));
                } else {
                    Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(360000L), (Comparable)Long.valueOf(369999L));
                }
            } else {
                Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)memoryUsage);
                VarcharType.createUnboundedVarcharType().getSlice(block, block.getPositionCount() - 1);
                Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)memoryUsage);
            }
            totalRows += page.getPositionCount();
        }
        Assert.assertFalse((boolean)pageSource.isFinished());
        Assert.assertNull((Object)pageSource.getNextPage());
        Assert.assertTrue((boolean)pageSource.isFinished());
        if (useCache) {
            Assertions.assertBetweenInclusive((Comparable)Long.valueOf(pageSource.getMemoryUsage()), (Comparable)Long.valueOf(this.testPreparer.getFileSize()), (Comparable)Long.valueOf(this.testPreparer.getFileSize() + 200L));
        } else {
            Assert.assertEquals((long)pageSource.getMemoryUsage(), (long)0L);
        }
        pageSource.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="rowCount")
    public void testMaxReadBytes(int rowCount) throws Exception {
        int maxReadBytes = 1000;
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig(), new HiveFormatsConfig(), new OrcReaderConfig().setMaxBlockSize(DataSize.ofBytes((long)maxReadBytes)), new OrcWriterConfig(), new ParquetReaderConfig(), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        int numColumns = 5;
        int step = 250;
        ImmutableList.Builder columnBuilder = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> "", true));
        GrowingTestColumn[] dataColumns = new GrowingTestColumn[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            dataColumns[i] = new GrowingTestColumn("p_string_" + i, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, () -> Long.toHexString(this.random.nextLong()), false, step * (i + 1));
            columnBuilder.add((Object)dataColumns[i]);
        }
        ImmutableList testColumns = columnBuilder.build();
        File tempFile = File.createTempFile("trino_test_orc_page_source_max_read_bytes", "orc");
        tempFile.delete();
        TestPreparer testPreparer = new TestPreparer(tempFile.getAbsolutePath(), (List<TestColumn>)testColumns, rowCount, rowCount);
        ConnectorPageSource pageSource = testPreparer.newPageSource(stats, (ConnectorSession)session);
        try {
            int positionCount = 0;
            while (true) {
                Page page = pageSource.getNextPage();
                if (pageSource.isFinished()) break;
                Assert.assertNotNull((Object)page);
                if ((positionCount += (page = page.getLoadedPage()).getPositionCount()) <= 8196) continue;
                Assert.assertTrue((page.getSizeInBytes() < (long)(maxReadBytes * (8196 / step)) || 1 == page.getPositionCount() ? 1 : 0) != 0);
            }
            Distribution distribution = stats.getMaxCombinedBytesPerRow().getAllTime();
            Assert.assertEquals((int)((int)distribution.getCount()), (int)1);
            Assert.assertEquals((int)((int)distribution.getMax()), (int)(Arrays.stream(dataColumns).mapToInt(GrowingTestColumn::getMaxSize).sum() + 5 * numColumns));
            pageSource.close();
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testTableScanOperator() {
        int totalRows;
        Page page;
        DriverContext driverContext = this.testPreparer.newDriverContext();
        SourceOperator operator = this.testPreparer.newTableScanOperator(driverContext);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
        long memoryUsage = -1L;
        for (totalRows = 0; totalRows < 20000; totalRows += page.getPositionCount()) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            page.getBlock(1);
            if (memoryUsage == -1L) {
                memoryUsage = driverContext.getMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
                continue;
            }
            Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)memoryUsage);
        }
        memoryUsage = -1L;
        while (totalRows < 40000) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            page.getBlock(1);
            if (memoryUsage == -1L) {
                memoryUsage = driverContext.getMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(460000L), (Comparable)Long.valueOf(469999L));
            } else {
                Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)memoryUsage);
            }
            totalRows += page.getPositionCount();
        }
        memoryUsage = -1L;
        while (totalRows < 50000) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            page.getBlock(1);
            if (memoryUsage == -1L) {
                memoryUsage = driverContext.getMemoryUsage();
                Assertions.assertBetweenInclusive((Comparable)Long.valueOf(memoryUsage), (Comparable)Long.valueOf(360000L), (Comparable)Long.valueOf(369999L));
            } else {
                Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)memoryUsage);
            }
            totalRows += page.getPositionCount();
        }
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertTrue((boolean)operator.isFinished());
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    @Test
    public void testScanFilterAndProjectOperator() {
        Page page;
        DriverContext driverContext = this.testPreparer.newDriverContext();
        SourceOperator operator = this.testPreparer.newScanFilterAndProjectOperator(driverContext);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
        for (int totalRows = 0; totalRows < 50000; totalRows += page.getPositionCount()) {
            Assert.assertFalse((boolean)operator.isFinished());
            page = operator.getOutput();
            Assert.assertNotNull((Object)page);
            long memoryUsage = driverContext.getMemoryUsage();
            Assert.assertTrue((memoryUsage < 1000L || memoryUsage > 150000L && memoryUsage < 630000L ? 1 : 0) != 0, (String)String.format("Memory usage (%s) outside of bounds", memoryUsage));
        }
        Assert.assertNull((Object)operator.getOutput());
        Assert.assertTrue((boolean)operator.isFinished());
        Assertions.assertBetweenInclusive((Comparable)Long.valueOf(driverContext.getMemoryUsage()), (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(500L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSplit createTestFile(String filePath, Serializer serializer, String compressionCodec, List<TestColumn> testColumns, int numRows, int stripeRows) throws Exception {
        testColumns = (List)testColumns.stream().filter(column -> !column.isPartitionKey()).collect(ImmutableList.toImmutableList());
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", testColumns.stream().map(TestColumn::getName).collect(Collectors.joining(",")));
        tableProperties.setProperty("columns.types", testColumns.stream().map(TestColumn::getType).collect(Collectors.joining(",")));
        serializer.initialize(CONFIGURATION, tableProperties);
        JobConf jobConf = new JobConf(ConfigurationInstantiator.newEmptyConfiguration());
        if (compressionCodec != null) {
            CompressionCodec codec = new CompressionCodecFactory(CONFIGURATION).getCodecByName(compressionCodec);
            jobConf.set("mapreduce.output.fileoutputformat.compress.codec", codec.getClass().getName());
            jobConf.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
        }
        FileSinkOperator.RecordWriter recordWriter = TestOrcPageSourceMemoryTracking.createRecordWriter(new Path(filePath), CONFIGURATION);
        try {
            StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)((List)testColumns.stream().map(TestColumn::getName).collect(ImmutableList.toImmutableList())), (List)((List)testColumns.stream().map(TestColumn::getObjectInspector).collect(ImmutableList.toImmutableList())));
            Object row = objectInspector.create();
            ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
            for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
                for (int i = 0; i < testColumns.size(); ++i) {
                    Object writeValue = ((TestColumn)testColumns.get(i)).getWriteValue();
                    if (writeValue instanceof Slice) {
                        writeValue = ((Slice)writeValue).getBytes();
                    }
                    objectInspector.setStructFieldData(row, (StructField)fields.get(i), writeValue);
                }
                Writable record = serializer.serialize(row, (ObjectInspector)objectInspector);
                recordWriter.write(record);
                if (rowNumber % stripeRows != stripeRows - 1) continue;
                TestOrcPageSourceMemoryTracking.flushStripe(recordWriter);
            }
        }
        finally {
            recordWriter.close(false);
        }
        Path path = new Path(filePath);
        path.getFileSystem(CONFIGURATION).setVerifyChecksum(true);
        File file = new File(filePath);
        return new FileSplit(path, 0L, file.length(), new String[0]);
    }

    private static void flushStripe(FileSinkOperator.RecordWriter recordWriter) {
        try {
            Field writerField = OrcOutputFormat.class.getClassLoader().loadClass(ORC_RECORD_WRITER).getDeclaredField("writer");
            writerField.setAccessible(true);
            Writer writer = (Writer)writerField.get(recordWriter);
            Method flushStripe = WriterImpl.class.getDeclaredMethod("flushStripe", new Class[0]);
            flushStripe.setAccessible(true);
            flushStripe.invoke((Object)writer, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileSinkOperator.RecordWriter createRecordWriter(Path target, Configuration conf) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(FileSystem.class.getClassLoader());){
            OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf).memory((MemoryManager)new NullMemoryManager()).compress(CompressionKind.ZLIB);
            try {
                FileSinkOperator.RecordWriter recordWriter = WRITER_CONSTRUCTOR.newInstance(target, options);
                return recordWriter;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Constructor<? extends FileSinkOperator.RecordWriter> getOrcWriterConstructor() {
        try {
            Constructor<FileSinkOperator.RecordWriter> constructor = OrcOutputFormat.class.getClassLoader().loadClass(ORC_RECORD_WRITER).asSubclass(FileSinkOperator.RecordWriter.class).getDeclaredConstructor(Path.class, OrcFile.WriterOptions.class);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TestColumn {
        private final String name;
        private final ObjectInspector objectInspector;
        private final Supplier<?> writeValue;
        private final boolean partitionKey;

        public TestColumn(String name, ObjectInspector objectInspector, Supplier<?> writeValue, boolean partitionKey) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.objectInspector = Objects.requireNonNull(objectInspector, "objectInspector is null");
            this.writeValue = writeValue;
            this.partitionKey = partitionKey;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.objectInspector.getTypeName();
        }

        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }

        public Object getWriteValue() {
            return this.writeValue.get();
        }

        public boolean isPartitionKey() {
            return this.partitionKey;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("TestColumn{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", objectInspector=").append(this.objectInspector);
            sb.append(", partitionKey=").append(this.partitionKey);
            sb.append('}');
            return sb.toString();
        }
    }

    private class TestPreparer {
        private final FileSplit fileSplit;
        private final Properties schema;
        private final List<HiveColumnHandle> columns;
        private final List<Type> types;
        private final String partitionName;
        private final List<HivePartitionKey> partitionKeys;
        private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"TestOrcPageSourceMemoryTracking-executor-%s"));
        private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"TestOrcPageSourceMemoryTracking-scheduledExecutor-%s"));

        public TestPreparer(String tempFilePath) throws Exception {
            this(tempFilePath, testOrcPageSourceMemoryTracking.testColumns, 50000, 20000);
        }

        public TestPreparer(String tempFilePath, List<TestColumn> testColumns, int numRows, int stripeRows) throws Exception {
            OrcSerde serde = new OrcSerde();
            this.schema = new Properties();
            this.schema.setProperty("columns", testColumns.stream().map(TestColumn::getName).collect(Collectors.joining(",")));
            this.schema.setProperty("columns.types", testColumns.stream().map(TestColumn::getType).collect(Collectors.joining(",")));
            this.schema.setProperty("file.inputformat", OrcInputFormat.class.getName());
            this.schema.setProperty("serialization.lib", serde.getClass().getName());
            this.partitionKeys = testColumns.stream().filter(TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
            this.partitionName = String.join((CharSequence)"/", (Iterable)this.partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.getName(), partitionKey.getValue())).collect(ImmutableList.toImmutableList()));
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            int nextHiveColumnIndex = 0;
            for (TestColumn testColumn : testColumns) {
                int columnIndex = testColumn.isPartitionKey() ? -1 : nextHiveColumnIndex++;
                ObjectInspector inspector = testColumn.getObjectInspector();
                HiveType hiveType = HiveType.valueOf((String)inspector.getTypeName());
                Type type = hiveType.getType(InternalTypeManager.TESTING_TYPE_MANAGER);
                columnsBuilder.add((Object)HiveColumnHandle.createBaseColumn((String)testColumn.getName(), (int)columnIndex, (HiveType)hiveType, (Type)type, (HiveColumnHandle.ColumnType)(testColumn.isPartitionKey() ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR), Optional.empty()));
                typesBuilder.add((Object)type);
            }
            this.columns = columnsBuilder.build();
            this.types = typesBuilder.build();
            this.fileSplit = TestOrcPageSourceMemoryTracking.createTestFile(tempFilePath, (Serializer)serde, null, testColumns, numRows, stripeRows);
        }

        public long getFileSize() {
            return this.fileSplit.getLength();
        }

        public ConnectorPageSource newPageSource() {
            return this.newPageSource(new FileFormatDataSourceStats(), UNCACHED_SESSION);
        }

        public ConnectorPageSource newPageSource(FileFormatDataSourceStats stats, ConnectorSession session) {
            OrcPageSourceFactory orcPageSourceFactory = new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, stats, DateTimeZone.UTC);
            List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)this.partitionName, this.partitionKeys, this.columns, (List)ImmutableList.of(), (TableToPartitionMapping)TableToPartitionMapping.empty(), (Path)this.fileSplit.getPath(), (OptionalInt)OptionalInt.empty(), (long)this.fileSplit.getLength(), (long)Instant.now().toEpochMilli());
            return (ConnectorPageSource)HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)orcPageSourceFactory), (Set)ImmutableSet.of(), (Configuration)ConfigurationInstantiator.newEmptyConfiguration(), (ConnectorSession)session, (Path)this.fileSplit.getPath(), (OptionalInt)OptionalInt.empty(), (long)this.fileSplit.getStart(), (long)this.fileSplit.getLength(), (long)this.fileSplit.getLength(), (Properties)this.schema, (TupleDomain)TupleDomain.all(), this.columns, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), Optional.empty(), (boolean)false, Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION, (List)columnMappings).orElseThrow();
        }

        public SourceOperator newTableScanOperator(DriverContext driverContext) {
            ConnectorPageSource pageSource = this.newPageSource();
            TableScanOperator.TableScanOperatorFactory sourceOperatorFactory = new TableScanOperator.TableScanOperatorFactory(0, new PlanNodeId("0"), (session, split, table, columnHandles, dynamicFilter) -> pageSource, TestingHandles.TEST_TABLE_HANDLE, (Iterable)this.columns.stream().map(ColumnHandle.class::cast).collect(ImmutableList.toImmutableList()), DynamicFilter.EMPTY);
            SourceOperator operator = sourceOperatorFactory.createOperator(driverContext);
            operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
            return operator;
        }

        public SourceOperator newScanFilterAndProjectOperator(DriverContext driverContext) {
            ConnectorPageSource pageSource = this.newPageSource();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            for (int i = 0; i < this.types.size(); ++i) {
                projectionsBuilder.add((Object)Expressions.field((int)i, (Type)this.types.get(i)));
            }
            Supplier cursorProcessor = EXPRESSION_COMPILER.compileCursorProcessor(Optional.empty(), (List)projectionsBuilder.build(), (Object)"key");
            Supplier pageProcessor = EXPRESSION_COMPILER.compilePageProcessor(Optional.empty(), (List)projectionsBuilder.build());
            ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory sourceOperatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, table, columnHandles, dynamicFilter) -> pageSource, cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)this.columns.stream().map(ColumnHandle.class::cast).collect(Collectors.toList()), DynamicFilter.EMPTY, this.types, DataSize.ofBytes((long)0L), 0);
            SourceOperator operator = sourceOperatorFactory.createOperator(driverContext);
            operator.addSplit(new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
            operator.noMoreSplits();
            return operator;
        }

        private DriverContext newDriverContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)TestingSession.testSessionBuilder().build()).addPipelineContext(0, true, true, false).addDriverContext();
        }
    }

    public static final class GrowingTestColumn
    extends TestColumn {
        private final Supplier<String> writeValue;
        private final int step;
        private int counter;
        private int maxSize;

        public GrowingTestColumn(String name, ObjectInspector objectInspector, Supplier<String> writeValue, boolean partitionKey, int step) {
            super(name, objectInspector, writeValue, partitionKey);
            this.writeValue = writeValue;
            this.counter = step;
            this.step = step;
        }

        @Override
        public Object getWriteValue() {
            StringBuilder builder = new StringBuilder();
            String source = this.writeValue.get();
            builder.append(source.repeat(Math.max(0, this.counter / this.step)));
            ++this.counter;
            if (builder.length() > this.maxSize) {
                this.maxSize = builder.length();
            }
            return builder.toString();
        }

        public int getMaxSize() {
            return this.maxSize;
        }
    }
}

