/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.io.Resources;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.orc.OriginalFilesUtils;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.TestingConnectorSession;
import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOriginalFilesUtils {
    private String tablePath;

    @BeforeClass
    public void setup() throws Exception {
        this.tablePath = new File(Resources.getResource((String)"dummy_id_data_orc").toURI()).getPath();
    }

    @Test
    public void testGetPrecedingRowCountSingleFile() {
        ArrayList<AcidInfo.OriginalFileInfo> originalFileInfoList = new ArrayList<AcidInfo.OriginalFileInfo>();
        originalFileInfoList.add(new AcidInfo.OriginalFileInfo("000001_0", 730L));
        long rowCountResult = OriginalFilesUtils.getPrecedingRowCount(originalFileInfoList, (Path)new Path(this.tablePath + "/000001_0"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, (ConnectorIdentity)TestingConnectorSession.SESSION.getIdentity(), (OrcReaderOptions)new OrcReaderOptions(), (FileFormatDataSourceStats)new FileFormatDataSourceStats());
        Assert.assertEquals((long)rowCountResult, (long)0L, (String)"Original file should have 0 as the starting row count");
    }

    @Test
    public void testGetPrecedingRowCount() {
        ArrayList<AcidInfo.OriginalFileInfo> originalFileInfos = new ArrayList<AcidInfo.OriginalFileInfo>();
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0", 741L));
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0_copy_1", 768L));
        originalFileInfos.add(new AcidInfo.OriginalFileInfo("000002_0_copy_2", 743L));
        long rowCountResult = OriginalFilesUtils.getPrecedingRowCount(originalFileInfos, (Path)new Path(this.tablePath + "/000002_0_copy_2"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, (ConnectorIdentity)TestingConnectorSession.SESSION.getIdentity(), (OrcReaderOptions)new OrcReaderOptions(), (FileFormatDataSourceStats)new FileFormatDataSourceStats());
        Assert.assertEquals((long)rowCountResult, (long)8L, (String)"Original file 000002_0_copy_2 should have 8 as the starting row count");
    }
}

